/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid.client;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import org.apache.axis.client.Stub;
import org.ecoinformatics.ecogrid.EcogridQueryParser;
import org.ecoinformatics.ecogrid.EcogridResultsetTransformer;
import org.ecoinformatics.ecogrid.EcogridUtils;
import org.ecoinformatics.ecogrid.QueryType;
import org.ecoinformatics.ecogrid.ResultsetType;
import org.ecoinformatics.ecogrid.stub.EcoGridQueryInterfaceLevelOnePortType;
import org.ecoinformatics.ecogrid.stub.service.EcoGridQueryLevelOneServiceGridLocator;
import org.globus.ogsa.utils.GridServiceFactory;
import org.gridforum.ogsi.Factory;
import org.gridforum.ogsi.LocatorType;
import org.gridforum.ogsi.OGSIServiceGridLocator;

public class EcogridFactoryQueryClient {
    private EcoGridQueryInterfaceLevelOnePortType ecogrid;

    public EcogridFactoryQueryClient(String serviceURL) throws Exception {
        EcogridUtils.setDebug((boolean)true);
        long startFactory = System.currentTimeMillis();
        OGSIServiceGridLocator gridLocator = new OGSIServiceGridLocator();
        Factory factory = gridLocator.getFactoryPort(new URL(serviceURL));
        GridServiceFactory ecogridQueryFactory = new GridServiceFactory(factory);
        long endFacotry = System.currentTimeMillis();
        EcogridUtils.debugMessage((String)("The time to create factory is ============= " + (endFacotry - startFactory) / 1000L), (int)30);
        LocatorType locator = ecogridQueryFactory.createService();
        EcoGridQueryLevelOneServiceGridLocator loc = new EcoGridQueryLevelOneServiceGridLocator();
        this.ecogrid = loc.getEcoGridQueryLevelOneServicePort(locator);
        Stub stub = (Stub)this.ecogrid;
        stub.setTimeout(10000000);
        long endInstance = System.currentTimeMillis();
        EcogridUtils.debugMessage((String)("The time to create instance is =========== " + (endInstance - endFacotry) / 1000L), (int)30);
    }

    public ResultsetType query(QueryType query) throws Exception {
        ResultsetType result = null;
        if (this.ecogrid != null) {
            long startQuery = System.currentTimeMillis();
            result = this.ecogrid.query(query);
            long endQuery = System.currentTimeMillis();
            EcogridUtils.debugMessage((String)("The query time is ==============" + (startQuery - endQuery) / 1000L), (int)30);
        }
        return result;
    }

    public ResultsetType query(Reader queryText) {
        ResultsetType result = null;
        try {
            EcogridQueryParser parser = new EcogridQueryParser(queryText);
            parser.parseXML();
            QueryType query = parser.getEcogridQuery();
            result = this.query(query);
        }
        catch (Exception e) {
            System.err.println("ERROR!");
            e.printStackTrace();
        }
        return result;
    }

    public byte[] get(String identifier) throws Exception {
        if (this.ecogrid != null) {
            return this.ecogrid.get(identifier);
        }
        return null;
    }

    public void destroy() throws Exception {
        if (this.ecogrid != null) {
            this.ecogrid.destroy();
        }
    }

    public static void main(String[] args) {
        block3: {
            if (args.length != 3) {
                EcogridUtils.debugMessage((String)"Usage: java  EcogridQueryClient GSH query_filename docid ");
                System.exit(0);
            }
            String GSH = args[0];
            String queryFileName = args[1];
            String docid = args[2];
            try {
                EcogridFactoryQueryClient client = new EcogridFactoryQueryClient(GSH);
                File queryXMLFile = new File(queryFileName);
                FileReader xmlReader = new FileReader(queryXMLFile);
                ResultsetType result = client.query(xmlReader);
                String resultXML = EcogridResultsetTransformer.toXMLString((ResultsetType)result);
                EcogridUtils.debugMessage((String)resultXML);
                byte[] content = client.get(docid);
                EcogridUtils.debugMessage((String)new String(content));
                client.destroy();
            }
            catch (Exception e) {
                EcogridUtils.debugMessage((String)("Exception in main : " + e.getMessage()), (int)20);
                if (!EcogridUtils.printStackTraceByEnv()) break block3;
                e.printStackTrace();
            }
        }
    }
}

