/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid.digir.impl;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.axis.types.URI;
import org.ecoinformatics.ecogrid.EcogridResultsetTransformer;
import org.ecoinformatics.ecogrid.EcogridUtils;
import org.ecoinformatics.ecogrid.MetaDataNameSpaceInfo;
import org.ecoinformatics.ecogrid.MetaDataSystemInfo;
import org.ecoinformatics.ecogrid.ResultsetType;
import org.ecoinformatics.ecogrid.ResultsetType_record;
import org.ecoinformatics.ecogrid.ResultsetType_record_returnField;
import org.ecoinformatics.ecogrid.ResultsetType_resultsetMetadata;
import org.ecoinformatics.ecogrid.ResultsetType_resultsetMetadata_namespace;
import org.ecoinformatics.ecogrid.ResultsetType_resultsetMetadata_recordStructure;
import org.ecoinformatics.ecogrid.ResultsetType_resultsetMetadata_recordStructure_returnField;
import org.ecoinformatics.ecogrid.ResultsetType_resultsetMetadata_system;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DigirJavaToEcogridJavaResultsetTransformer {
    private static final String DOCUMENT = "document";
    private static final String HEADER = "header";
    private static final String SENDTIME = "sendtime";
    private static final String SOURCE = "source";
    private static final String RESOURCE = "resource";
    private static final String CONTENT = "content";
    private static final String RECORD = "record";
    private static final String DARWIN = "darwin";
    private ResultsetType_resultsetMetadata mMetadata = null;
    private Hashtable mContentAttrHashtable = new Hashtable();
    private Hashtable mNameSpaceHashtable = new Hashtable();
    private String mSendDateTime = "";
    private Hashtable mSystemHashtable = new Hashtable();
    private Hashtable mRecordIdHash = new Hashtable();
    private long mRecNum = 0L;

    protected int countRecords(Node aNode) {
        String name;
        int count = 0;
        String string = name = aNode.getNodeName() != null ? aNode.getNodeName().trim() : "";
        if (name.equalsIgnoreCase(RECORD)) {
            ++count;
        }
        NodeList list = aNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            count += this.countRecords(child);
        }
        return count;
    }

    protected MetaDataNameSpaceInfo checkNameSpaceFromNodeName(String aStr, StringBuffer aNodeName, StringBuffer aNameSpace, Hashtable aLocalNSHashTable) {
        EcogridUtils.parseForNameAndNamespace((String)aStr, (StringBuffer)aNodeName, (StringBuffer)aNameSpace);
        MetaDataNameSpaceInfo nsItem = null;
        if (aNameSpace.length() > 0) {
            nsItem = MetaDataNameSpaceInfo.lookupByPrefix((String)aNameSpace.toString(), (Hashtable)this.mNameSpaceHashtable);
        }
        return nsItem;
    }

    protected String getNonNullStr(String aStr) {
        if (aStr != null) {
            return aStr;
        }
        return "";
    }

    protected void processContent(Node aContent, String aSystemId, Vector aRecords, Hashtable aLocalNSHashTable) {
        if (aContent == null || aRecords == null) {
            return;
        }
        NodeList list = aContent.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                String name;
                Node recordNode = list.item(i);
                if (recordNode == null) continue;
                String string = name = recordNode.getNodeName() != null ? recordNode.getNodeName().trim() : "";
                if (!name.equalsIgnoreCase(RECORD)) continue;
                String recContentStr = "";
                String institutionCode = "";
                String collectionCode = "";
                String catalogNumber = "";
                Vector<ResultsetType_record_returnField> returnFieldVect = new Vector<ResultsetType_record_returnField>();
                NodeList childList = recordNode.getChildNodes();
                for (int j = 0; j < childList.getLength(); ++j) {
                    Node recChildNode = childList.item(j);
                    if (recChildNode == null || recChildNode.getNodeType() == 3) continue;
                    String nodeName = recChildNode.getNodeName() != null ? recChildNode.getNodeName().trim() : "";
                    String value = EcogridUtils.escapeHTML((String)EcogridUtils.getNodeValue((Node)recChildNode));
                    StringBuffer nodeNameStr = new StringBuffer();
                    StringBuffer nameSpace = new StringBuffer();
                    MetaDataNameSpaceInfo nsItem = this.checkNameSpaceFromNodeName(nodeName, nodeNameStr, nameSpace, aLocalNSHashTable);
                    if (nodeNameStr.toString().equals("InstitutionCode")) {
                        institutionCode = this.getNonNullStr(EcogridUtils.getNodeValue((Node)recChildNode));
                        continue;
                    }
                    if (nodeNameStr.toString().equals("CollectionCode")) {
                        collectionCode = this.getNonNullStr(EcogridUtils.getNodeValue((Node)recChildNode));
                        continue;
                    }
                    if (nodeNameStr.toString().equals("CatalogNumber")) {
                        String catNum = this.getNonNullStr(EcogridUtils.getNodeValue((Node)recChildNode));
                        if (catNum.length() <= 0) continue;
                        catalogNumber = catNum;
                        continue;
                    }
                    if (nodeNameStr.toString().equals("CatalogNumberText")) {
                        if (catalogNumber.length() != 0) continue;
                        catalogNumber = this.getNonNullStr(EcogridUtils.getNodeValue((Node)recChildNode));
                        continue;
                    }
                    if (nsItem != null) {
                        ResultsetType_record_returnField field = EcogridUtils.createRecordReturnField(null, (String)nodeNameStr.toString(), (String)value);
                        returnFieldVect.add(field);
                        int id = nsItem.addFieldUsesNS(nodeNameStr.toString());
                        field.setId(Integer.toString(id));
                        continue;
                    }
                    EcogridUtils.debugMessage((String)("**** Error Skipping [" + nodeName + "]  [" + value + "] because of namespace."));
                }
                ResultsetType_record_returnField[] returnFieldList = new ResultsetType_record_returnField[returnFieldVect.size()];
                for (int j = 0; j < returnFieldVect.size(); ++j) {
                    returnFieldList[j] = (ResultsetType_record_returnField)returnFieldVect.get(j);
                }
                String uniqueId = institutionCode + ":" + collectionCode + ":" + catalogNumber;
                if (institutionCode.length() == 0 || collectionCode.length() == 0 || catalogNumber.length() == 0) {
                    System.err.println("Unique Identifier not complete: " + uniqueId);
                    continue;
                }
                if (this.mRecordIdHash.get(uniqueId) == null) {
                    ResultsetType_record record = new ResultsetType_record();
                    record.setNumber(this.mRecNum++);
                    record.setSystem(aSystemId);
                    record.setIdentifier(uniqueId);
                    record.setReturnField(returnFieldList);
                    aRecords.addElement(record);
                    this.mRecordIdHash.put(uniqueId, "1");
                    continue;
                }
                System.err.println("***** Duplicate: " + uniqueId);
            }
        }
    }

    protected void buildRecordsFromResponse(Node aResponse, ResultsetType aEcogridResult, Vector aRecords) {
        String resource;
        Node header = EcogridUtils.findNode((Node)aResponse, (String)HEADER);
        if (header == null) {
            EcogridUtils.debugMessage((String)"** Error: Header node is null!");
            return;
        }
        Node content = EcogridUtils.findNode((Node)aResponse, (String)CONTENT);
        if (content == null) {
            EcogridUtils.debugMessage((String)"** Error: Content node is null!");
            return;
        }
        if (this.countRecords(content) == 0) {
            return;
        }
        this.mSendDateTime = EcogridUtils.findNodeValue((Node)header, (String)SENDTIME);
        String source = EcogridUtils.findNodeValue((Node)header, (String)SOURCE);
        String fullResourceName = MetaDataSystemInfo.getName((String)source, (String)(resource = EcogridUtils.findAttrValueForNode((Node)header, (String)SOURCE, (String)RESOURCE)));
        MetaDataSystemInfo systemItem = (MetaDataSystemInfo)this.mSystemHashtable.get(fullResourceName);
        if (systemItem == null) {
            systemItem = new MetaDataSystemInfo(source, resource);
            this.mSystemHashtable.put(systemItem.toString(), systemItem);
        }
        int systemId = systemItem.getId();
        NamedNodeMap map = content.getAttributes();
        if (map == null) {
            EcogridUtils.debugMessage((String)"** Error: Content node's NamedNodeMap is null!");
            return;
        }
        Hashtable<String, MetaDataNameSpaceInfo> localNSHashtable = new Hashtable<String, MetaDataNameSpaceInfo>();
        for (int i = 0; i < map.getLength(); ++i) {
            Node node = map.item(i);
            if (node == null) continue;
            String name = node.getNodeName() != null ? node.getNodeName().trim() : null;
            String value = node.getNodeValue() != null ? node.getNodeValue().trim() : null;
            int inx = name.indexOf(58);
            if (inx != -1) {
                String fullNSName;
                MetaDataNameSpaceInfo nsItem;
                String xmlns = name.substring(0, inx);
                String nameSpace = name.substring(inx + 1, name.length());
                if (xmlns.equalsIgnoreCase("xmlns") && (nsItem = (MetaDataNameSpaceInfo)this.mNameSpaceHashtable.get(fullNSName = MetaDataNameSpaceInfo.getName((String)nameSpace, (String)value))) == null) {
                    nsItem = new MetaDataNameSpaceInfo(nameSpace, value);
                    this.mNameSpaceHashtable.put(fullNSName, nsItem);
                    localNSHashtable.put(nameSpace, nsItem);
                }
                this.mContentAttrHashtable.put(name, value);
                continue;
            }
            this.mContentAttrHashtable.put(name, value);
        }
        this.processContent(content, Integer.toString(systemId), aRecords, localNSHashtable);
    }

    public ResultsetType transform(File aResultsetFile) throws Exception {
        if (aResultsetFile == null) {
            EcogridUtils.debugMessage((String)"** Error: Resultset File is null!");
            return null;
        }
        if (aResultsetFile.length() == 0L) {
            EcogridUtils.debugMessage((String)"** Error: Resultset file has zero length!");
            return null;
        }
        Document dom = EcogridUtils.readXMLFile2DOM((String)aResultsetFile.getAbsolutePath());
        if (dom == null) {
            EcogridUtils.debugMessage((String)"** Error: DOM tree is null!");
            return null;
        }
        return this.transform(dom);
    }

    public ResultsetType transform(Document aDOM) throws Exception {
        Enumeration e;
        if (aDOM == null) {
            EcogridUtils.debugMessage((String)"** Error: DOM tree is null!");
            return null;
        }
        Node responseWrapper = EcogridUtils.findNode((Node)aDOM, (String)"responseWrapper");
        if (responseWrapper == null) {
            EcogridUtils.debugMessage((String)"** Error: responseWrapper tree is null!");
            return null;
        }
        Vector records = new Vector();
        ResultsetType ecogridResult = new ResultsetType();
        ecogridResult.setSystem(new URI("http://knb.ecoinformatics.org"));
        ecogridResult.setResultsetId("digir.001");
        this.mMetadata = new ResultsetType_resultsetMetadata();
        ecogridResult.setResultsetMetadata(this.mMetadata);
        NodeList responseWrapperList = responseWrapper.getChildNodes();
        if (responseWrapperList != null) {
            boolean recId = false;
            for (int i = 0; i < responseWrapperList.getLength(); ++i) {
                Node response = responseWrapperList.item(i);
                if (response == null || !response.getNodeName().equals("response")) continue;
                this.buildRecordsFromResponse(response, ecogridResult, records);
            }
        }
        if (this.mSystemHashtable.size() > 0) {
            ResultsetType_resultsetMetadata_system[] systems = new ResultsetType_resultsetMetadata_system[this.mSystemHashtable.size()];
            int inx = 0;
            e = this.mSystemHashtable.elements();
            while (e.hasMoreElements()) {
                MetaDataSystemInfo systemInfo = (MetaDataSystemInfo)e.nextElement();
                String urlStr = systemInfo.toString();
                urlStr = urlStr.replaceAll(" ", "%20");
                systems[inx++] = EcogridUtils.createSystem((String)urlStr, (String)Integer.toString(systemInfo.getId()));
            }
            this.mMetadata.setSystem(systems);
        }
        if (this.mNameSpaceHashtable.size() > 0) {
            int darwinCnt = MetaDataNameSpaceInfo.countNumNSWithFields((Hashtable)this.mNameSpaceHashtable);
            if (darwinCnt == 1) {
                Enumeration<Object> e2 = this.mNameSpaceHashtable.elements();
                while (e2.hasMoreElements()) {
                    MetaDataNameSpaceInfo nsInfo = (MetaDataNameSpaceInfo)e2.nextElement();
                    if (nsInfo.getNumFieldsUsingNS() <= 0) continue;
                    ResultsetType_resultsetMetadata_namespace[] nameSpaces = new ResultsetType_resultsetMetadata_namespace[]{EcogridUtils.createNameSpace((String)nsInfo.getNameSpaceURI(), null)};
                    this.mMetadata.setNamespace(nameSpaces);
                    break;
                }
                e2 = records.elements();
                while (e2.hasMoreElements()) {
                    ResultsetType_record record = (ResultsetType_record)e2.nextElement();
                    ResultsetType_record_returnField[] fields = record.getReturnField();
                    for (int j = 0; j < fields.length; ++j) {
                        fields[j].setId(null);
                    }
                }
            } else {
                Vector<ResultsetType_resultsetMetadata_recordStructure> recordStructs = new Vector<ResultsetType_resultsetMetadata_recordStructure>();
                e = this.mNameSpaceHashtable.elements();
                while (e.hasMoreElements()) {
                    MetaDataNameSpaceInfo nsInfo = (MetaDataNameSpaceInfo)e.nextElement();
                    ResultsetType_resultsetMetadata_recordStructure struct = new ResultsetType_resultsetMetadata_recordStructure();
                    struct.setNamespace(nsInfo.getNameSpaceURI());
                    if (nsInfo.getNumFieldsUsingNS() <= 0) continue;
                    Hashtable fieldsHashtable = nsInfo.getFieldsHashtable();
                    ResultsetType_resultsetMetadata_recordStructure_returnField[] fields = new ResultsetType_resultsetMetadata_recordStructure_returnField[fieldsHashtable.size()];
                    int inx = 0;
                    Enumeration ef = fieldsHashtable.keys();
                    while (ef.hasMoreElements()) {
                        String fieldName = (String)ef.nextElement();
                        Integer id = (Integer)fieldsHashtable.get(fieldName);
                        fields[inx++] = EcogridUtils.createRecordStructReturnField((String)id.toString(), null, (String)fieldName);
                    }
                    struct.setReturnField(fields);
                    recordStructs.addElement(struct);
                }
                ResultsetType_resultsetMetadata_recordStructure[] structs = new ResultsetType_resultsetMetadata_recordStructure[recordStructs.size()];
                int inx = 0;
                Enumeration e3 = recordStructs.elements();
                while (e3.hasMoreElements()) {
                    structs[inx++] = (ResultsetType_resultsetMetadata_recordStructure)e3.nextElement();
                }
                this.mMetadata.setRecordStructure(structs);
            }
        }
        StringBuffer allContentAttrs = new StringBuffer();
        Enumeration e4 = this.mContentAttrHashtable.keys();
        while (e4.hasMoreElements()) {
            String name = (String)e4.nextElement();
            String value = (String)this.mContentAttrHashtable.get(name);
            allContentAttrs.append(name + "=\"" + value + "\"\n  ");
        }
        ecogridResult.setAttrs(allContentAttrs.toString());
        this.mMetadata.setSendTime(EcogridUtils.getCalendarDate((String)this.mSendDateTime));
        ResultsetType_record[] recordsArray = null;
        if (records.size() > 0) {
            recordsArray = new ResultsetType_record[records.size()];
            for (int j = 0; j < records.size(); ++j) {
                recordsArray[j] = (ResultsetType_record)records.get(j);
            }
            this.mMetadata.setStartRecord(1L);
            this.mMetadata.setEndRecord((long)recordsArray.length);
            this.mMetadata.setRecordCount((long)recordsArray.length);
            ecogridResult.setRecord(recordsArray);
        } else {
            this.mMetadata.setStartRecord(0L);
            this.mMetadata.setEndRecord(0L);
            this.mMetadata.setRecordCount(0L);
        }
        return ecogridResult;
    }

    public static void main(String[] args) {
        File file = new File("/home/globus/workspace/kepler/portal_query_none.xml");
        DigirJavaToEcogridJavaResultsetTransformer transformer = new DigirJavaToEcogridJavaResultsetTransformer();
        try {
            ResultsetType rs = transformer.transform(file);
            String rsStr = EcogridResultsetTransformer.toXMLString((ResultsetType)rs);
            System.out.println(rsStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e);
        }
    }
}

