/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.client.metadata.rdf.xslt;

import com.ibm.lsid.LSID;
import com.ibm.lsid.MalformedLSIDException;
import com.ibm.lsid.MetadataResponse;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.client.metadata.LSIDMetadata;
import com.ibm.lsid.client.metadata.LSIDMetadataException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XSLTMetadata
implements LSIDMetadata {
    private static final String RDF_STYLE_SHEET = "rdf-canonicalize.xsl";
    private static final String RDF_NS_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String I3CP_NS_URI = "urn:lsid:i3c.org:predicates:";
    private static final String DC_NS_URI = "http://purl.org/dc/elements/1.1/";
    private static final String RDF_PREFIX = "rdf";
    private static final String I3CP_PREFIX = "i3cp";
    private static final String DC_PREFIX = "dc";
    private static final String RDF_DOCS_ELT = "RDF-DOCS";
    private static final String RDF_ELT = "RDF";
    private static final String DESCRIPTION_ELT = "Description";
    private static final String EXPIRES_ATTR = "expires";
    private static final String PATH_TO_DESCRIPTION = "rdf:RDF/rdf:Description";
    private TransformerFactory factory = TransformerFactory.newInstance();
    private Document doc;
    private Element rdfDocs;
    private Element envNS;

    void init() throws LSIDMetadataException {
        try {
            DocumentBuilder documentBuilder = new DocumentBuilderFactoryImpl().newDocumentBuilder();
            this.doc = documentBuilder.newDocument();
            this.rdfDocs = this.doc.createElement(RDF_DOCS_ELT);
            this.doc.appendChild(this.rdfDocs);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new LSIDMetadataException(parserConfigurationException, "Internal error preparing rdf store");
        }
        this.envNS = this.doc.createElement("nsmappings");
        this.envNS.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:rdf", RDF_NS_URI);
        this.envNS.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:i3cp", I3CP_NS_URI);
        this.envNS.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:dc", DC_NS_URI);
    }

    public Document getDocument() {
        return this.doc;
    }

    /*
     * Loose catch block
     */
    public void addMetadata(MetadataResponse metadataResponse) throws LSIDMetadataException {
        Date date;
        Object object;
        Object object2;
        InputStream inputStream;
        byte[] byArray;
        block12: {
            byArray = null;
            InputStream inputStream2 = null;
            inputStream2 = metadataResponse.getMetadata();
            inputStream = this.getClass().getResourceAsStream(RDF_STYLE_SHEET);
            object2 = this.factory.newTransformer(new StreamSource(inputStream));
            object = new ByteArrayOutputStream();
            ((Transformer)object2).transform(new StreamSource(inputStream2), new StreamResult((OutputStream)object));
            byArray = ((ByteArrayOutputStream)object).toByteArray();
            date = null;
            try {
                if (inputStream2 != null) {
                    inputStream2.close();
                }
                break block12;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            break block12;
            {
                catch (TransformerException transformerException) {
                    throw new LSIDMetadataException(transformerException, "Error applying transform to RDF");
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable;
            }
        }
        try {
            inputStream = new DOMParser();
            inputStream.parse(new InputSource(new ByteArrayInputStream(byArray)));
            object2 = inputStream.getDocument();
            object = (Element)object2.getFirstChild();
            Element element = (Element)this.doc.importNode((Node)object, true);
            this.rdfDocs.appendChild(element);
            date = metadataResponse.getExpires();
            if (date != null) {
                element.setAttribute(EXPIRES_ATTR, String.valueOf(date.getTime()));
            }
        }
        catch (Exception exception) {
            throw new LSIDMetadataException(exception, "Error parsing formatted RDF");
        }
    }

    public LSID getAbstract(LSID lSID) throws LSIDMetadataException {
        try {
            String string = "rdf:RDF/rdf:Description/i3cp:storedas[@rdf:resource=\"" + lSID + "\"]/parent::node()/@rdf:about";
            Attr attr = (Attr)XPathAPI.selectSingleNode((Node)this.rdfDocs, (String)string, (Node)this.envNS);
            if (attr == null) {
                return null;
            }
            LSID lSID2 = new LSID(attr.getNodeValue());
            lSID.setAbstr(lSID2);
            return lSID2;
        }
        catch (TransformerException transformerException) {
            throw new LSIDMetadataException(transformerException, "Error doing Xpath for getAbstract()");
        }
        catch (MalformedLSIDException malformedLSIDException) {
            throw new LSIDMetadataException(malformedLSIDException, "bad lsid in meta data, getAbstract()");
        }
    }

    public String getFormat(LSID lSID) throws LSIDMetadataException {
        try {
            String string = "rdf:RDF/rdf:Description[@rdf:about=\"" + lSID + "\"]" + "/dc:format/@rdf:resource";
            Attr attr = (Attr)XPathAPI.selectSingleNode((Node)this.rdfDocs, (String)string, (Node)this.envNS);
            if (attr == null) {
                return null;
            }
            String string2 = attr.getNodeValue();
            lSID.setFormat(string2);
            return string2;
        }
        catch (TransformerException transformerException) {
            throw new LSIDMetadataException(transformerException, "Error doing Xpath for getFormat()");
        }
    }

    public LSID[] getInstances(LSID lSID) throws LSIDMetadataException {
        try {
            String string = "rdf:RDF/rdf:Description[@rdf:about=\"" + lSID + "\"]" + "/i3cp:storedas/@rdf:resource";
            NodeList nodeList = XPathAPI.selectNodeList((Node)this.rdfDocs, (String)string, (Node)this.envNS);
            if (nodeList == null) {
                return null;
            }
            LSID[] lSIDArray = new LSID[nodeList.getLength()];
            int n = 0;
            while (n < nodeList.getLength()) {
                Attr attr = (Attr)nodeList.item(n);
                LSID lSID2 = new LSID(attr.getNodeValue());
                this.getFormat(lSID2);
                lSID2.setAbstr(lSID);
                lSIDArray[n] = lSID2;
                ++n;
            }
            return lSIDArray;
        }
        catch (TransformerException transformerException) {
            throw new LSIDMetadataException(transformerException, "Error doing Xpath for getInstances()");
        }
        catch (MalformedLSIDException malformedLSIDException) {
            throw new LSIDMetadataException(malformedLSIDException, "bad lsid in meta data, getInstances()");
        }
    }

    public String getType(LSID lSID) throws LSIDMetadataException {
        try {
            String string = "rdf:RDF/rdf:Description[@rdf:about=\"" + lSID + "\"]" + "/rdf:type/@rdf:resource";
            Attr attr = (Attr)XPathAPI.selectSingleNode((Node)this.rdfDocs, (String)string, (Node)this.envNS);
            if (attr == null) {
                return null;
            }
            String string2 = attr.getNodeValue();
            lSID.setType(string2);
            return string2;
        }
        catch (TransformerException transformerException) {
            throw new LSIDMetadataException(transformerException, "Error doing Xpath for getType()");
        }
    }

    public LSIDAuthority[] getForeignAuthorities(LSID lSID) throws LSIDMetadataException {
        try {
            String string = "rdf:RDF/rdf:Description[@rdf:about=\"" + lSID + "\"]" + "/i3cp:foreignauthority/child::text()";
            NodeList nodeList = XPathAPI.selectNodeList((Node)this.rdfDocs, (String)string, (Node)this.envNS);
            if (nodeList == null) {
                return null;
            }
            LSIDAuthority[] lSIDAuthorityArray = new LSIDAuthority[nodeList.getLength()];
            int n = 0;
            while (n < nodeList.getLength()) {
                String string2 = nodeList.item(n).getNodeValue();
                lSIDAuthorityArray[n] = new LSIDAuthority(string2);
                ++n;
            }
            return lSIDAuthorityArray;
        }
        catch (TransformerException transformerException) {
            throw new LSIDMetadataException(transformerException, "Error doing Xpath for getInstances()");
        }
        catch (MalformedLSIDException malformedLSIDException) {
            throw new LSIDMetadataException(malformedLSIDException, "bad lsid in meta data, getInstances()");
        }
    }
}

