/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.axis.types.URI;
import org.ecoinformatics.ecogrid.EcogridResultsetTransformer;
import org.ecoinformatics.ecogrid.EcogridUtils;
import org.ecoinformatics.ecogrid.ResultsetType;
import org.ecoinformatics.ecogrid.ResultsetType_record;
import org.ecoinformatics.ecogrid.ResultsetType_record_returnField;
import org.ecoinformatics.ecogrid.ResultsetType_resultsetMetadata;
import org.ecoinformatics.ecogrid.ResultsetType_resultsetMetadata_namespace;
import org.ecoinformatics.ecogrid.ResultsetType_resultsetMetadata_recordStructure;
import org.ecoinformatics.ecogrid.ResultsetType_resultsetMetadata_recordStructure_returnField;
import org.ecoinformatics.ecogrid.ResultsetType_resultsetMetadata_system;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EcogridResultsetParser {
    private static final String RETURNFIELD = "returnfield";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String RECORD = "record";
    private static final String RESULTSETID = "resultsetId";
    private static final String NUMBER = "number";
    private static final String SYSTEM = "system";
    private static final String IDENTIFIER = "identifier";
    private static final String CREATIONDATE = "creationDate";
    private static final String LASTMODIFIEDDATE = "lastModifiedDate";
    private static final String NAMESPACE = "namespace";
    private static final String RECORDSTRUCTURE = "recordStructure";
    private static final String RECORDCOUNT = "recordCount";
    private static final String STARTRECORD = "startRecord";
    private static final String ENDRECORD = "endRecord";
    private static final String SENDTIME = "sendTime";
    private static final String PREFIX = "prefix";
    private static final String RESULTSETMETADATA = "resultsetMetadata";

    protected static boolean checkHomogeneousOfRecords(Node aResultsetNode) {
        int numRows = 0;
        boolean isFirstRow = true;
        Vector<String> rowDef = new Vector<String>();
        NodeList list = aResultsetNode.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                NodeList recChildlist;
                Node child = list.item(i);
                if (!child.getNodeName().equals(RECORD) || (recChildlist = child.getChildNodes()) == null) continue;
                int cnt = 0;
                for (int j = 0; j < recChildlist.getLength(); ++j) {
                    Node retFld = recChildlist.item(j);
                    if (!retFld.getNodeName().equals(RETURNFIELD)) continue;
                    String id = EcogridUtils.findAttrValue(retFld, ID);
                    if (id == null || id.length() == 0) {
                        id = EcogridUtils.findAttrValue(retFld, NAME);
                    }
                    if (isFirstRow) {
                        rowDef.add(id);
                    } else if (!id.equals((String)rowDef.elementAt(cnt))) {
                        return false;
                    }
                    ++cnt;
                }
                if (isFirstRow) {
                    numRows = cnt;
                    isFirstRow = false;
                    continue;
                }
                if (cnt == numRows) continue;
                return false;
            }
        }
        return true;
    }

    protected static String makeRow(Node aRecord, boolean isHomogeneous, boolean aDoHeader, Hashtable aIdHash) {
        StringBuffer htmlStr = new StringBuffer();
        NodeList recChildlist = aRecord.getChildNodes();
        if (recChildlist != null) {
            htmlStr.append("<tr>\n");
            if (aDoHeader) {
                htmlStr.append("<td><center><b>Record Number</b></center></td>");
                htmlStr.append("<td><center><b>System</b></center></td>");
                htmlStr.append("<td><center><b>Identifier</b></center></td>");
            } else {
                htmlStr.append("<td><center>" + EcogridUtils.findAttrValue(aRecord, NUMBER) + "</center></td>");
                htmlStr.append("<td><center>" + EcogridUtils.findAttrValue(aRecord, SYSTEM) + "</center></td>");
                htmlStr.append("<td><center>" + EcogridUtils.findAttrValue(aRecord, IDENTIFIER) + "</center></td>");
            }
            if (!isHomogeneous && !aDoHeader) {
                htmlStr.append("<td><center><table border=1 width=100%>");
            }
            for (int j = 0; j < recChildlist.getLength(); ++j) {
                Node retFld = recChildlist.item(j);
                String name = retFld.getNodeName();
                if (!retFld.getNodeName().equals(RETURNFIELD)) continue;
                if (!isHomogeneous) {
                    String val;
                    String id;
                    if (aDoHeader) {
                        htmlStr.append("<td><center><b>Return Fields</b></center></td>");
                        break;
                    }
                    String fldName = EcogridUtils.findAttrValue(retFld, NAME);
                    if ((fldName == null || fldName.length() == 0) && (id = EcogridUtils.findAttrValue(retFld, ID)).length() > 0) {
                        fldName = (String)aIdHash.get(id);
                    }
                    if (fldName == null || fldName.length() == 0) {
                        fldName = "N/A";
                    }
                    if ((val = EcogridUtils.getNodeValue(retFld).trim()).length() == 0) {
                        val = "&nbsp;";
                    }
                    htmlStr.append("<tr><td><center><b>" + fldName + "</b></center></td>");
                    htmlStr.append("<td><center>" + val + "</center></td></tr>");
                    continue;
                }
                if (aDoHeader) {
                    htmlStr.append("<td><center><b>" + EcogridUtils.findAttrValue(retFld, NAME) + "</b></center></td>");
                    continue;
                }
                htmlStr.append("<td><center>" + EcogridUtils.getNodeValue(retFld) + "</center></td>");
            }
            if (!isHomogeneous && !aDoHeader) {
                htmlStr.append("</table></td>");
            }
            htmlStr.append("</tr>\n");
        }
        return htmlStr.toString();
    }

    protected static Node getResultSetNode(Node aDOM) {
        NodeList list = aDOM.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node child = list.item(i);
                if (!child.getNodeName().endsWith("resultset")) continue;
                return child;
            }
        }
        return null;
    }

    public static String formatResultsetToHTMLTableUsingDOM(String aResultset) {
        Node recStruct;
        String ns;
        Node system;
        Node namespace;
        StringBuffer htmlStr = new StringBuffer();
        Hashtable<String, String> idHash = new Hashtable<String, String>();
        Document dom = EcogridUtils.convertXMLStr2DOM(aResultset);
        Node metadata = EcogridUtils.findNode(dom, RESULTSETMETADATA);
        Node resultset = EcogridResultsetParser.getResultSetNode(dom);
        if (metadata == null || resultset == null) {
            return "";
        }
        htmlStr.append("<table border=0 style=\"border: 1px solid black;\">\n<tr><td colspan=\"4\"><center><b><span style=\"font-size:14pt;\">Metadata</span></b></center></td></tr>\n");
        htmlStr.append("<tr><td><center><table border=1><tr><td><center><b>sendTime</b></center></td><td><center><b>startRecord</b></center></td><td><center><b>endRecord</b></center></td><td><center><b>recordCount</b></center></td></tr>\n");
        htmlStr.append("<td><center>" + EcogridUtils.findNodeValue(metadata, SENDTIME) + "</center></td>");
        htmlStr.append("<td><center>" + EcogridUtils.findNodeValue(metadata, STARTRECORD) + "</center></td>");
        htmlStr.append("<td><center>" + EcogridUtils.findNodeValue(metadata, ENDRECORD) + "</center></td>");
        htmlStr.append("<td><center>" + EcogridUtils.findNodeValue(metadata, RECORDCOUNT) + "</center></td>");
        htmlStr.append("</tr></table></center></td></tr>\n");
        if (namespace != null) {
            htmlStr.append("<tr><td colspan=\"4\"><span style=\"font-size:6pt;\">&nbsp;</span></td></tr>\n");
            htmlStr.append("<tr><td colspan=\"4\"><center><table border=1 width=100%>");
            htmlStr.append("<tr><td><center><b>Prefix</b></center></td><td><center><b>Namespace</b></center></td></tr>");
            for (namespace = EcogridUtils.findNode(metadata, NAMESPACE); namespace != null; namespace = namespace.getNextSibling()) {
                if (!namespace.getNodeName().equals(NAMESPACE)) continue;
                String prefix = EcogridUtils.findAttrValue(namespace, PREFIX);
                prefix = prefix == null ? "" : prefix;
                String ns2 = EcogridUtils.getNodeValue(namespace);
                ns2 = ns2 == null ? "" : ns2;
                htmlStr.append("<tr><td><center>" + (prefix.length() > 0 ? prefix : "N/A") + "</center></td>");
                htmlStr.append("<td><center>" + ns2 + "</center></td></tr>\n");
            }
            htmlStr.append("</table></center></td></tr>");
        }
        if ((system = EcogridUtils.findNode(metadata, SYSTEM)) != null) {
            htmlStr.append("<tr><td colspan=\"4\"><span style=\"font-size:6pt;\">&nbsp;</span></td></tr>\n");
            htmlStr.append("<tr><td colspan=\"4\"><center><table border=1 width=100%>");
            htmlStr.append("<tr><td><center><b>Id</b></center></td><td><center><b>System</b></center></td></tr>");
            while (system != null) {
                if (system.getNodeName().equals(SYSTEM)) {
                    String id = EcogridUtils.findAttrValue(system, ID);
                    id = id == null ? "" : id;
                    ns = EcogridUtils.getNodeValue(system);
                    ns = ns == null ? "" : ns;
                    htmlStr.append("<tr><td><center>" + (id.length() > 0 ? id : "N/A") + "</center></td>");
                    htmlStr.append("<td><center>" + ns + "</center></td></tr>\n");
                }
                system = system.getNextSibling();
            }
            htmlStr.append("</table></center></td></tr>");
        }
        if ((recStruct = EcogridUtils.findNode(metadata, RECORDSTRUCTURE)) != null) {
            htmlStr.append("<tr><td colspan=\"4\"><span style=\"font-size:6pt;\">&nbsp;</span></td></tr>\n");
            htmlStr.append("<tr><td colspan=\"4\"><center><table border=1 width=100%>");
            while (recStruct != null) {
                if (recStruct.getNodeName().equals(RECORDSTRUCTURE)) {
                    ns = EcogridUtils.findAttrValue(recStruct, NAMESPACE);
                    ns = ns == null ? "" : ns;
                    htmlStr.append("<tr><td colspan=2><center>" + ns + "</center></td></tr>");
                    htmlStr.append("<tr><td><center><b>Id</b></center></td><td><center><b>Record Structure</b></center></td></tr>");
                    for (Node retFld = EcogridUtils.findNode(recStruct, RETURNFIELD); retFld != null; retFld = retFld.getNextSibling()) {
                        if (!retFld.getNodeName().equals(RETURNFIELD)) continue;
                        String id = EcogridUtils.findAttrValue(retFld, ID);
                        id = id == null ? "" : id;
                        String name = EcogridUtils.findAttrValue(retFld, NAME);
                        name = name == null ? "" : name;
                        htmlStr.append("<tr><td><center>" + id + "</center></td>");
                        htmlStr.append("<td><center>" + name + "</center></td></tr>\n");
                        idHash.put(id, name);
                    }
                }
                recStruct = recStruct.getNextSibling();
            }
            htmlStr.append("</table></center></td></tr>");
        }
        htmlStr.append("</table>\n<br>");
        htmlStr.append("<table border=1>");
        boolean isHomogeneous = EcogridResultsetParser.checkHomogeneousOfRecords(resultset);
        boolean isFirstRow = true;
        NodeList list = resultset.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node child = list.item(i);
                if (!child.getNodeName().equals(RECORD)) continue;
                if (isFirstRow) {
                    htmlStr.append(EcogridResultsetParser.makeRow(child, isHomogeneous, true, idHash));
                    isFirstRow = false;
                }
                htmlStr.append(EcogridResultsetParser.makeRow(child, isHomogeneous, false, idHash));
            }
        }
        return htmlStr.toString();
    }

    public static int countNodes(Node aNode, String aNodeName) {
        NodeList list;
        int cnt = 0;
        if (aNode.getNodeName().equalsIgnoreCase(aNodeName)) {
            ++cnt;
        }
        if (aNode.hasChildNodes() && (list = aNode.getChildNodes()) != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node child = list.item(i);
                cnt += EcogridResultsetParser.countNodes(child, aNodeName);
            }
        }
        return cnt;
    }

    public static void buildSystemsObjects(Node aMetadata, ResultsetType_resultsetMetadata_system[] aSystems) {
        int inx = 0;
        NodeList list = aMetadata.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node child = list.item(i);
                if (!child.getNodeName().equalsIgnoreCase(SYSTEM)) continue;
                aSystems[inx] = new ResultsetType_resultsetMetadata_system(EcogridUtils.getNodeValue(child));
                aSystems[inx].setId(EcogridUtils.findAttrValue(child, ID));
                ++inx;
            }
        }
    }

    public static void buildNamespaceObjects(Node aMetadata, ResultsetType_resultsetMetadata_namespace[] aNamespaces) {
        int inx = 0;
        NodeList list = aMetadata.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node child = list.item(i);
                if (!child.getNodeName().equalsIgnoreCase(NAMESPACE)) continue;
                aNamespaces[inx] = new ResultsetType_resultsetMetadata_namespace(EcogridUtils.getNodeValue(child));
                aNamespaces[inx].setPrefix(EcogridUtils.findAttrValue(child, PREFIX));
                ++inx;
            }
        }
    }

    public static void buildReturnFieldsObjects(Node aRecStruct, ResultsetType_resultsetMetadata_recordStructure_returnField[] aRetFields) {
        int inx = 0;
        NodeList list = aRecStruct.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node child = list.item(i);
                if (!child.getNodeName().equalsIgnoreCase(RETURNFIELD)) continue;
                aRetFields[inx] = new ResultsetType_resultsetMetadata_recordStructure_returnField();
                aRetFields[inx].setId(EcogridUtils.findAttrValue(child, ID));
                aRetFields[inx].setName(EcogridUtils.findAttrValue(child, NAME));
                aRetFields[inx].setPathns(EcogridUtils.findAttrValue(child, "pathNS"));
                ++inx;
            }
        }
    }

    public static void buildRecStructObjects(Node aMetadata, ResultsetType_resultsetMetadata_recordStructure[] aRecStructs) {
        int inx = 0;
        NodeList list = aMetadata.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node child = list.item(i);
                if (!child.getNodeName().equalsIgnoreCase(RECORDSTRUCTURE)) continue;
                aRecStructs[inx] = new ResultsetType_resultsetMetadata_recordStructure();
                aRecStructs[inx].setNamespace(EcogridUtils.findAttrValue(child, NAMESPACE));
                int numItems = EcogridResultsetParser.countNodes(child, RETURNFIELD);
                ResultsetType_resultsetMetadata_recordStructure_returnField[] retFields = null;
                if (numItems > 0) {
                    retFields = new ResultsetType_resultsetMetadata_recordStructure_returnField[numItems];
                    EcogridResultsetParser.buildReturnFieldsObjects(child, retFields);
                }
                aRecStructs[inx].setReturnField(retFields);
                ++inx;
            }
        }
    }

    private static long getLong(String aVal) {
        long val = 0L;
        if (aVal != null) {
            try {
                val = Long.parseLong(aVal);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return val;
    }

    public static ResultsetType_resultsetMetadata parseMetadata(Node aMetaDataNode) {
        int numItems = EcogridResultsetParser.countNodes(aMetaDataNode, SYSTEM);
        System.out.println("Number of System: " + numItems);
        ResultsetType_resultsetMetadata_system[] systems = null;
        if (numItems > 0) {
            systems = new ResultsetType_resultsetMetadata_system[numItems];
            EcogridResultsetParser.buildSystemsObjects(aMetaDataNode, systems);
        }
        numItems = EcogridResultsetParser.countNodes(aMetaDataNode, NAMESPACE);
        System.out.println("Number of namespace: " + numItems);
        ResultsetType_resultsetMetadata_namespace[] namespaces = null;
        if (numItems > 0) {
            namespaces = new ResultsetType_resultsetMetadata_namespace[numItems];
            EcogridResultsetParser.buildNamespaceObjects(aMetaDataNode, namespaces);
        }
        numItems = EcogridResultsetParser.countNodes(aMetaDataNode, RECORDSTRUCTURE);
        System.out.println("Number of recordStructure: " + numItems);
        ResultsetType_resultsetMetadata_recordStructure[] recStructs = null;
        if (numItems > 0) {
            recStructs = new ResultsetType_resultsetMetadata_recordStructure[numItems];
            EcogridResultsetParser.buildRecStructObjects(aMetaDataNode, recStructs);
        }
        ResultsetType_resultsetMetadata md = new ResultsetType_resultsetMetadata();
        md.setRecordCount(EcogridResultsetParser.getLong(EcogridUtils.findNodeValue(aMetaDataNode, RECORDCOUNT)));
        md.setStartRecord(EcogridResultsetParser.getLong(EcogridUtils.findNodeValue(aMetaDataNode, STARTRECORD)));
        md.setEndRecord(EcogridResultsetParser.getLong(EcogridUtils.findNodeValue(aMetaDataNode, ENDRECORD)));
        md.setSendTime(EcogridUtils.getCalendarDate(EcogridUtils.findNodeValue(aMetaDataNode, SENDTIME)));
        md.setNamespace(namespaces);
        md.setRecordStructure(recStructs);
        md.setSystem(systems);
        return md;
    }

    public static void buildReturnFieldsObjects(Node aRecStruct, ResultsetType_record_returnField[] aRetFields) {
        int inx = 0;
        NodeList list = aRecStruct.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node child = list.item(i);
                if (!child.getNodeName().equalsIgnoreCase(RETURNFIELD)) continue;
                aRetFields[inx] = new ResultsetType_record_returnField();
                aRetFields[inx].setId(EcogridUtils.findAttrValue(child, ID));
                aRetFields[inx].setName(EcogridUtils.findAttrValue(child, NAME));
                aRetFields[inx].setContent(EcogridUtils.getNodeValue(child));
                ++inx;
            }
        }
    }

    public static void buildRecordsObjects(Node aRecNode, ResultsetType_record[] aRecStructs) {
        int inx = 0;
        NodeList list = aRecNode.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node child = list.item(i);
                if (!child.getNodeName().equalsIgnoreCase(RECORD)) continue;
                aRecStructs[inx] = new ResultsetType_record();
                aRecStructs[inx].setIdentifier(EcogridUtils.findAttrValue(child, IDENTIFIER));
                aRecStructs[inx].setCreationDate(EcogridUtils.getCalendarDate(EcogridUtils.findAttrValue(child, CREATIONDATE)));
                aRecStructs[inx].setLastModifiedDate(EcogridUtils.getCalendarDate(EcogridUtils.findAttrValue(child, LASTMODIFIEDDATE)));
                aRecStructs[inx].setNumber(EcogridResultsetParser.getLong(EcogridUtils.findAttrValue(child, NUMBER)));
                aRecStructs[inx].setSystem(EcogridUtils.findAttrValue(child, SYSTEM));
                int numItems = EcogridResultsetParser.countNodes(child, RETURNFIELD);
                ResultsetType_record_returnField[] retFields = null;
                if (numItems > 0) {
                    retFields = new ResultsetType_record_returnField[numItems];
                    EcogridResultsetParser.buildReturnFieldsObjects(child, retFields);
                }
                aRecStructs[inx].setReturnField(retFields);
                ++inx;
            }
        }
    }

    public static ResultsetType_record[] parseRecords(Node aRecordNode) {
        int numItems = EcogridResultsetParser.countNodes(aRecordNode, RECORD);
        ResultsetType_record[] records = null;
        if (numItems > 0) {
            records = new ResultsetType_record[numItems];
            EcogridResultsetParser.buildRecordsObjects(aRecordNode, records);
        }
        return records;
    }

    public static ResultsetType parseXMLFile(String aFileName) {
        Document dom = EcogridUtils.readXMLFile2DOM(aFileName);
        if (dom != null) {
            return EcogridResultsetParser.parse(dom);
        }
        return null;
    }

    public static ResultsetType parse(Document aDOM) {
        if (aDOM == null) {
            return null;
        }
        Node metadata = EcogridUtils.findNode(aDOM, RESULTSETMETADATA);
        Node resultset = EcogridResultsetParser.getResultSetNode(aDOM);
        if (metadata == null || resultset == null) {
            return null;
        }
        ResultsetType resultSet = new ResultsetType();
        ResultsetType_resultsetMetadata metaData = EcogridResultsetParser.parseMetadata(metadata);
        resultSet.setResultsetMetadata(metaData);
        resultSet.setRecord(EcogridResultsetParser.parseRecords(resultset));
        resultSet.setResultsetId(EcogridUtils.findAttrValue(resultset, RESULTSETID));
        try {
            resultSet.setSystem(new URI(EcogridUtils.findAttrValue(resultset, SYSTEM)));
        }
        catch (Exception e) {
            // empty catch block
        }
        StringBuffer attrs = new StringBuffer();
        NamedNodeMap map = resultset.getAttributes();
        if (map != null) {
            for (int i = 0; i < map.getLength(); ++i) {
                Node item = map.item(i);
                if (item.getNodeName().equalsIgnoreCase(RESULTSETID) || item.getNodeName().equalsIgnoreCase(SYSTEM)) continue;
                if (attrs.length() == 0) {
                    attrs.append(" ");
                }
                attrs.append(item.toString());
            }
        }
        if (attrs.length() > 0) {
            resultSet.setAttrs(attrs.toString());
        }
        return resultSet;
    }

    public static void main(String[] args) {
        ResultsetType rs = EcogridResultsetParser.parseXMLFile("/home/globus/workspace/kepler/rs.xml");
        String rsStr = EcogridResultsetTransformer.toXMLString(rs);
        System.out.println(rsStr);
    }
}

