/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid;

import java.util.Enumeration;
import java.util.Hashtable;

public class MetaDataNameSpaceInfo {
    private static int gIdTracker = 0;
    private static int gFieldIdTracker = 0;
    protected String mPrefix;
    protected String mNameSpaceURI;
    protected int mId;
    protected Hashtable mFieldsDefineInNameSpace = new Hashtable();

    public MetaDataNameSpaceInfo(String aPrefix, String aNameSpaceURI) {
        this.mPrefix = aPrefix;
        this.mNameSpaceURI = aNameSpaceURI;
        this.mId = gIdTracker++;
    }

    public int addFieldUsesNS(String aFieldName) {
        Integer id = (Integer)this.mFieldsDefineInNameSpace.get(aFieldName);
        if (id == null) {
            id = new Integer(gFieldIdTracker);
            ++gFieldIdTracker;
            this.mFieldsDefineInNameSpace.put(aFieldName, id);
        }
        return id;
    }

    public int getNumFieldsUsingNS() {
        return this.mFieldsDefineInNameSpace.size();
    }

    public Hashtable getFieldsHashtable() {
        return this.mFieldsDefineInNameSpace;
    }

    public String getPrefix() {
        return this.mPrefix;
    }

    public String getNameSpaceURI() {
        return this.mNameSpaceURI;
    }

    public int getId() {
        return this.mId;
    }

    public String toString() {
        return MetaDataNameSpaceInfo.getName(this.mPrefix, this.mNameSpaceURI);
    }

    public static String getName(String aPrefix, String aNameSpaceURI) {
        return aPrefix + ":" + aNameSpaceURI;
    }

    public static MetaDataNameSpaceInfo lookupByPrefix(String aPrefix, Hashtable aHashtable) {
        Enumeration e = aHashtable.elements();
        while (e.hasMoreElements()) {
            MetaDataNameSpaceInfo nsInfo = (MetaDataNameSpaceInfo)e.nextElement();
            if (!nsInfo.getPrefix().equals(aPrefix)) continue;
            return nsInfo;
        }
        return null;
    }

    public static int countNumNSWithFields(Hashtable aHashtable) {
        int cnt = 0;
        Enumeration e = aHashtable.elements();
        while (e.hasMoreElements()) {
            MetaDataNameSpaceInfo nsInfo = (MetaDataNameSpaceInfo)e.nextElement();
            if (nsInfo.getNumFieldsUsingNS() <= 0) continue;
            ++cnt;
        }
        return cnt;
    }
}

