/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms.encryption;

import java.security.Key;
import org.apache.log4j.Category;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.algorithms.encryption.params.EncryptionMethodParams;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class EncryptionMethodSpi {
    static Category cat = Category.getInstance((String)(class$org$apache$xml$security$algorithms$encryption$EncryptionMethodSpi == null ? (class$org$apache$xml$security$algorithms$encryption$EncryptionMethodSpi = EncryptionMethodSpi.class$("org.apache.xml.security.algorithms.encryption.EncryptionMethodSpi")) : class$org$apache$xml$security$algorithms$encryption$EncryptionMethodSpi).getName());
    public static final int ALGOTYPE_BLOCK_ENCRYPTION = 1;
    public static final int ALGOTYPE_STREAM_ENCRYPTION = 2;
    public static final int ALGOTYPE_KEY_TRANSPORT = 3;
    public static final int ALGOTYPE_SYMMETRIC_KEY_WRAP = 4;
    public static final int ALGOTYPE_KEY_AGREEMENT = 5;
    static /* synthetic */ Class class$org$apache$xml$security$algorithms$encryption$EncryptionMethodSpi;

    public boolean getRequiredProviderAvailable() {
        String string = this.getRequiredProviderName();
        if (JCEMapper.getProviderIsRegisteredAtSecurity(string)) {
            return true;
        }
        if (JCEMapper.getProviderIsInClassPath(string)) {
            return JCEMapper.addProvider(string);
        }
        return false;
    }

    protected String getImplementedAlgorithmJCE() {
        JCEMapper.ProviderIdClass providerIdClass = JCEMapper.translateURItoJCEID(this.getImplementedAlgorithmURI(), this.getRequiredProviderName());
        return providerIdClass.getAlgorithmID();
    }

    public abstract int getImplementedAlgorithmType();

    public abstract String getImplementedAlgorithmURI();

    public abstract String getRequiredProviderName();

    public abstract int engineGetBlockSize();

    public abstract int engineGetIvLength();

    public abstract byte[] engineEncrypt(byte[] var1, Key var2) throws XMLSecurityException;

    public abstract byte[] engineEncrypt(byte[] var1, Key var2, byte[] var3) throws XMLSecurityException;

    public abstract byte[] engineDecrypt(byte[] var1, Key var2) throws XMLSecurityException;

    public abstract byte[] engineWrap(Key var1, Key var2) throws XMLSecurityException;

    public abstract byte[] engineWrap(Key var1, Key var2, byte[] var3) throws XMLSecurityException;

    public abstract Key engineUnwrap(byte[] var1, Key var2, String var3) throws XMLSecurityException;

    public abstract EncryptionMethodParams engineInit(Document var1, EncryptionMethodParams var2) throws XMLSecurityException;

    public abstract EncryptionMethodParams engineInit(Element var1) throws XMLSecurityException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

