/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.algorithms.encryption.implementations.BC;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.algorithms.encryption.EncryptionMethodSpi;
import org.apache.xml.security.algorithms.encryption.helper.AESWrapper;
import org.apache.xml.security.algorithms.encryption.params.EncryptionMethodParams;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class KeyWrapImpl_AES_BC
extends EncryptionMethodSpi {
    Cipher _cipher;

    public abstract String getRequiredProviderName();

    public abstract String getImplementedAlgorithmURI();

    public int getImplementedAlgorithmType() {
        return 4;
    }

    public int engineGetBlockSize() {
        return this._cipher.getBlockSize();
    }

    public abstract int engineGetIvLength();

    public EncryptionMethodParams engineInit(Document document, EncryptionMethodParams encryptionMethodParams) throws XMLSecurityException {
        if (encryptionMethodParams != null) {
            throw new XMLSecurityException("encryption.algorithmCannotEatInitParams");
        }
        try {
            this._cipher = Cipher.getInstance(this.getImplementedAlgorithmJCE(), this.getRequiredProviderName());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLSecurityException("empty", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new XMLSecurityException("empty", noSuchProviderException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new XMLSecurityException("empty", noSuchPaddingException);
        }
        return encryptionMethodParams;
    }

    public EncryptionMethodParams engineInit(Element element) throws XMLSecurityException {
        if (element.getChildNodes().getLength() != 0) {
            throw new XMLSecurityException("encryption.algorithmCannotEatInitParams");
        }
        try {
            this._cipher = Cipher.getInstance(this.getImplementedAlgorithmJCE(), this.getRequiredProviderName());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new XMLSecurityException("empty", noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new XMLSecurityException("empty", noSuchProviderException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new XMLSecurityException("empty", noSuchPaddingException);
        }
        return null;
    }

    public byte[] engineWrap(Key key, Key key2) throws XMLSecurityException {
        return this.engineWrap(key, key2, null);
    }

    public byte[] engineWrap(Key key, Key key2, byte[] byArray) throws XMLSecurityException {
        if (byArray != null && byArray.length != 8) {
            throw new XMLSecurityException("empty");
        }
        AESWrapper aESWrapper = new AESWrapper(this._cipher);
        return aESWrapper.wrap(key, key2, byArray);
    }

    public Key engineUnwrap(byte[] byArray, Key key, String string) throws XMLSecurityException {
        try {
            String string2 = JCEMapper.translateURItoJCEID(string, this.getRequiredProviderName()).getAlgorithmID();
            int n = JCEMapper.getKeyTypeFromURI(string);
            AESWrapper aESWrapper = new AESWrapper(this._cipher);
            byte[] byArray2 = aESWrapper.unwrap(byArray, key);
            if (n == 3) {
                return new SecretKeySpec(byArray2, string2);
            }
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(string2, this.getRequiredProviderName());
                if (n == 1) {
                    return keyFactory.generatePublic(new X509EncodedKeySpec(byArray2));
                }
                if (n == 2) {
                    return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(byArray2));
                }
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new InvalidKeyException("Unknown key type " + noSuchProviderException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidKeyException("Unknown key type " + noSuchAlgorithmException.getMessage());
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException("Unknown key type " + invalidKeySpecException.getMessage());
            }
            throw new InvalidKeyException("Unknown key type " + n);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSecurityException("empty", invalidKeyException);
        }
    }

    public byte[] engineEncrypt(byte[] byArray, Key key) throws XMLSecurityException {
        throw new XMLSecurityException("encryption.algorithmCannotEncryptDecrypt");
    }

    public byte[] engineEncrypt(byte[] byArray, Key key, byte[] byArray2) throws XMLSecurityException {
        throw new XMLSecurityException("encryption.algorithmCannotEncryptDecrypt");
    }

    public byte[] engineDecrypt(byte[] byArray, Key key) throws XMLSecurityException {
        throw new XMLSecurityException("encryption.algorithmCannotEncryptDecrypt");
    }
}

