/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c14n.helper;

import org.apache.xml.security.c14n.CanonicalizationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class C14nHelper {
    private C14nHelper() {
    }

    public static final String normalizeAttr(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string == null ? 0 : string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\t': {
                    stringBuffer.append("&#x9;");
                    break;
                }
                case '\n': {
                    stringBuffer.append("&#xA;");
                    break;
                }
                case '\r': {
                    stringBuffer.append("&#xD;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static final String normalizeComment(String string) {
        return C14nHelper.normalizeProcessingInstruction(string);
    }

    public static final String normalizeProcessingInstruction(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string == null ? 0 : string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\r': {
                    stringBuffer.append("&#xD;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static final String normalizeText(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string == null ? 0 : string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '\r': {
                    stringBuffer.append("&#xD;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static boolean namespaceIsRelative(Attr attr) {
        return !C14nHelper.namespaceIsAbsolute(attr);
    }

    public static boolean namespaceIsRelative(String string) {
        return !C14nHelper.namespaceIsAbsolute(string);
    }

    public static boolean namespaceIsAbsolute(Attr attr) {
        return C14nHelper.namespaceIsAbsolute(attr.getValue());
    }

    public static boolean namespaceIsAbsolute(String string) {
        if (string.length() == 0) {
            return true;
        }
        boolean bl = false;
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == ':') {
                bl = true;
            } else if (!bl && c == '/') {
                return false;
            }
            ++n2;
        }
        return bl;
    }

    public static void assertNotRelativeNS(Attr attr) throws CanonicalizationException {
        if (attr == null) {
            return;
        }
        String string = attr.getNodeName();
        boolean bl = string.equals("xmlns");
        boolean bl2 = string.startsWith("xmlns:");
        if ((bl || bl2) && C14nHelper.namespaceIsRelative(attr)) {
            String string2 = attr.getOwnerElement().getTagName();
            String string3 = attr.getValue();
            Object[] objectArray = new Object[]{string2, string, string3};
            throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", objectArray);
        }
    }

    public static void checkTraversability(Document document) throws CanonicalizationException {
        if (!document.isSupported("Traversal", "2.0")) {
            Object[] objectArray = new Object[]{document.getImplementation().getClass().getName()};
            throw new CanonicalizationException("c14n.Canonicalizer.TraversalNotSupported", objectArray);
        }
    }

    public static void checkForRelativeNamespace(Element element) throws CanonicalizationException {
        if (element != null) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                C14nHelper.assertNotRelativeNS((Attr)namedNodeMap.item(n));
                ++n;
            }
        } else {
            throw new CanonicalizationException("Called checkForRelativeNamespace() on null");
        }
    }
}

