/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.encryption.EncryptionMethod;
import org.apache.xml.security.algorithms.encryption.params.EncryptionMethodParams;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.encryption.CipherData;
import org.apache.xml.security.encryption.CipherValue;
import org.apache.xml.security.encryption.EncryptionProperties;
import org.apache.xml.security.encryption.type.EncryptedType;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.KeyName;
import org.apache.xml.security.utils.EncryptionElementProxy;
import org.apache.xml.security.utils.HelperNodeList;
import org.apache.xml.security.utils.HexDump;
import org.apache.xml.security.utils.IdResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xpath.CachedXPathAPI;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class EncryptedData
extends EncryptionElementProxy
implements EncryptedType {
    EncryptionMethod _cachedEncryptionMethod = null;

    public EncryptedData(Document document, EncryptionMethod encryptionMethod, KeyInfo keyInfo, CipherData cipherData, EncryptionProperties encryptionProperties, String string, String string2) throws XMLSecurityException {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
        if (encryptionMethod != null) {
            if (!encryptionMethod.getUsableInEncryptedData()) {
                Object[] objectArray = new Object[]{encryptionMethod.getAlgorithmURI()};
                throw new XMLSecurityException("encryption.algorithmCannotBeUsedForEncryptedData", objectArray);
            }
            this._constructionElement.appendChild(encryptionMethod.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
            this._cachedEncryptionMethod = encryptionMethod;
        }
        if (keyInfo != null) {
            this._constructionElement.appendChild(keyInfo.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
        if (cipherData == null) {
            cipherData = new CipherData(document);
        }
        this._constructionElement.appendChild(cipherData.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
        if (encryptionProperties != null) {
            this._constructionElement.appendChild(encryptionProperties.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
        this.setId(string);
        this.setType(string2);
    }

    public EncryptedData(Document document, String string, EncryptionMethodParams encryptionMethodParams, KeyInfo keyInfo, EncryptionProperties encryptionProperties, String string2) throws XMLSecurityException {
        this(document, new EncryptionMethod(document, string, encryptionMethodParams), keyInfo, null, encryptionProperties, string2, null);
    }

    public EncryptedData(Document document, String string, EncryptionMethodParams encryptionMethodParams, KeyInfo keyInfo, CipherData cipherData, EncryptionProperties encryptionProperties, String string2, String string3) throws XMLSecurityException {
        this(document, new EncryptionMethod(document, string, encryptionMethodParams), keyInfo, cipherData, encryptionProperties, string2, string3);
    }

    public EncryptedData(Element element, String string) throws XMLSecurityException {
        super(element, string);
    }

    public EncryptionMethod getEncryptionMethod() throws XMLSecurityException {
        Element element;
        if (this._cachedEncryptionMethod == null && (element = XMLUtils.getDirectChild(this._constructionElement, "EncryptionMethod", "http://www.w3.org/2001/04/xmlenc#")) != null) {
            this._cachedEncryptionMethod = new EncryptionMethod(element, this._baseURI);
        }
        return this._cachedEncryptionMethod;
    }

    public KeyInfo getKeyInfo() throws XMLSecurityException {
        Element element = XMLUtils.getDirectChild(this._constructionElement, "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        if (element != null) {
            return new KeyInfo(element, this._baseURI);
        }
        return null;
    }

    public CipherData getCipherData() throws XMLSecurityException {
        Element element = XMLUtils.getDirectChild(this._constructionElement, "CipherData", "http://www.w3.org/2001/04/xmlenc#");
        if (element != null) {
            return new CipherData(element, this._baseURI);
        }
        return null;
    }

    public EncryptionProperties getEncryptionProperties() throws XMLSecurityException {
        Element element = XMLUtils.getDirectChild(this._constructionElement, "EncryptionProperties", "http://www.w3.org/2001/04/xmlenc#");
        if (element != null) {
            return new EncryptionProperties(element, this._baseURI);
        }
        return null;
    }

    public void setId(String string) {
        if (this._state == 0 && string != null && string.length() != 0) {
            this._constructionElement.setAttributeNS(null, "Id", string);
            IdResolver.registerElementById(this._constructionElement, string);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public void setType(String string) {
        if (this._state == 0 && string != null) {
            this._constructionElement.setAttributeNS(null, "Type", string);
        }
    }

    public String getType() {
        return this._constructionElement.getAttributeNS(null, "Type");
    }

    public boolean getTypeIsElement() {
        String string = this.getType();
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equals("http://www.w3.org/2001/04/xmlenc#Element");
    }

    public boolean getTypeIsContent() {
        String string = this.getType();
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.equals("http://www.w3.org/2001/04/xmlenc#Content");
    }

    public boolean getTypeIsMediaType() {
        String string = this.getType();
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.startsWith("http://www.isi.edu/in-notes/iana/assignments/media-types/");
    }

    public String getMediaTypeOfType() {
        if (this.getTypeIsMediaType()) {
            return this.getType().substring("http://www.isi.edu/in-notes/iana/assignments/media-types/".length());
        }
        return null;
    }

    public static Element replace(Element element, NodeList nodeList) {
        Document document = element.getOwnerDocument();
        Object object = new HelperNodeList();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (document != nodeList.item(n).getOwnerDocument()) {
                ((HelperNodeList)object).appendChild(document.importNode(nodeList.item(n), true));
            } else {
                ((HelperNodeList)object).appendChild(nodeList.item(n));
            }
            ++n;
        }
        nodeList = object;
        object = element.getParentNode();
        if (object == document) {
            NodeList nodeList2 = document.getChildNodes();
            if (nodeList2.getLength() == 1) {
                Node node = document.removeChild(element);
                int n2 = 0;
                while (n2 < nodeList.getLength()) {
                    if (nodeList.item(n2).getNodeType() != 3) {
                        document.appendChild(nodeList.item(n2));
                    }
                    ++n2;
                }
                return (Element)node;
            }
            int n3 = 0;
            n3 = 0;
            while (n3 < nodeList2.getLength()) {
                if (nodeList2.item(n3) == element) break;
                ++n3;
            }
            if (n3 == nodeList2.getLength() - 1) {
                Node node = document.removeChild(element);
                int n4 = 0;
                while (n4 < nodeList.getLength()) {
                    document.appendChild(nodeList.item(n4));
                    ++n4;
                }
                return (Element)node;
            }
            Node node = document.removeChild(element);
            Node node2 = nodeList2.item(n3);
            int n5 = 0;
            while (n5 < nodeList.getLength()) {
                document.insertBefore(nodeList.item(n5), node2);
                ++n5;
            }
            return (Element)node;
        }
        n = 0;
        while (n < nodeList.getLength()) {
            object.insertBefore(nodeList.item(n), element);
            ++n;
        }
        return (Element)object.removeChild(element);
    }

    public static Element replace(Element element, Element element2) {
        HelperNodeList helperNodeList = new HelperNodeList();
        helperNodeList.appendChild(element2);
        return EncryptedData.replace(element, helperNodeList);
    }

    public static Element replace(Element element, byte[] byArray) throws XMLSecurityException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(byArray));
            HelperNodeList helperNodeList = new HelperNodeList();
            int n = 0;
            while (n < document.getChildNodes().getLength()) {
                helperNodeList.appendChild(document.getChildNodes().item(n));
                ++n;
            }
            return EncryptedData.replace(element, helperNodeList);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XMLSecurityException("empty", parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new XMLSecurityException("empty", iOException);
        }
        catch (SAXException sAXException) {
            throw new XMLSecurityException("empty", sAXException);
        }
    }

    public Key createSecretKeyFromBytes(byte[] byArray) throws XMLSecurityException {
        return this.getEncryptionMethod().createSecretKeyFromBytes(byArray);
    }

    public void encryptElementAndReplace(Element element, Key key) throws XMLSecurityException {
        EncryptionMethod encryptionMethod = this.getEncryptionMethod();
        Canonicalizer canonicalizer = Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        byte[] byArray = canonicalizer.canonicalizeSubtree(element);
        byte[] byArray2 = encryptionMethod.encrypt(byArray, key);
        this.getCipherData().setCipherValue(new CipherValue(this._doc, byArray2));
        this.setType("http://www.w3.org/2001/04/xmlenc#Element");
        EncryptedData.replace(element, this._constructionElement);
    }

    private void encryptContentAndReplace_old(Node node, Key key) throws XMLSecurityException {
        Object object;
        EncryptionMethod encryptionMethod = this.getEncryptionMethod();
        byte[] byArray = null;
        try {
            object = new ByteArrayOutputStream();
            int n = 0;
            while (n < node.getChildNodes().getLength()) {
                Node node2 = node.getChildNodes().item(n);
                if (node2.getNodeType() == 8) {
                    ((OutputStream)object).write(("<!--" + ((Comment)node2).getData() + "-->").getBytes());
                } else if (node2.getNodeType() == 7) {
                    ((OutputStream)object).write(("<?" + ((ProcessingInstruction)node2).getTarget() + " " + ((ProcessingInstruction)node2).getData() + "?>").getBytes());
                } else if (node2.getNodeType() == 3) {
                    ((OutputStream)object).write(((Text)node2).getData().getBytes());
                } else {
                    Canonicalizer canonicalizer = Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
                    ((OutputStream)object).write(canonicalizer.canonicalizeSubtree(node2));
                }
                ++n;
            }
            byArray = ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (Exception exception) {
            throw new XMLSecurityException("empty", exception);
        }
        object = encryptionMethod.encrypt(byArray, key);
        this.getCipherData().setCipherValue(new CipherValue(this._doc, (byte[])object));
        this.setType("http://www.w3.org/2001/04/xmlenc#Content");
        while (node.hasChildNodes()) {
            node.removeChild(node.getLastChild());
        }
        node.appendChild(this._constructionElement);
    }

    public void encryptContentAndReplace(Node node, Key key) throws XMLSecurityException {
        this.encryptContentAndReplace(node.getFirstChild(), node.getChildNodes().getLength(), key);
    }

    public void encryptContentAndReplace(Node node, int n, Key key) throws XMLSecurityException {
        try {
            Object object;
            EncryptionMethod encryptionMethod = this.getEncryptionMethod();
            byte[] byArray = null;
            Node node2 = node.getParentNode();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Node node3 = node;
            int n2 = 0;
            while (n2 < n) {
                if (node3 == null) {
                    throw new IndexOutOfBoundsException("The index " + n + " is out of bounds: maximum is " + (n2 - 1));
                }
                if (node3.getNodeType() == 8) {
                    byteArrayOutputStream.write(("<!--" + ((Comment)node3).getData() + "-->").getBytes());
                } else if (node3.getNodeType() == 7) {
                    byteArrayOutputStream.write(("<?" + ((ProcessingInstruction)node3).getTarget() + " " + ((ProcessingInstruction)node3).getData() + "?>").getBytes());
                } else if (node3.getNodeType() == 3) {
                    byteArrayOutputStream.write(((Text)node3).getData().getBytes());
                } else {
                    object = Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
                    byteArrayOutputStream.write(((Canonicalizer)object).canonicalizeSubtree(node3));
                }
                node3 = node3.getNextSibling();
                ++n2;
            }
            object = node3;
            byArray = byteArrayOutputStream.toByteArray();
            byte[] byArray2 = encryptionMethod.encrypt(byArray, key);
            this.getCipherData().setCipherValue(new CipherValue(this._doc, byArray2));
            this.setType("http://www.w3.org/2001/04/xmlenc#Content");
            int n3 = 0;
            node3 = node2.getFirstChild();
            while (node3 != node) {
                ++n3;
                node3 = node3.getNextSibling();
            }
            n2 = 0;
            while (n2 < n) {
                node2.removeChild(node2.getChildNodes().item(n3));
                ++n2;
            }
            node2.insertBefore(this._constructionElement, (Node)object);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw xMLSecurityException;
        }
        catch (Exception exception) {
            throw new XMLSecurityException("empty", exception);
        }
    }

    public void decryptAndReplace(Key key) throws XMLSecurityException {
        EncryptionMethod encryptionMethod = this.getEncryptionMethod();
        byte[] byArray = this.getCipherData().getCipherValue().getCipherText();
        byte[] byArray2 = encryptionMethod.decrypt(byArray, key);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            String string = "container";
            byteArrayOutputStream.write(new String("<" + string + ">").getBytes());
            byteArrayOutputStream.write(byArray2);
            byteArrayOutputStream.write(new String("</" + string + ">").getBytes());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            Element element = document.getDocumentElement();
            HelperNodeList helperNodeList = new HelperNodeList();
            int n = 0;
            while (n < element.getChildNodes().getLength()) {
                helperNodeList.appendChild(element.getChildNodes().item(n));
                ++n;
            }
            EncryptedData.replace(this._constructionElement, helperNodeList);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XMLSecurityException("empty", parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new XMLSecurityException("empty", iOException);
        }
        catch (SAXException sAXException) {
            throw new XMLSecurityException("empty", sAXException);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Init.init();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElementNS(null, "root");
        String string = "1 USD           ";
        String string2 = "999.999.999 EUR ";
        String string3 = string;
        element.appendChild(document.createTextNode(string));
        document.appendChild(document.createComment(" 0 "));
        document.appendChild(document.createComment(" 1 "));
        document.appendChild(element);
        document.appendChild(document.createComment(" 2 "));
        document.appendChild(document.createComment(" 3 "));
        System.out.println("------------------------------------------------------------");
        XMLUtils.outputDOMc14nWithComments(document, System.out);
        System.out.println();
        KeyInfo keyInfo = new KeyInfo(document);
        keyInfo.add(new KeyName(document, "Christian Geuer-Pollmann"));
        Object object = new EncryptedData(document, "http://www.w3.org/2001/04/xmlenc#aes128-cbc", null, keyInfo, null, "myFirstEncryptedElement");
        Key key = ((EncryptedData)object).createSecretKeyFromBytes(HexDump.hexStringToByteArray("00 01 02 03 04 05 06 07 08 09 0a 0b 0c 0d 0e 0f"));
        ((EncryptedData)object).encryptContentAndReplace(element, key);
        System.out.println("------------------------------------------------------------");
        XMLUtils.outputDOMc14nWithComments(document, System.out);
        System.out.println();
        keyInfo = new CachedXPathAPI();
        object = document.createElementNS(null, "nsctx");
        object.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xenc", "http://www.w3.org/2001/04/xmlenc#");
        Element element2 = (Element)keyInfo.selectSingleNode(document, "//xenc:EncryptedData", (Node)object);
        EncryptedData encryptedData = new EncryptedData(element2, "memory://");
        encryptedData.decryptAndReplace(key);
        System.out.println("------------------------------------------------------------");
        XMLUtils.outputDOMc14nWithComments(document, System.out);
        System.out.println();
        System.out.println("------------------------------------------------------------");
    }

    public static int min(int n, int n2, int n3) {
        return EncryptedData.min(EncryptedData.min(n, n2), n3);
    }

    public static int min(int n, int n2) {
        if (n < n2) {
            return n;
        }
        return n2;
    }

    public String getBaseLocalName() {
        return "EncryptedData";
    }
}

