/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.signature;

import java.io.IOException;
import org.apache.log4j.Category;
import org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Manifest;
import org.apache.xml.security.signature.ReferenceNotInitializedException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.InvalidTransformException;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.IdResolver;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Reference
extends SignatureElementProxy {
    static Category cat = Category.getInstance((String)(class$org$apache$xml$security$signature$Reference == null ? (class$org$apache$xml$security$signature$Reference = Reference.class$("org.apache.xml.security.signature.Reference")) : class$org$apache$xml$security$signature$Reference).getName());
    public static final String OBJECT_URI = "http://www.w3.org/2000/09/xmldsig#Object";
    public static final String MANIFEST_URI = "http://www.w3.org/2000/09/xmldsig#Manifest";
    Manifest _manifest = null;
    XMLSignatureInput _transformsInput;
    XMLSignatureInput _transformsOutput;
    static /* synthetic */ Class class$org$apache$xml$security$signature$Reference;

    protected Reference(Document document, String string, String string2, Manifest manifest, Transforms transforms, String string3) throws XMLSignatureException {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._baseURI = string;
        this._manifest = manifest;
        this.setURI(string2);
        Element element = XMLUtils.createDSctx(this._doc, "ds");
        if (transforms != null) {
            this._constructionElement.appendChild(transforms.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
        Object object = MessageDigestAlgorithm.getInstance(this._doc, string3);
        this._constructionElement.appendChild(((ElementProxy)object).getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
        object = XMLUtils.createElementInSignatureSpace(this._doc, "DigestValue");
        this._constructionElement.appendChild((Node)object);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    protected Reference(Document document, String string, String string2, Manifest manifest, String string3) throws XMLSignatureException {
        this(document, string, string2, manifest, null, string3);
    }

    protected Reference(Document document, String string, String string2, Manifest manifest, Transforms transforms) throws XMLSignatureException {
        this(document, string, string2, manifest, transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
    }

    protected Reference(Document document, String string, String string2, Manifest manifest) throws XMLSignatureException {
        this(document, string, string2, manifest, null, "http://www.w3.org/2000/09/xmldsig#sha1");
    }

    protected Reference(Element element, String string, Manifest manifest) throws XMLSecurityException {
        super(element, string);
        this._manifest = manifest;
    }

    public MessageDigestAlgorithm getMessageDigestAlgorithm() throws XMLSignatureException {
        Element element = this.getChildElementLocalName(0, "http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
        if (element == null) {
            return null;
        }
        String string = element.getAttributeNS(null, "Algorithm");
        return MessageDigestAlgorithm.getInstance(this._doc, string);
    }

    public void setURI(String string) {
        if (this._state == 0 && string != null) {
            this._constructionElement.setAttributeNS(null, "URI", string);
        }
    }

    public String getURI() {
        return this._constructionElement.getAttributeNS(null, "URI");
    }

    public void setId(String string) {
        if (this._state == 0 && string != null) {
            this._constructionElement.setAttributeNS(null, "Id", string);
            IdResolver.registerElementById(this._constructionElement, string);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public void setType(String string) {
        if (this._state == 0 && string != null) {
            this._constructionElement.setAttributeNS(null, "Type", string);
        }
    }

    public String getType() {
        return this._constructionElement.getAttributeNS(null, "Type");
    }

    public boolean typeIsReferenceToObject() {
        return this.getType() != null && this.getType().equals(OBJECT_URI);
    }

    public boolean typeIsReferenceToManifest() {
        return this.getType() != null && this.getType().equals(MANIFEST_URI);
    }

    private void setDigestValueElement(byte[] byArray) throws XMLSignatureException {
        if (this._state == 0) {
            Element element = this.getChildElementLocalName(0, "http://www.w3.org/2000/09/xmldsig#", "DigestValue");
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                element.removeChild(nodeList.item(n));
                ++n;
            }
            String string = Base64.encode(byArray);
            Text text = this._doc.createTextNode(string);
            element.appendChild(text);
        }
    }

    public void generateDigestValue() throws XMLSignatureException, ReferenceNotInitializedException {
        if (this._state == 0) {
            byte[] byArray = this.calculateDigest();
            this.setDigestValueElement(byArray);
        }
    }

    protected void dereferenceURIandPerformTransforms() throws ReferenceNotInitializedException, XMLSignatureException {
        try {
            Attr attr = this._constructionElement.getAttributeNode("URI");
            String string = attr == null ? null : attr.getNodeValue();
            ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, this._baseURI, this._manifest._perManifestResolvers);
            if (resourceResolver == null) {
                Object[] objectArray = new Object[]{string};
                throw new ReferenceNotInitializedException("signature.Verification.Reference.NoInput", objectArray);
            }
            resourceResolver.addProperties(this._manifest._resolverProperties);
            this._transformsInput = resourceResolver.resolve(attr, this._baseURI);
            Transforms transforms = this.getTransforms();
            this._transformsOutput = transforms != null ? transforms.performTransforms(this._transformsInput) : this._transformsInput;
        }
        catch (ResourceResolverException resourceResolverException) {
            throw new ReferenceNotInitializedException("empty", resourceResolverException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new ReferenceNotInitializedException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new ReferenceNotInitializedException("empty", invalidCanonicalizerException);
        }
        catch (TransformationException transformationException) {
            throw new ReferenceNotInitializedException("empty", transformationException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new ReferenceNotInitializedException("empty", xMLSecurityException);
        }
    }

    public Transforms getTransforms() throws XMLSignatureException, InvalidTransformException, TransformationException, XMLSecurityException {
        Element element = this.getChildElementLocalName(0, "http://www.w3.org/2000/09/xmldsig#", "Transforms");
        if (element != null) {
            Transforms transforms = new Transforms(element, this._baseURI);
            return transforms;
        }
        return null;
    }

    public byte[] getReferencedBytes() throws ReferenceNotInitializedException, XMLSignatureException {
        try {
            this.dereferenceURIandPerformTransforms();
            byte[] byArray = this.getTransformsOutput().getBytes();
            return byArray;
        }
        catch (IOException iOException) {
            throw new ReferenceNotInitializedException("empty", iOException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new ReferenceNotInitializedException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new ReferenceNotInitializedException("empty", invalidCanonicalizerException);
        }
    }

    private byte[] calculateDigest() throws ReferenceNotInitializedException, XMLSignatureException {
        try {
            byte[] byArray = this.getReferencedBytes();
            MessageDigestAlgorithm messageDigestAlgorithm = this.getMessageDigestAlgorithm();
            messageDigestAlgorithm.reset();
            messageDigestAlgorithm.update(byArray);
            byte[] byArray2 = messageDigestAlgorithm.digest();
            return byArray2;
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new ReferenceNotInitializedException("empty", xMLSecurityException);
        }
    }

    public boolean verify() throws ReferenceNotInitializedException, XMLSecurityException {
        byte[] byArray;
        Element element = this.getChildElementLocalName(0, "http://www.w3.org/2000/09/xmldsig#", "DigestValue");
        byte[] byArray2 = Base64.decode(element);
        boolean bl = MessageDigestAlgorithm.isEqual(byArray2, byArray = this.calculateDigest());
        if (!bl) {
            cat.warn((Object)("Verification failed for URI \"" + this.getURI() + "\""));
            if (cat.isDebugEnabled()) {
                cat.debug((Object)("unverifiedDigestValue= " + Base64.encode(byArray2)));
                cat.debug((Object)("calculatedDigestValue= " + Base64.encode(byArray)));
            }
        } else {
            cat.info((Object)("Verification successful for URI \"" + this.getURI() + "\""));
        }
        return bl;
    }

    public XMLSignatureInput getTransformsInput() {
        return this._transformsInput;
    }

    public XMLSignatureInput getTransformsOutput() {
        return this._transformsOutput;
    }

    public String getBaseLocalName() {
        return "Reference";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

