/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms;

import java.io.IOException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Category;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.InvalidTransformException;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Transforms
extends SignatureElementProxy {
    static Category cat = Category.getInstance((String)(class$org$apache$xml$security$transforms$Transforms == null ? (class$org$apache$xml$security$transforms$Transforms = Transforms.class$("org.apache.xml.security.transforms.Transforms")) : class$org$apache$xml$security$transforms$Transforms).getName());
    public static final String TRANSFORM_C14N_OMIT_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String TRANSFORM_C14N_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String TRANSFORM_C14N_EXCL_OMIT_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String TRANSFORM_C14N_EXCL_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    public static final String TRANSFORM_XSLT = "http://www.w3.org/TR/1999/REC-xslt-19991116";
    public static final String TRANSFORM_BASE64_DECODE = "http://www.w3.org/2000/09/xmldsig#base64";
    public static final String TRANSFORM_XPATH = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    public static final String TRANSFORM_ENVELOPED_SIGNATURE = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
    public static final String TRANSFORM_XPOINTER = "http://www.w3.org/TR/2001/WD-xptr-20010108";
    public static final String TRANSFORM_XPATH2FILTER04 = "http://www.w3.org/2002/04/xmldsig-filter2";
    public static final String TRANSFORM_XPATH2FILTER = "http://www.w3.org/2002/06/xmldsig-filter2";
    public static final String TRANSFORM_XPATHFILTERCHGP = "http://www.nue.et-inf.uni-siegen.de/~geuer-pollmann/#xpathFilter";
    static /* synthetic */ Class class$org$apache$xml$security$transforms$Transforms;

    public Transforms(Document document) {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public Transforms(Element element, String string) throws DOMException, XMLSignatureException, InvalidTransformException, TransformationException, XMLSecurityException {
        super(element, string);
        int n = this.getLength();
        if (n == 0) {
            Object[] objectArray = new Object[]{"Transform", "Transforms"};
            throw new TransformationException("xml.WrongContent", objectArray);
        }
    }

    public void addTransform(String string) throws TransformationException {
        try {
            cat.debug((Object)("Transforms.addTransform(" + string + ")"));
            Transform transform = Transform.getInstance(this._doc, string);
            this.addTransform(transform);
        }
        catch (InvalidTransformException invalidTransformException) {
            throw new TransformationException("empty", invalidTransformException);
        }
    }

    public void addTransform(String string, Element element) throws TransformationException {
        try {
            cat.debug((Object)("Transforms.addTransform(" + string + ")"));
            Transform transform = Transform.getInstance(this._doc, string, element);
            this.addTransform(transform);
        }
        catch (InvalidTransformException invalidTransformException) {
            throw new TransformationException("empty", invalidTransformException);
        }
    }

    public void addTransform(String string, NodeList nodeList) throws TransformationException {
        try {
            Transform transform = Transform.getInstance(this._doc, string, nodeList);
            this.addTransform(transform);
        }
        catch (InvalidTransformException invalidTransformException) {
            throw new TransformationException("empty", invalidTransformException);
        }
    }

    private void addTransform(Transform transform) {
        cat.debug((Object)("Transforms.addTransform(" + transform.getURI() + ")"));
        Element element = transform.getElement();
        this._constructionElement.appendChild(element);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public XMLSignatureInput performTransforms(XMLSignatureInput xMLSignatureInput) throws TransformationException {
        try {
            int n = 0;
            while (n < this.getLength()) {
                Transform transform = this.item(n);
                cat.debug((Object)("Preform the (" + n + ")th " + transform.getURI() + " transform"));
                xMLSignatureInput = transform.performTransform(xMLSignatureInput);
                ++n;
            }
            return xMLSignatureInput;
        }
        catch (IOException iOException) {
            throw new TransformationException("empty", iOException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new TransformationException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new TransformationException("empty", invalidCanonicalizerException);
        }
    }

    public int getLength() throws TransformationException {
        try {
            Element element = XMLUtils.createDSctx(this._doc, "ds", "http://www.w3.org/2000/09/xmldsig#");
            NodeList nodeList = XPathAPI.selectNodeList((Node)this._constructionElement, (String)"./ds:Transform", (Node)element);
            return nodeList.getLength();
        }
        catch (TransformerException transformerException) {
            throw new TransformationException("empty", transformerException);
        }
    }

    public Transform item(int n) throws TransformationException {
        try {
            Element element = XMLUtils.createDSctx(this._doc, "ds", "http://www.w3.org/2000/09/xmldsig#");
            Element element2 = (Element)XPathAPI.selectSingleNode((Node)this._constructionElement, (String)("./ds:Transform[" + (n + 1) + "]"), (Node)element);
            if (element2 == null) {
                return null;
            }
            return new Transform(element2, this._baseURI);
        }
        catch (TransformerException transformerException) {
            throw new TransformationException("empty", transformerException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new TransformationException("empty", xMLSecurityException);
        }
    }

    public String getBaseLocalName() {
        return "Transforms";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

