/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.ByteArrayOutputStream;
import java.util.Random;
import org.apache.log4j.Category;
import sun.misc.HexDumpEncoder;

public class HexDump {
    static Category cat = Category.getInstance((String)(class$org$apache$xml$security$utils$HexDump == null ? (class$org$apache$xml$security$utils$HexDump = HexDump.class$("org.apache.xml.security.utils.HexDump")) : class$org$apache$xml$security$utils$HexDump).getName());
    private static boolean DEBUG = false;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static char[] BIT_DIGIT = new char[]{'0', '1'};
    private static final byte[] COMPARE_BITS = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    private static char BYTE_SEPARATOR = (char)32;
    private static boolean WITH_BYTE_SEPARATOR = true;
    static /* synthetic */ Class class$org$apache$xml$security$utils$HexDump;

    private HexDump() {
    }

    public static String prettyPrintHex(byte[] byArray) {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        return hexDumpEncoder.encodeBuffer(byArray);
    }

    public static String prettyPrintHex(String string) {
        return HexDump.prettyPrintHex(string.getBytes());
    }

    public static void setDebug(boolean bl) {
        DEBUG = bl;
    }

    public static void setWithByteSeparator(boolean bl) {
        WITH_BYTE_SEPARATOR = bl;
    }

    public static void setByteSeparator(char c) {
        BYTE_SEPARATOR = c;
    }

    public static void setBitDigits(char[] cArray) throws Exception {
        if (cArray.length != 2) {
            throw new Exception("wrong number of characters!");
        }
        BIT_DIGIT = cArray;
    }

    public static void setBitDigits(char c, char c2) {
        HexDump.BIT_DIGIT[0] = c;
        HexDump.BIT_DIGIT[1] = c2;
    }

    public static String byteArrayToBinaryString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            HexDump.byte2bin(byArray[n2], stringBuffer);
            if (n2 < n - 1 & WITH_BYTE_SEPARATOR) {
                stringBuffer.append(BYTE_SEPARATOR);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String toBinaryString(byte[] byArray) {
        return HexDump.byteArrayToBinaryString(byArray);
    }

    public static String toBinaryString(byte by) {
        byte[] byArray = new byte[]{by};
        return HexDump.byteArrayToBinaryString(byArray);
    }

    public static String toBinaryString(short s) {
        return HexDump.toBinaryString(HexDump.toByteArray(s));
    }

    public static String toBinaryString(int n) {
        return HexDump.toBinaryString(HexDump.toByteArray(n));
    }

    public static String toBinaryString(long l) {
        return HexDump.toBinaryString(HexDump.toByteArray(l));
    }

    public static final byte[] toByteArray(short s) {
        byte[] byArray = new byte[2];
        byArray[1] = (byte)s;
        byArray[0] = (byte)(s >> 8);
        return byArray;
    }

    public static final byte[] toByteArray(int n) {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)n;
        byArray[2] = (byte)(n >> 8);
        byArray[1] = (byte)(n >> 16);
        byArray[0] = (byte)(n >> 24);
        return byArray;
    }

    public static final byte[] toByteArray(long l) {
        byte[] byArray = new byte[8];
        byArray[7] = (byte)l;
        byArray[6] = (byte)(l >> 8);
        byArray[5] = (byte)(l >> 16);
        byArray[4] = (byte)(l >> 24);
        byArray[3] = (byte)(l >> 32);
        byArray[2] = (byte)(l >> 40);
        byArray[1] = (byte)(l >> 48);
        byArray[0] = (byte)(l >> 56);
        return byArray;
    }

    public static String byteArrayToHexString(byte[] byArray) {
        long l = System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            HexDump.byte2hex(byArray[n2], stringBuffer);
            if (n2 < n - 1 & WITH_BYTE_SEPARATOR) {
                stringBuffer.append(BYTE_SEPARATOR);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String stringToHexString(String string) {
        byte[] byArray = string.getBytes();
        return HexDump.toHexString(byArray);
    }

    public static String byteArrayToHexString(byte[] byArray, int n, int n2) {
        long l = System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = byArray.length;
        if (n3 < (n2 += n)) {
            n2 = n3;
        }
        int n4 = 0 + n;
        while (n4 < n2) {
            HexDump.byte2hex(byArray[n4], stringBuffer);
            if (n4 < n2 - 1) {
                stringBuffer.append(":");
            }
            ++n4;
        }
        return stringBuffer.toString();
    }

    public static String toHexString(byte[] byArray) {
        return HexDump.toHexString(byArray, 0, byArray.length);
    }

    public static String toHexString(byte by) {
        byte[] byArray = new byte[]{by};
        return HexDump.toHexString(byArray, 0, byArray.length);
    }

    public static String toHexString(short s) {
        return HexDump.toHexString(HexDump.toByteArray(s));
    }

    public static String toHexString(int n) {
        return HexDump.toHexString(HexDump.toByteArray(n));
    }

    public static String toHexString(long l) {
        return HexDump.toHexString(HexDump.toByteArray(l));
    }

    public static String toString(byte[] byArray) {
        return new String(byArray).toString();
    }

    public static String toString(byte by) {
        byte[] byArray = new byte[]{by};
        return new String(byArray).toString();
    }

    public static String toHexString(byte[] byArray, int n, int n2) {
        long l = System.currentTimeMillis();
        char[] cArray = WITH_BYTE_SEPARATOR ? new char[n2 * 3] : new char[n2 * 2];
        int n3 = n;
        int n4 = 0;
        while (n3 < n + n2) {
            byte by = byArray[n3++];
            cArray[n4++] = HEX_DIGITS[by >>> 4 & 0xF];
            cArray[n4++] = HEX_DIGITS[by & 0xF];
            if (!WITH_BYTE_SEPARATOR) continue;
            cArray[n4++] = BYTE_SEPARATOR;
        }
        return new String(cArray);
    }

    public static byte[] hexStringToByteArray(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        boolean bl = true;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            switch (Character.toUpperCase(c)) {
                case '0': {
                    if (bl) {
                        n = 0;
                        bl = false;
                        break;
                    }
                    n = (byte)(n | 0);
                    byteArrayOutputStream.write(n);
                    bl = true;
                    break;
                }
                case '1': {
                    if (bl) {
                        n = 16;
                        bl = false;
                        break;
                    }
                    n = (byte)(n | 1);
                    byteArrayOutputStream.write(n);
                    bl = true;
                    break;
                }
                case '2': {
                    if (bl) {
                        n = 32;
                        bl = false;
                        break;
                    }
                    n = (byte)(n | 2);
                    byteArrayOutputStream.write(n);
                    bl = true;
                    break;
                }
                case '3': {
                    if (bl) {
                        n = 48;
                        bl = false;
                        break;
                    }
                    n = (byte)(n | 3);
                    byteArrayOutputStream.write(n);
                    bl = true;
                    break;
                }
                case '4': {
                    if (bl) {
                        n = 64;
                        bl = false;
                        break;
                    }
                    n = (byte)(n | 4);
                    byteArrayOutputStream.write(n);
                    bl = true;
                    break;
                }
                case '5': {
                    if (bl) {
                        n = 80;
                        bl = false;
                        break;
                    }
                    n = (byte)(n | 5);
                    byteArrayOutputStream.write(n);
                    bl = true;
                    break;
                }
                case '6': {
                    if (bl) {
                        n = 96;
                        bl = false;
                        break;
                    }
                    n = (byte)(n | 6);
                    byteArrayOutputStream.write(n);
                    bl = true;
                    break;
                }
                case '7': {
                    if (bl) {
                        n = 112;
                        bl = false;
                        break;
                    }
                    n = (byte)(n | 7);
                    byteArrayOutputStream.write(n);
                    bl = true;
                    break;
                }
                case '8': {
                    if (bl) {
                        n = -128;
                        bl = false;
                        break;
                    }
                    n = (byte)(n | 8);
                    byteArrayOutputStream.write(n);
                    bl = true;
                    break;
                }
                case '9': {
                    if (bl) {
                        n = -112;
                        bl = false;
                        break;
                    }
                    n = (byte)(n | 9);
                    byteArrayOutputStream.write(n);
                    bl = true;
                    break;
                }
                case 'A': {
                    if (bl) {
                        n = -96;
                        bl = false;
                        break;
                    }
                    n = (byte)(n | 0xA);
                    byteArrayOutputStream.write(n);
                    bl = true;
                    break;
                }
                case 'B': {
                    if (bl) {
                        n = -80;
                        bl = false;
                        break;
                    }
                    n = (byte)(n | 0xB);
                    byteArrayOutputStream.write(n);
                    bl = true;
                    break;
                }
                case 'C': {
                    if (bl) {
                        n = -64;
                        bl = false;
                        break;
                    }
                    n = (byte)(n | 0xC);
                    byteArrayOutputStream.write(n);
                    bl = true;
                    break;
                }
                case 'D': {
                    if (bl) {
                        n = -48;
                        bl = false;
                        break;
                    }
                    n = (byte)(n | 0xD);
                    byteArrayOutputStream.write(n);
                    bl = true;
                    break;
                }
                case 'E': {
                    if (bl) {
                        n = -32;
                        bl = false;
                        break;
                    }
                    n = (byte)(n | 0xE);
                    byteArrayOutputStream.write(n);
                    bl = true;
                    break;
                }
                case 'F': {
                    if (bl) {
                        n = -16;
                        bl = false;
                        break;
                    }
                    n = (byte)(n | 0xF);
                    byteArrayOutputStream.write(n);
                    bl = true;
                }
            }
            ++n2;
        }
        if (!bl) {
            throw new RuntimeException("The String did not contain an equal number of hex digits");
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static void byte2hex(byte by, StringBuffer stringBuffer) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n = (by & 0xF0) >> 4;
        int n2 = by & 0xF;
        stringBuffer.append(cArray[n]);
        stringBuffer.append(cArray[n2]);
    }

    private static void byte2bin(byte by, StringBuffer stringBuffer) {
        int n = 0;
        while (n < 8) {
            if ((by & COMPARE_BITS[n]) != 0) {
                stringBuffer.append(BIT_DIGIT[1]);
            } else {
                stringBuffer.append(BIT_DIGIT[0]);
            }
            ++n;
        }
    }

    private static String intToHexString(int n) {
        char[] cArray = new char[8];
        int n2 = 7;
        while (n2 >= 0) {
            cArray[n2] = HEX_DIGITS[n & 0xF];
            n >>>= 4;
            --n2;
        }
        return new String(cArray);
    }

    public static void main(String[] stringArray) {
        System.out.println("-test and demo of the converter ");
        HexDump.setDebug(false);
        String string = new String("Niko");
        byte[] byArray = string.getBytes();
        System.out.println("to convert: " + string);
        System.out.println("converted1: " + HexDump.byteArrayToHexString(byArray));
        System.out.println("converted1: " + HexDump.byteArrayToHexString(byArray, 0, byArray.length));
        System.out.println("converted3: " + HexDump.stringToHexString(string));
        System.out.println("----Convert integer to hexString...");
        int n = -2;
        System.out.println("to convert: " + n + " -> " + HexDump.intToHexString(n));
        System.out.println("----Convert byte[] to binary String...");
        byte[] byArray2 = new byte[]{-1, 0, 51, 17, -1, 95, 95, 79, 31, -1};
        System.out.println("to convert: " + HexDump.toHexString(byArray2) + " -> " + HexDump.byteArrayToBinaryString(byArray2));
        HexDump.setByteSeparator('-');
        System.out.println("to convert: " + HexDump.toHexString(byArray2) + " -> " + HexDump.byteArrayToBinaryString(byArray2));
        HexDump.setByteSeparator('*');
        HexDump.setWithByteSeparator(true);
        System.out.println("to convert: " + HexDump.toHexString(byArray2) + " -> " + HexDump.byteArrayToBinaryString(byArray2));
        char[] cArray = new char[]{'a', 'b'};
        try {
            HexDump.setBitDigits(cArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("to convert: " + HexDump.toHexString(byArray2) + " -> " + HexDump.byteArrayToBinaryString(byArray2));
        HexDump.setBitDigits('0', '1');
        System.out.println("---- Convert.toByteArray(int) ");
        int n2 = -10;
        while (n2 < 10) {
            System.out.println("to convert = " + n2 + " = " + HexDump.toBinaryString(n2));
            byte[] byArray3 = new byte[4];
            byArray3 = HexDump.toByteArray(n2);
            System.out.println("convertet byteArray = " + HexDump.toBinaryString(byArray3));
            ++n2;
        }
        System.out.println("---- toHexString(int) ");
        n = -1;
        System.out.println(n + " = 0x" + HexDump.toHexString(n) + " = " + HexDump.toBinaryString(n));
        System.out.println(++n + " = 0x" + HexDump.toHexString(n) + " = " + HexDump.toBinaryString(n));
        System.out.println("---- toHexString(long) ");
        long l = 100L;
        System.out.println(l + " = 0x" + HexDump.toHexString(l) + " = " + HexDump.toBinaryString(l));
        Random random = new Random();
        l = random.nextLong();
        System.out.println(l + " = 0x" + HexDump.toHexString(l) + " = " + HexDump.toBinaryString(l));
        System.out.println("---- toHexString(short) ");
        short s = 100;
        System.out.println(s + " = 0x" + HexDump.toHexString(s) + " = " + HexDump.toBinaryString(s));
        random = new Random();
        s = (short)random.nextInt();
        System.out.println(s + " = 0x" + HexDump.toHexString(s) + " = " + HexDump.toBinaryString(s));
        System.out.println("---- read file in Hex-Format ");
        String string2 = "12345654321";
        System.out.println(string2 + " = " + HexDump.stringToHexString(string2));
        System.out.println("Das ist die Hex-Darstellung des obigen Strings");
        byte[] byArray4 = new byte[string2.length()];
        byArray4 = HexDump.hexStringToByteArray(string2);
        System.out.println("ba = " + HexDump.toHexString(byArray));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

