/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERConstructedSequence;
import org.bouncycastle.asn1.DERConstructedSet;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERTaggedObject;

public class SafeBag
implements DEREncodable {
    DERObjectIdentifier bagId;
    DERObject bagValue;
    DERConstructedSet bagAttributes;

    public SafeBag(DERObjectIdentifier dERObjectIdentifier, DERObject dERObject) {
        this.bagId = dERObjectIdentifier;
        this.bagValue = dERObject;
        this.bagAttributes = null;
    }

    public SafeBag(DERObjectIdentifier dERObjectIdentifier, DERObject dERObject, DERConstructedSet dERConstructedSet) {
        this.bagId = dERObjectIdentifier;
        this.bagValue = dERObject;
        this.bagAttributes = dERConstructedSet;
    }

    public SafeBag(ASN1Sequence aSN1Sequence) {
        this.bagId = (DERObjectIdentifier)aSN1Sequence.getObjectAt(0);
        this.bagValue = ((DERTaggedObject)aSN1Sequence.getObjectAt(1)).getObject();
        if (aSN1Sequence.size() == 3) {
            this.bagAttributes = (DERConstructedSet)aSN1Sequence.getObjectAt(2);
        }
    }

    public DERObjectIdentifier getBagId() {
        return this.bagId;
    }

    public DERObject getBagValue() {
        return this.bagValue;
    }

    public DERConstructedSet getBagAttributes() {
        return this.bagAttributes;
    }

    public DERObject getDERObject() {
        DERConstructedSequence dERConstructedSequence = new DERConstructedSequence();
        dERConstructedSequence.addObject(this.bagId);
        dERConstructedSequence.addObject(new DERTaggedObject(0, this.bagValue));
        if (this.bagAttributes != null) {
            dERConstructedSequence.addObject(this.bagAttributes);
        }
        return dERConstructedSequence;
    }
}

