/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.KeyPurposeId;

public class ExtendedKeyUsage
implements DEREncodable {
    Hashtable usageTable = new Hashtable();
    ASN1Sequence seq;

    public static ExtendedKeyUsage getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return ExtendedKeyUsage.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static ExtendedKeyUsage getInstance(Object object) {
        if (object == null || object instanceof ExtendedKeyUsage) {
            return (ExtendedKeyUsage)object;
        }
        if (object instanceof ASN1Sequence) {
            return new ExtendedKeyUsage((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("Invalid ExtendedKeyUsage: " + object.getClass().getName());
    }

    public ExtendedKeyUsage(ASN1Sequence aSN1Sequence) {
        this.seq = aSN1Sequence;
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.usageTable.put(e, e);
        }
    }

    public ExtendedKeyUsage(Vector vector) {
        DEREncodableVector dEREncodableVector = new DEREncodableVector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            DERObject dERObject = (DERObject)enumeration.nextElement();
            dEREncodableVector.add(dERObject);
            this.usageTable.put(dERObject, dERObject);
        }
        this.seq = new DERSequence(dEREncodableVector);
    }

    public boolean hasKeyPurposeId(KeyPurposeId keyPurposeId) {
        return this.usageTable.get(keyPurposeId) != null;
    }

    public DERObject getDERObject() {
        return this.seq;
    }
}

