/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat;

import edu.ucsb.nceas.metacat.EventLogData;
import edu.ucsb.nceas.metacat.IdentifierManager;
import edu.ucsb.nceas.metacat.database.DBConnection;
import edu.ucsb.nceas.metacat.database.DBConnectionPool;
import edu.ucsb.nceas.metacat.database.DatabaseService;
import edu.ucsb.nceas.metacat.index.MetacatSolrIndex;
import edu.ucsb.nceas.metacat.properties.PropertyService;
import edu.ucsb.nceas.metacat.util.DocumentUtil;
import edu.ucsb.nceas.utilities.PropertyNotFoundException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.dataone.service.types.v1.Event;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v2.Log;
import org.dataone.service.types.v2.LogEntry;
import org.dataone.service.util.DateTimeMarshaller;

public class EventLog {
    public static final String DELETE = "delete";
    private static EventLog self = null;
    private Logger logMetacat = Logger.getLogger(EventLog.class);
    private static final int USERAGENTLENGTH = 512;

    private EventLog() {
    }

    public static EventLog getInstance() {
        if (self == null) {
            self = new EventLog();
        }
        return self;
    }

    public void log(String ipAddress, String userAgent, String principal, String docid, String event) {
        EventLogData logData = new EventLogData(ipAddress, userAgent, principal, docid, event);
        this.insertLogEntry(logData);
        try {
            String localId = DocumentUtil.getSmartDocId(docid);
            int rev = DocumentUtil.getRevisionFromAccessionNumber(docid);
            String guid = IdentifierManager.getInstance().getGUID(localId, rev);
            Identifier pid = new Identifier();
            pid.setValue(guid);
            MetacatSolrIndex.getInstance().submit(pid, null, this.getIndexFields(pid, event), false);
        }
        catch (Exception e) {
            this.logMetacat.error((Object)"Could not update event index information", (Throwable)e);
        }
    }

    public Map<String, List<Object>> getIndexFields(Identifier pid, String event) {
        try {
            if (event != null) {
                String fieldName = event + "_count_i";
                int eventCount = 0;
                String docid = IdentifierManager.getInstance().getLocalId(pid.getValue());
                Log eventLog = this.getD1Report(null, null, new String[]{docid}, event, null, null, false, 0, 0);
                eventCount = eventLog.getTotal();
                ArrayList<Integer> values = new ArrayList<Integer>();
                values.add(eventCount);
                HashMap<String, List<Object>> fields = new HashMap<String, List<Object>>();
                fields.put(fieldName, values);
                return fields;
            }
        }
        catch (Exception e) {
            this.logMetacat.error((Object)("Could not update event index information on pid: " + pid.getValue() + " for event: " + event), (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertLogEntry(EventLogData logData) {
        String insertString = "insert into access_log(ip_address, user_agent, principal, docid, event, date_logged) values ( ?, ?, ?, ?, ?, ? )";
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("EventLog.insertLogEntry");
            serialNumber = dbConn.getCheckOutSerialNumber();
            String userAgent = logData.getUserAgent();
            if (userAgent != null && userAgent.length() > 512) {
                userAgent = userAgent.substring(0, 512);
            }
            PreparedStatement stmt = dbConn.prepareStatement(insertString);
            stmt.setString(1, logData.getIpAddress());
            stmt.setString(2, userAgent);
            stmt.setString(3, logData.getPrincipal());
            stmt.setString(4, logData.getDocid());
            stmt.setString(5, logData.getEvent());
            stmt.setTimestamp(6, new Timestamp(new Date().getTime()));
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            this.logMetacat.error((Object)("Error while logging event to database: " + e.getMessage()));
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getReport(String[] ipAddress, String[] principal, String[] docid, String[] event, Timestamp startDate, Timestamp endDate, boolean anonymous) {
        int i;
        StringBuffer resultDoc = new StringBuffer();
        StringBuffer query = new StringBuffer();
        query.append("select entryid, ip_address, user_agent, principal, docid, event, date_logged from access_log");
        if (ipAddress != null || principal != null || docid != null || event != null || startDate != null || endDate != null) {
            query.append(" where ");
        }
        boolean clauseAdded = false;
        int startIndex = 0;
        int endIndex = 0;
        ArrayList<String> paramValues = new ArrayList<String>();
        if (ipAddress != null) {
            query.append("ip_address in (");
            for (i = 0; i < ipAddress.length; ++i) {
                if (i > 0) {
                    query.append(", ");
                }
                query.append("?");
                paramValues.add(ipAddress[i]);
            }
            query.append(") ");
            clauseAdded = true;
        }
        if (principal != null) {
            if (clauseAdded) {
                query.append(" and ");
            }
            query.append("principal in (");
            for (i = 0; i < principal.length; ++i) {
                if (i > 0) {
                    query.append(", ");
                }
                query.append("?");
                paramValues.add(principal[i]);
            }
            query.append(") ");
            clauseAdded = true;
        }
        if (docid != null) {
            if (clauseAdded) {
                query.append(" and ");
            }
            query.append("docid in (");
            for (i = 0; i < docid.length; ++i) {
                if (i > 0) {
                    query.append(", ");
                }
                query.append("?");
                String fullDocid = docid[i];
                try {
                    fullDocid = DocumentUtil.appendRev(fullDocid);
                }
                catch (Exception e) {
                    this.logMetacat.warn((Object)("Could not check docid for revision: " + fullDocid), (Throwable)e);
                }
                paramValues.add(fullDocid);
            }
            query.append(") ");
            clauseAdded = true;
        }
        if (event != null) {
            if (clauseAdded) {
                query.append(" and ");
            }
            query.append("event in (");
            for (i = 0; i < event.length; ++i) {
                if (i > 0) {
                    query.append(", ");
                }
                query.append("?");
                paramValues.add(event[i]);
            }
            query.append(") ");
            clauseAdded = true;
        }
        if (startDate != null) {
            if (clauseAdded) {
                query.append(" and ");
            }
            query.append("date_logged >= ?");
            clauseAdded = true;
            ++startIndex;
        }
        if (endDate != null) {
            if (clauseAdded) {
                query.append(" and ");
            }
            query.append("date_logged < ?");
            clauseAdded = true;
            endIndex = startIndex + 1;
        }
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("EventLog.getReport");
            serialNumber = dbConn.getCheckOutSerialNumber();
            PreparedStatement stmt = dbConn.prepareStatement(query.toString());
            int parameterIndex = 1;
            for (String val : paramValues) {
                stmt.setString(parameterIndex++, val);
            }
            if (startDate != null) {
                stmt.setTimestamp(parameterIndex++, startDate);
            }
            if (endDate != null) {
                stmt.setTimestamp(parameterIndex++, endDate);
            }
            stmt.execute();
            ResultSet rs = stmt.getResultSet();
            resultDoc.append("<?xml version=\"1.0\"?>\n");
            resultDoc.append("<log>\n");
            while (rs.next()) {
                resultDoc.append(this.generateXmlRecord(rs.getString(1), anonymous ? "" : rs.getString(2), rs.getString(3), anonymous ? "" : rs.getString(4), rs.getString(5), rs.getString(6), rs.getTimestamp(7)));
            }
            resultDoc.append("</log>");
            stmt.close();
        }
        catch (SQLException e) {
            this.logMetacat.info((Object)("Error while logging event to database: " + e.getMessage()));
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        return resultDoc.toString();
    }

    public boolean isDeleted(String docid) {
        boolean anonymous;
        Timestamp endDate;
        Timestamp startDate;
        String[] events;
        String[] docids;
        String[] principal;
        String[] ipAddress;
        String report;
        boolean deleted = false;
        if ((docid != null || !docid.trim().equals("")) && (report = this.getReport(ipAddress = null, principal = null, docids = new String[]{docid}, events = new String[]{DELETE}, startDate = null, endDate = null, anonymous = false)) != null && report.contains("<event>delete</event>")) {
            deleted = true;
        }
        return deleted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Log getD1Report(String[] ipAddress, String[] principal, String[] docid, String event, Timestamp startDate, Timestamp endDate, boolean anonymous, Integer start, Integer count) {
        int i;
        boolean isCreateEvent = false;
        Log log = new Log();
        NodeReference memberNode = new NodeReference();
        String nodeId = "localhost";
        try {
            nodeId = PropertyService.getProperty("dataone.nodeId");
        }
        catch (PropertyNotFoundException e1) {
            e1.printStackTrace();
        }
        memberNode.setValue(nodeId);
        StringBuffer subQueryFrom = new StringBuffer();
        subQueryFrom.append("from access_log ");
        boolean clauseAdded = false;
        ArrayList<String> paramValues = new ArrayList<String>();
        if (ipAddress != null) {
            if (clauseAdded) {
                subQueryFrom.append(" and ");
            } else {
                subQueryFrom.append(" where ");
            }
            subQueryFrom.append("ip_address in (");
            for (i = 0; i < ipAddress.length; ++i) {
                if (i > 0) {
                    subQueryFrom.append(", ");
                }
                subQueryFrom.append("?");
                paramValues.add(ipAddress[i]);
            }
            subQueryFrom.append(") ");
            clauseAdded = true;
        }
        if (principal != null) {
            if (clauseAdded) {
                subQueryFrom.append(" and ");
            } else {
                subQueryFrom.append(" where ");
            }
            subQueryFrom.append("principal in (");
            for (i = 0; i < principal.length; ++i) {
                if (i > 0) {
                    subQueryFrom.append(", ");
                }
                subQueryFrom.append("?");
                paramValues.add(principal[i]);
            }
            subQueryFrom.append(") ");
            clauseAdded = true;
        }
        if (docid != null) {
            if (clauseAdded) {
                subQueryFrom.append(" and ");
            } else {
                subQueryFrom.append(" where ");
            }
            subQueryFrom.append("docid in (");
            for (i = 0; i < docid.length; ++i) {
                if (i > 0) {
                    subQueryFrom.append(", ");
                }
                subQueryFrom.append("?");
                paramValues.add(docid[i]);
            }
            subQueryFrom.append(") ");
            clauseAdded = true;
        }
        if (event != null) {
            if (clauseAdded) {
                subQueryFrom.append(" and ");
            } else {
                subQueryFrom.append(" where ");
            }
            subQueryFrom.append("event in (");
            subQueryFrom.append("?");
            String eventString = event;
            if (eventString.equals(Event.CREATE.xmlValue())) {
                isCreateEvent = true;
                subQueryFrom.append(",?");
                subQueryFrom.append(",?");
                subQueryFrom.append(",?");
                subQueryFrom.append(",?");
            } else {
                paramValues.add(eventString);
            }
            subQueryFrom.append(") ");
            clauseAdded = true;
        }
        if (startDate != null) {
            if (clauseAdded) {
                subQueryFrom.append(" and ");
            } else {
                subQueryFrom.append(" where ");
            }
            subQueryFrom.append("date_logged >= ?");
            clauseAdded = true;
        }
        if (endDate != null) {
            if (clauseAdded) {
                subQueryFrom.append(" and ");
            } else {
                subQueryFrom.append(" where ");
            }
            subQueryFrom.append("date_logged < ?");
            clauseAdded = true;
        }
        String countSelect = "select count(*) ";
        String subquerySelect = "select entryid ";
        String fieldSelect = "select entryid, id.guid as identifier, ip_address, user_agent, principal, case \twhen event = 'insert' then 'create'  when event = 'INSERT' then 'create'  when event = 'upload' then 'create'  when event = 'UPLOAD' then 'create' \telse event end as event, date_logged from access_log al, identifier id where al.docid = id.docid||'.'||id.rev and al.entryid in ";
        String orderByClause = " order by entryid ";
        String countQuery = countSelect + subQueryFrom.toString();
        this.logMetacat.debug((Object)("The count query is " + countQuery));
        String pagedSubquery = DatabaseService.getInstance().getDBAdapter().getPagedQuery(subquerySelect + subQueryFrom.toString() + orderByClause, start, count);
        String pagedQuery = fieldSelect + " ( " + pagedSubquery + " ) " + orderByClause;
        this.logMetacat.debug((Object)("The selection query is " + pagedQuery));
        this.logMetacat.debug((Object)("The startDate in the query is " + startDate));
        this.logMetacat.debug((Object)("The endDate in the query is " + startDate));
        DBConnection dbConn = null;
        int serialNumber = -1;
        try {
            dbConn = DBConnectionPool.getDBConnection("EventLog.getD1Report");
            serialNumber = dbConn.getCheckOutSerialNumber();
            PreparedStatement fieldsStmt = dbConn.prepareStatement(pagedQuery);
            PreparedStatement countStmt = dbConn.prepareStatement(countQuery);
            int parameterIndex = 1;
            for (String val : paramValues) {
                countStmt.setString(parameterIndex, val);
                fieldsStmt.setString(parameterIndex, val);
                ++parameterIndex;
            }
            if (isCreateEvent) {
                countStmt.setString(parameterIndex, "insert");
                fieldsStmt.setString(parameterIndex, "insert");
                countStmt.setString(++parameterIndex, "INSERT");
                fieldsStmt.setString(parameterIndex, "INSERT");
                countStmt.setString(++parameterIndex, "upload");
                fieldsStmt.setString(parameterIndex, "upload");
                countStmt.setString(++parameterIndex, "UPLOAD");
                fieldsStmt.setString(parameterIndex, "UPLOAD");
                countStmt.setString(++parameterIndex, "create");
                fieldsStmt.setString(parameterIndex, "create");
                ++parameterIndex;
            }
            if (startDate != null) {
                countStmt.setTimestamp(parameterIndex, startDate);
                fieldsStmt.setTimestamp(parameterIndex, startDate);
                ++parameterIndex;
            }
            if (endDate != null) {
                countStmt.setTimestamp(parameterIndex, endDate);
                fieldsStmt.setTimestamp(parameterIndex, endDate);
                ++parameterIndex;
            }
            Vector<LogEntry> logs = new Vector<LogEntry>();
            if (count != 0) {
                long startTime = System.currentTimeMillis();
                this.logMetacat.debug((Object)("Time to start to execute the selection query " + startTime));
                fieldsStmt.execute();
                long endTime = System.currentTimeMillis();
                this.logMetacat.debug((Object)("Time to run the selection query is " + (endTime - startTime) / 1000L + " seconds."));
                ResultSet rs = fieldsStmt.getResultSet();
                while (rs.next()) {
                    LogEntry logEntry = new LogEntry();
                    logEntry.setEntryId(rs.getString(1));
                    Identifier identifier = new Identifier();
                    identifier.setValue(rs.getString(2));
                    logEntry.setIdentifier(identifier);
                    logEntry.setIpAddress(anonymous ? "N/A" : rs.getString(3));
                    String userAgent = "N/A";
                    if (rs.getString(4) != null) {
                        userAgent = rs.getString(4);
                    }
                    logEntry.setUserAgent(userAgent);
                    Subject subject = new Subject();
                    subject.setValue(anonymous ? "N/A" : rs.getString(5));
                    logEntry.setSubject(subject);
                    String logEventString = rs.getString(6);
                    if (logEventString == null) {
                        logEventString = "unknown";
                    }
                    logEntry.setEvent(logEventString);
                    logEntry.setDateLogged((Date)rs.getTimestamp(7));
                    logEntry.setNodeIdentifier(memberNode);
                    logs.add(logEntry);
                }
                fieldsStmt.close();
                long endTime2 = System.currentTimeMillis();
                this.logMetacat.debug((Object)("Time to put the query result to the log is " + (endTime2 - endTime) / 1000L + " seconds."));
            }
            log.setLogEntryList(logs);
            log.setStart(start.intValue());
            log.setCount(logs.size());
            int total = 0;
            long startTime = System.currentTimeMillis();
            this.logMetacat.debug((Object)("Time to start to execute the counting query " + startTime));
            countStmt.execute();
            long endTime = System.currentTimeMillis();
            this.logMetacat.debug((Object)("Time to run the counting query is " + (endTime - startTime) / 1000L + " seconds."));
            ResultSet countRs = countStmt.getResultSet();
            if (countRs.next()) {
                total = countRs.getInt(1);
            }
            countStmt.close();
            log.setTotal(total);
        }
        catch (SQLException e) {
            this.logMetacat.error((Object)("Error while getting log events: " + e.getMessage()), (Throwable)e);
        }
        finally {
            DBConnectionPool.returnDBConnection(dbConn, serialNumber);
        }
        return log;
    }

    private String generateXmlRecord(String entryId, String ipAddress, String userAgent, String principal, String docid, String event, Timestamp dateLogged) {
        StringBuffer rec = new StringBuffer();
        rec.append("<logEntry>");
        rec.append(this.generateXmlElement("entryid", entryId));
        rec.append(this.generateXmlElement("ipAddress", ipAddress));
        rec.append(this.generateXmlElement("userAgent", userAgent));
        rec.append(this.generateXmlElement("principal", principal));
        rec.append(this.generateXmlElement("docid", docid));
        rec.append(this.generateXmlElement("event", event));
        rec.append(this.generateXmlElement("dateLogged", DateTimeMarshaller.serializeDateToUTC((Date)dateLogged)));
        rec.append("</logEntry>\n");
        return rec.toString();
    }

    private String generateXmlElement(String name, String value) {
        return "<" + name + ">" + value + "</" + name + ">";
    }
}

