/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.clientview;

import edu.ucsb.nceas.metacat.client.MetacatException;
import edu.ucsb.nceas.metacat.clientview.ClientView;
import edu.ucsb.nceas.metacat.clientview.ClientViewHelper;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class ClientFgdcHelper {
    private static XPath xpath = XPathFactory.newInstance().newXPath();
    public static final String FGDC_DATA_FILE_DOCID_XPATH = "/metadata/distinfo/stdorder/digform/digtopt/onlinopt/computer/networka/networkr";
    public static final String FGDC_DATA_FILE_QUERY_XPATH = "/metadata/distinfo/stdorder/digform/digtopt/onlinopt/computer/networka/networkr[text()='%1s']";
    public static final String FGDC_DATA_FILE_NAME_XPATH = "digtinfo/formcont";
    public static final String FGDC_DATA_FILE_NODES_XPATH = "stdorder/digform/digtopt/onlinopt/computer/networka/networkr";
    public static final String PATH4ANCESTOR = "/metadata/distinfo/stdorder/digform/digtopt/onlinopt/computer/networka/networkr[text()='%1s']/ancestor::node()[name()='%2s']";
    public static final String SUB_DOCS_PATH = "/metadata/distinfo/stdorder/digform/digtopt/onlinopt/computer/networka/networkr/text()";
    public static final String FGDC_DOCID_XPATH = "/metadata/distinfo/resdesc";
    public static final String FGDC_FILE_NAME_XPATH = "custom";
    public static final String XPATH_QUERY_TEMPLATE = "/metadata/distinfo/resdesc[text()='%1s']";
    public static final String FGDC_DOCID_ROOT_XPATH = "/metadata/distinfo/resdesc[text()='%1s']/ancestor::node()[name()='distinfo']";
    public static final String FGDC_SYSTEM_ID = "http://www.fgdc.gov/metadata/fgdc-std-001-1998.dtd";

    public static void clientDeleteRequest(ClientView clientViewBean, ClientViewHelper clientViewHelper) {
        String result = null;
        String docId = clientViewBean.getDocId();
        try {
            Document resultSetDoc = clientViewHelper.query(FGDC_DATA_FILE_DOCID_XPATH, docId, null);
            String parentDocId = xpath.evaluate("/resultset/document/docid", resultSetDoc.getDocumentElement());
            if (parentDocId != null && !parentDocId.equals("")) {
                clientViewHelper.setMetadataDoc(parentDocId);
                String revisedDocId = ClientFgdcHelper.removeDataDocIdFromFGDC(docId, parentDocId, clientViewHelper);
                clientViewBean.setDocId(revisedDocId);
                clientViewBean.setMetaFileDocId(revisedDocId);
            } else {
                clientViewHelper.setMetadataDoc(docId);
                NodeList nodeLst = (NodeList)xpath.evaluate(SUB_DOCS_PATH, clientViewHelper.getMetadataDoc().getDocumentElement(), XPathConstants.NODESET);
                for (int i = 0; i < nodeLst.getLength(); ++i) {
                    Node node = nodeLst.item(i);
                    String subDocId = node.getNodeValue();
                    try {
                        clientViewHelper.getMetacatClient().delete(subDocId);
                        continue;
                    }
                    catch (MetacatException ex) {
                        ex.printStackTrace();
                    }
                }
                clientViewBean.setMetaFileDocId(null);
            }
            result = clientViewHelper.getMetacatClient().delete(docId);
            clientViewBean.setMessage(2, result);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static String removeDataDocIdFromFGDC(String docId, String parentDocId, ClientViewHelper clientViewHelper) throws Exception {
        String revision = "";
        Document doc = clientViewHelper.getMetadataDoc();
        if (doc != null) {
            String tmp = PATH4ANCESTOR.replaceFirst("%1s", docId);
            String pathToDigform = tmp.replaceFirst("%2s", "digform");
            Node node = (Node)xpath.evaluate(pathToDigform, doc.getDocumentElement(), XPathConstants.NODE);
            node.getParentNode().removeChild(node);
            String xPathQuery = XPATH_QUERY_TEMPLATE.replaceFirst("%1s", parentDocId);
            revision = clientViewHelper.nextVersion(parentDocId, xPathQuery);
            Reader reader = XMLUtilities.getDOMTreeAsReader((Node)doc.getDocumentElement(), (boolean)false);
            clientViewHelper.getMetacatClient().update(revision, reader, null);
        }
        return revision;
    }

    public static boolean handlePackageUpload(String metaDocId, HashMap dataDocIDs, String contactName, String metaFNm, Document metadataDoc) throws IOException {
        boolean result = true;
        Node newBranch = ClientFgdcHelper.getFGDCdisinfo(contactName, metaDocId, metaFNm, dataDocIDs);
        Node metaRootNode = ClientFgdcHelper.addDistInfoToFGDC(newBranch, metadataDoc);
        return result;
    }

    public static boolean isFGDC(Document metadataDoc) {
        String sysId;
        DocumentType docType;
        boolean result = false;
        String FGDC_TEST_EXPRESSION = "/metadata/idinfo/citation/citeinfo/title";
        Node node = null;
        if (metadataDoc != null && (docType = metadataDoc.getDoctype()) != null && (sysId = docType.getSystemId()) != null) {
            boolean bl = result = sysId.indexOf(FGDC_SYSTEM_ID) > -1;
        }
        if (metadataDoc != null && !result) {
            try {
                node = (Node)xpath.evaluate("/metadata/idinfo/citation/citeinfo/title", metadataDoc.getDocumentElement(), XPathConstants.NODE);
            }
            catch (XPathExpressionException ex) {
                ex.printStackTrace();
            }
            result = node != null;
        }
        return result;
    }

    public static boolean hasMetacatInfo(String docId, Document metadataDoc) {
        boolean result = false;
        String xPathQuery = XPATH_QUERY_TEMPLATE.replaceFirst("%1s", docId);
        try {
            String queryResult = xpath.evaluate(xPathQuery, metadataDoc);
            result = queryResult != null && !queryResult.equals("");
        }
        catch (XPathExpressionException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private static Node getFGDCdisinfo(String contactName, String resourceDescription, String metaFNm, HashMap dataDocIDs) throws IOException {
        Element result = null;
        String XML = "<distinfo>    <distrib>        <cntinfo>            <cntperp>                <cntper></cntper>            </cntperp>            <cntaddr>                <addrtype></addrtype>                <address></address>                <city></city>                <state></state>                <postal></postal>                <country></country>            </cntaddr>            <cntvoice></cntvoice>        </cntinfo>    </distrib>    <resdesc></resdesc>    <distliab></distliab>    <stdorder>        <digform>            <digtinfo>                <formname></formname>                <formcont></formcont>            </digtinfo>            <digtopt>                <onlinopt>                    <computer>                        <networka>                            <networkr></networkr>                        </networka>                    </computer>                </onlinopt>            </digtopt>        </digform>        <fees></fees>    </stdorder>    <custom></custom></distinfo>";
        Document doc = XMLUtilities.getXMLReaderAsDOMDocument((Reader)new StringReader("<distinfo>    <distrib>        <cntinfo>            <cntperp>                <cntper></cntper>            </cntperp>            <cntaddr>                <addrtype></addrtype>                <address></address>                <city></city>                <state></state>                <postal></postal>                <country></country>            </cntaddr>            <cntvoice></cntvoice>        </cntinfo>    </distrib>    <resdesc></resdesc>    <distliab></distliab>    <stdorder>        <digform>            <digtinfo>                <formname></formname>                <formcont></formcont>            </digtinfo>            <digtopt>                <onlinopt>                    <computer>                        <networka>                            <networkr></networkr>                        </networka>                    </computer>                </onlinopt>            </digtopt>        </digform>        <fees></fees>    </stdorder>    <custom></custom></distinfo>"));
        result = doc.getDocumentElement();
        try {
            Node node = (Node)xpath.evaluate("/distinfo/distrib/cntinfo/cntperp/cntper", result, XPathConstants.NODE);
            ClientViewHelper.setTextContent(xpath, node, contactName);
            node = (Node)xpath.evaluate("/distinfo/resdesc", result, XPathConstants.NODE);
            ClientViewHelper.setTextContent(xpath, node, resourceDescription);
            node = (Node)xpath.evaluate("/distinfo/custom", result, XPathConstants.NODE);
            ClientViewHelper.setTextContent(xpath, node, metaFNm);
            Node stdorder = (Node)xpath.evaluate("/distinfo/stdorder", result, XPathConstants.NODE);
            Node digformBranch = (Node)xpath.evaluate("/distinfo/stdorder/digform", result, XPathConstants.NODE);
            Iterator iterIt = dataDocIDs.keySet().iterator();
            while (iterIt.hasNext()) {
                String key = (String)iterIt.next();
                node = (Node)xpath.evaluate("digtopt/onlinopt/computer/networka/networkr", digformBranch, XPathConstants.NODE);
                ClientViewHelper.setTextContent(xpath, node, key);
                String[] fileInfo = (String[])dataDocIDs.get(key);
                if (fileInfo != null) {
                    Node formname = (Node)xpath.evaluate("digtinfo/formname", digformBranch, XPathConstants.NODE);
                    String value = fileInfo[0];
                    if (value != null && !value.equals("")) {
                        ClientViewHelper.setTextContent(xpath, formname, value);
                    } else {
                        ClientViewHelper.setTextContent(xpath, formname, "");
                    }
                    Node formcont = (Node)xpath.evaluate(FGDC_DATA_FILE_NAME_XPATH, digformBranch, XPathConstants.NODE);
                    value = fileInfo[1];
                    if (value != null && !value.equals("")) {
                        ClientViewHelper.setTextContent(xpath, formcont, value);
                    } else {
                        ClientViewHelper.setTextContent(xpath, formcont, "");
                    }
                }
                if (!iterIt.hasNext()) continue;
                digformBranch = digformBranch.cloneNode(true);
                stdorder.appendChild(digformBranch);
            }
        }
        catch (XPathExpressionException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    private static Node addDistInfoToFGDC(Node newBranch, Document metadataDoc) {
        Element result = null;
        if (newBranch != null) {
            result = metadataDoc.getDocumentElement();
            try {
                Node node = (Node)xpath.evaluate("/metadata/metainfo", result, XPathConstants.NODE);
                if (node != null) {
                    newBranch = metadataDoc.importNode(newBranch, true);
                    result.insertBefore(newBranch, node);
                }
            }
            catch (XPathExpressionException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static void updateFileNameAndType(Node root, String dataDocId, String[] fileInfo) {
        String FORMNAME_PATH = "digtinfo/formname";
        String FORMCONT_PATH = FGDC_DATA_FILE_NAME_XPATH;
        String tmp = PATH4ANCESTOR.replaceFirst("%1s", dataDocId);
        String pathToDigform = tmp.replaceFirst("%2s", "digform");
        Node digform = ClientViewHelper.getNode(xpath, pathToDigform, root);
        if (digform != null) {
            ClientViewHelper.updateNodeText(digform, xpath, "digtinfo/formname", fileInfo[0]);
            ClientViewHelper.updateNodeText(digform, xpath, FGDC_DATA_FILE_NAME_XPATH, fileInfo[1]);
        }
    }

    public static void updateMetadataFileName(Node root, String metadataDocId, String fileName) {
        if (fileName != null && !fileName.equals("")) {
            String pathToResdesc = XPATH_QUERY_TEMPLATE.replaceFirst("%1s", metadataDocId);
            ClientViewHelper.updateNodeText(root, xpath, pathToResdesc, metadataDocId);
        }
    }
}

