/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.metacat.spatial;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import edu.ucsb.nceas.metacat.spatial.SpatialFeatureSchema;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.BBoxExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class SpatialQuery {
    private static Logger log = Logger.getLogger((String)SpatialQuery.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<String> filterByBbox(float w, float s, float e, float n) {
        Vector<String> docids = new Vector<String>();
        SpatialFeatureSchema featureSchema = new SpatialFeatureSchema();
        ShapefileDataStore store = null;
        FeatureSource features = null;
        FeatureCollection collection = null;
        FilterFactory filterFactory = FilterFactoryFinder.createFilterFactory();
        try {
            store = new ShapefileDataStore(new File(SpatialFeatureSchema.polygonShpUri).toURL());
            features = store.getFeatureSource(store.getTypeNames()[0]);
            Envelope envelope = new Envelope((double)w, (double)e, (double)s, (double)n);
            BBoxExpression bbox = filterFactory.createBBoxExpression(envelope);
            Coordinate[] linestringCoordinates = new Coordinate[]{new Coordinate((double)w, (double)s), new Coordinate((double)w, (double)n), new Coordinate((double)e, (double)n), new Coordinate((double)e, (double)s), new Coordinate((double)w, (double)s)};
            GeometryFactory geomFac = new GeometryFactory();
            Polygon bboxGeom = geomFac.createPolygon(geomFac.createLinearRing(linestringCoordinates), null);
            SimpleFeatureType featureType = store.getSchema(store.getTypeNames()[0]);
            AttributeExpression geometry = filterFactory.createAttributeExpression(featureType.getGeometryDescriptor().getName().toString());
            GeometryFilter bboxFilter = filterFactory.createGeometryFilter((short)4);
            bboxFilter.addLeftGeometry((Expression)geometry);
            bboxFilter.addRightGeometry((Expression)bbox);
            collection = features.getFeatures((Filter)bboxFilter);
            Iterator iterator = collection.iterator();
            try {
                for (SimpleFeature feature : collection) {
                    Geometry geom = (Geometry)feature.getAttribute(0);
                    if (!geom.within((Geometry)bboxGeom)) continue;
                    docids.add((String)feature.getAttribute(1));
                }
            }
            finally {
                collection.close(iterator);
            }
            store = new ShapefileDataStore(new File(SpatialFeatureSchema.pointShpUri).toURL());
            features = store.getFeatureSource(store.getTypeNames()[0]);
            featureType = store.getSchema(store.getTypeNames()[0]);
            geometry = filterFactory.createAttributeExpression(featureType.getGeometryDescriptor().getName().toString());
            bboxFilter = filterFactory.createGeometryFilter((short)4);
            bboxFilter.addLeftGeometry((Expression)geometry);
            bboxFilter.addRightGeometry((Expression)bbox);
            collection = features.getFeatures((Filter)bboxFilter);
            iterator = collection.iterator();
            String docid = null;
            try {
                for (SimpleFeature feature : collection) {
                    Geometry geom = (Geometry)feature.getAttribute(0);
                    if (!geom.intersects((Geometry)bboxGeom) || docids.contains(docid = (String)feature.getAttribute(1))) continue;
                    docids.add(docid);
                }
            }
            finally {
                collection.close(iterator);
            }
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (IllegalFilterException ex) {
            ex.printStackTrace();
        }
        return docids;
    }
}

