/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid.client;

import java.io.FileInputStream;
import java.net.URL;
import org.ecoinformatics.ecogrid.stub.EcoGridPutInterfaceLevelOnePortType;
import org.ecoinformatics.ecogrid.stub.service.EcoGridPutInterfaceLevelOneServiceGridLocator;

public class EcogridPutClient {
    private static final int QUERY_OPERATION = 1;
    private static final int GET_OPERATION = 2;
    private URL serviceURL = null;
    private EcoGridPutInterfaceLevelOnePortType ecogrid = null;

    public static void main(String[] args) {
        if (args.length < 5) {
            System.out.println("Usage: java org.ecoinformatics.ecogrid.client.EcogridPutClient obj_type filename ecogrid_obj_id sessionId GSH");
            System.out.println("       where obj_type is \"data\" or \"metadata\".");
            System.exit(0);
        }
        System.out.println("datatype is: " + args[0]);
        System.out.println("localfilename is: " + args[1]);
        System.out.println("ecogrid object ID is:" + args[2]);
        System.out.println("GSH is: " + args[4]);
        int objType = 1;
        String strObjType = args[0];
        if (strObjType.compareToIgnoreCase("data") == 0) {
            objType = 1;
        } else if (strObjType.compareToIgnoreCase("metadata") == 0) {
            objType = 2;
        } else {
            System.out.println("Unknow object type ==> " + args[0] + ". The object type is either \"data\" or \"metadata\".");
            System.exit(0);
        }
        try {
            String fileName = args[1];
            String ecogridObjId = args[2];
            String sessionId = args[3];
            URL GSH = new URL(args[4]);
            EcogridPutClient client = new EcogridPutClient(GSH);
            client.createEcoGridPutLevelOnePortType();
            client.put(fileName, ecogridObjId, objType, sessionId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public EcogridPutClient(URL serviceGSH) {
        this.serviceURL = serviceGSH;
    }

    public void put(String fileName, String ecogridOgjId, int objType, String sessionId) throws Exception {
        byte[] bytes = this.GetBytesFromFile(fileName);
        this.ecogrid.put(bytes, ecogridOgjId, objType, sessionId);
    }

    public void put(byte[] bytes, String ecogridOgjId, int objType, String sessionId) throws Exception {
        this.ecogrid.put(bytes, ecogridOgjId, objType, sessionId);
    }

    byte[] GetBytesFromFile(String fileName) {
        byte[] readBytes = new byte[2000];
        byte[] total_bytes = null;
        byte[] tmp_bytes = null;
        try {
            FileInputStream file = new FileInputStream(fileName);
            int n = file.read(readBytes, 0, 2000);
            boolean cur_byte_cnt = false;
            while (n > 0) {
                int i;
                if (total_bytes == null) {
                    total_bytes = new byte[n];
                    for (i = 0; i < n; ++i) {
                        total_bytes[i] = readBytes[i];
                    }
                } else {
                    tmp_bytes = new byte[total_bytes.length];
                    for (i = 0; i < total_bytes.length; ++i) {
                        tmp_bytes[i] = total_bytes[i];
                    }
                    total_bytes = null;
                    total_bytes = new byte[tmp_bytes.length + n];
                    for (i = 0; i < tmp_bytes.length; ++i) {
                        total_bytes[i] = tmp_bytes[i];
                    }
                    for (i = 0; i < n; ++i) {
                        total_bytes[tmp_bytes.length + i] = readBytes[i];
                    }
                    tmp_bytes = null;
                }
                n = file.read(readBytes, 0, 2000);
            }
            file.close();
        }
        catch (Exception e) {
            System.out.println("Exception in reading data from file: " + e.getMessage());
            System.exit(1);
        }
        return total_bytes;
    }

    public void createEcoGridPutLevelOnePortType() throws Exception {
        EcoGridPutInterfaceLevelOneServiceGridLocator loc = new EcoGridPutInterfaceLevelOneServiceGridLocator();
        this.ecogrid = loc.getEcoGridPutInterfaceLevelOnePort(this.serviceURL);
    }
}

