/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.Host;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.MetaDataTable;
import edu.sdsc.grid.io.srb.SRBCommands;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBMetaDataSet;
import edu.sdsc.grid.io.srb.SRBProtocol;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Vector;

class SRBMetaDataCommands {
    private SRBCommands commands;

    SRBMetaDataCommands(SRBCommands sRBCommands) throws IOException {
        this.commands = sRBCommands;
    }

    protected void finalize() {
        if (this.commands != null) {
            this.commands = null;
        }
    }

    static String getOperator(MetaDataCondition metaDataCondition) {
        return MetaDataCondition.getOperatorString(metaDataCondition.getOperator());
    }

    static String getOperator(int n) {
        return MetaDataCondition.getOperatorString(n);
    }

    private String quotes(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return "";
            }
        }
        return "'";
    }

    private String fixLIKE(String string) {
        String string2 = string;
        int n = string.indexOf("*");
        while (n >= 0) {
            string = string.substring(0, n) + "%" + string.substring(n + 1);
            n = string.indexOf("*");
        }
        n = string.indexOf("?");
        while (n >= 0) {
            string = string.substring(0, n) + "_" + string.substring(n + 1);
            n = string.indexOf("?");
        }
        if (string.indexOf("%") < 0 && string.indexOf("_") < 0) {
            string = "%" + string + "%";
        }
        return string;
    }

    private MetaDataTable fixLIKE(MetaDataTable metaDataTable, boolean bl) {
        int n = metaDataTable.getRowCount();
        int n2 = metaDataTable.getColumnCount();
        int n3 = -1;
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n2) {
                if (n5 == 1 && metaDataTable.getOperator(n4) == 10 || n5 == 0 && bl) {
                    String string;
                    String string2 = string = metaDataTable.getStringValue(n4, n5);
                    n3 = string.indexOf("*");
                    while (n3 >= 0) {
                        string = string.substring(0, n3) + "%" + string.substring(n3 + 1);
                        n3 = string.indexOf("*");
                    }
                    n3 = string.indexOf("?");
                    while (n3 >= 0) {
                        string = string.substring(0, n3) + "_" + string.substring(n3 + 1);
                        n3 = string.indexOf("?");
                    }
                    if (string.indexOf("%") < 0 && string.indexOf("_") < 0) {
                        string = "%" + string + "%";
                    }
                    if (!string2.equals(string)) {
                        metaDataTable.setStringValue(n4, n5, string);
                    }
                }
                ++n5;
            }
            ++n4;
        }
        return metaDataTable;
    }

    private void setTableQval(MetaDataTable metaDataTable, char[][] cArray, String string) {
        String string2 = new String(" = '" + metaDataTable.getStringValue(0, 0) + "'");
        System.arraycopy(string2.toCharArray(), 0, cArray[SRBMetaDataSet.getSRBID(string + "0_1")], 0, string2.length());
        string2 = new String(SRBMetaDataCommands.getOperator(metaDataTable.getOperator(0)) + " '" + metaDataTable.getStringValue(0, 1) + "'");
        System.arraycopy(string2.toCharArray(), 0, cArray[SRBMetaDataSet.getSRBID(string + "1_1")], 0, string2.length());
        if (metaDataTable.getRowCount() >= 2) {
            string2 = new String(" = '" + metaDataTable.getStringValue(1, 0) + "'");
            System.arraycopy(string2.toCharArray(), 0, cArray[SRBMetaDataSet.getSRBID(string + "0_2")], 0, string2.length());
            string2 = new String(SRBMetaDataCommands.getOperator(metaDataTable.getOperator(1)) + " '" + metaDataTable.getStringValue(1, 1) + "'");
            System.arraycopy(string2.toCharArray(), 0, cArray[SRBMetaDataSet.getSRBID(string + "1_2")], 0, string2.length());
        }
        if (metaDataTable.getRowCount() >= 3) {
            string2 = new String(" = '" + metaDataTable.getStringValue(2, 0) + "'");
            System.arraycopy(string2.toCharArray(), 0, cArray[SRBMetaDataSet.getSRBID(string + "0_3")], 0, string2.length());
            string2 = new String(SRBMetaDataCommands.getOperator(metaDataTable.getOperator(2)) + " '" + metaDataTable.getStringValue(2, 1) + "'");
            System.arraycopy(string2.toCharArray(), 0, cArray[SRBMetaDataSet.getSRBID(string + "1_3")], 0, string2.length());
        }
        if (metaDataTable.getRowCount() >= 4) {
            string2 = new String(" = '" + metaDataTable.getStringValue(3, 0) + "'");
            System.arraycopy(string2.toCharArray(), 0, cArray[SRBMetaDataSet.getSRBID(string + "0_4")], 0, string2.length());
            string2 = new String(SRBMetaDataCommands.getOperator(metaDataTable.getOperator(3)) + " " + "'" + metaDataTable.getStringValue(3, 1) + "'");
            System.arraycopy(string2.toCharArray(), 0, cArray[SRBMetaDataSet.getSRBID(string + "1_4")], 0, string2.length());
        }
        if ((string.equals("definable metadata for files") || string.equals("definable metadata for directories")) && metaDataTable.getRowCount() >= 5) {
            string2 = new String(" = '" + metaDataTable.getStringValue(4, 0) + "'");
            System.arraycopy(string2.toCharArray(), 0, cArray[SRBMetaDataSet.getSRBID(string + "0_5")], 0, string2.length());
            string2 = new String(SRBMetaDataCommands.getOperator(metaDataTable.getOperator(4)) + " '" + metaDataTable.getStringValue(4, 1) + "'");
            System.arraycopy(string2.toCharArray(), 0, cArray[SRBMetaDataSet.getSRBID(string + "1_5")], 0, string2.length());
        }
    }

    private String setTableGenQuery(MetaDataTable metaDataTable, MetaDataCondition metaDataCondition) {
        if (metaDataTable == null) {
            return "";
        }
        String string = metaDataCondition.getFieldName();
        String string2 = SRBMetaDataCommands.getOperator(metaDataCondition);
        String string3 = new String("'" + metaDataTable.getStringValue(0, 0) + "'\u0000");
        SRBMetaDataSet.getSRBID(string + "0_1");
        string3 = string3 + new String(" " + SRBMetaDataCommands.getOperator(metaDataTable.getOperator(0)) + " '" + metaDataTable.getStringValue(0, 1) + "'\u0000");
        SRBMetaDataSet.getSRBID(string + "1_1");
        if (metaDataTable.getRowCount() >= 2) {
            string3 = string3 + new String(" " + string2 + " '" + metaDataTable.getStringValue(1, 0) + "'\u0000");
            SRBMetaDataSet.getSRBID(string + "0_2");
            string3 = string3 + new String(" " + SRBMetaDataCommands.getOperator(metaDataTable.getOperator(1)) + " '" + metaDataTable.getStringValue(1, 1) + "'\u0000");
            SRBMetaDataSet.getSRBID(string + "1_2");
            if (metaDataTable.getRowCount() >= 3) {
                string3 = string3 + new String(" " + string2 + " '" + metaDataTable.getStringValue(2, 0) + "'\u0000");
                SRBMetaDataSet.getSRBID(string + "0_3");
                string3 = string3 + new String(" " + SRBMetaDataCommands.getOperator(metaDataTable.getOperator(2)) + " '" + metaDataTable.getStringValue(2, 1) + "'\u0000");
                SRBMetaDataSet.getSRBID(string + "1_3");
                if (metaDataTable.getRowCount() >= 4) {
                    string3 = string3 + new String(" " + string2 + " '" + metaDataTable.getStringValue(3, 0) + "'\u0000");
                    SRBMetaDataSet.getSRBID(string + "0_4");
                    string3 = string3 + new String(" " + SRBMetaDataCommands.getOperator(metaDataTable.getOperator(3)) + " " + "'" + metaDataTable.getStringValue(3, 1) + "'\u0000");
                    SRBMetaDataSet.getSRBID(string + "1_4");
                    if ((string.equals("definable metadata for files") || string.equals("definable metadata for directories")) && metaDataTable.getRowCount() >= 5) {
                        string3 = string3 + new String(" " + string2 + " '" + metaDataTable.getStringValue(4, 0) + "'\u0000");
                        SRBMetaDataSet.getSRBID(string + "0_5");
                        string3 = string3 + new String(" " + SRBMetaDataCommands.getOperator(metaDataTable.getOperator(4)) + " '" + metaDataTable.getStringValue(4, 1) + "'\u0000");
                        SRBMetaDataSet.getSRBID(string + "1_5");
                    }
                }
            }
        }
        return string3;
    }

    private int[] setTableConditionIDs(MetaDataTable metaDataTable, String string) {
        int[] nArray = null;
        int n = metaDataTable.getRowCount();
        if (n < 5) {
            nArray = new int[n * 2];
        } else if (string.equals("definable metadata for files") || string.equals("definable metadata for directories")) {
            nArray = new int[10];
        }
        nArray[0] = SRBMetaDataSet.getSRBID(string + "0_1");
        nArray[1] = SRBMetaDataSet.getSRBID(string + "1_1");
        if (nArray.length >= 4) {
            nArray[2] = SRBMetaDataSet.getSRBID(string + "0_2");
            nArray[3] = SRBMetaDataSet.getSRBID(string + "1_2");
            if (nArray.length >= 6) {
                nArray[4] = SRBMetaDataSet.getSRBID(string + "0_3");
                nArray[5] = SRBMetaDataSet.getSRBID(string + "1_3");
                if (nArray.length >= 8) {
                    nArray[6] = SRBMetaDataSet.getSRBID(string + "0_4");
                    nArray[7] = SRBMetaDataSet.getSRBID(string + "1_4");
                    if (nArray.length >= 10) {
                        nArray[8] = SRBMetaDataSet.getSRBID(string + "0_5");
                        nArray[9] = SRBMetaDataSet.getSRBID(string + "1_5");
                    }
                }
            }
        }
        return nArray;
    }

    private SRBMetaDataRecordList[] joinRecordLists(SRBMetaDataRecordList[] sRBMetaDataRecordListArray, SRBMetaDataRecordList[] sRBMetaDataRecordListArray2, String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean[] blArray = null;
        int n4 = 0;
        SRBMetaDataRecordList[] sRBMetaDataRecordListArray3 = null;
        if (string != null && sRBMetaDataRecordListArray != null && sRBMetaDataRecordListArray2 != null) {
            blArray = new boolean[sRBMetaDataRecordListArray2.length];
            n = 0;
            while (n < sRBMetaDataRecordListArray.length) {
                int n5 = -1;
                int n6 = -1;
                n2 = 0;
                while (n2 < sRBMetaDataRecordListArray[n].getFieldCount()) {
                    if (sRBMetaDataRecordListArray[n].getField(n2).equals(MetaDataSet.getField(string))) {
                        n3 = 0;
                        while (n3 < sRBMetaDataRecordListArray2.length) {
                            int n7 = n3;
                            int n8 = 0;
                            while (n8 < sRBMetaDataRecordListArray2[n7].getFieldCount()) {
                                if (sRBMetaDataRecordListArray[n].getValue(n2).equals(sRBMetaDataRecordListArray2[n3].getValue(n8)) && sRBMetaDataRecordListArray2[n3].getField(n8).equals(MetaDataSet.getField(string))) {
                                    n5 = n3;
                                    if (string2 != null) {
                                        int n9 = 0;
                                        while (n9 < sRBMetaDataRecordListArray[n].getFieldCount()) {
                                            if (sRBMetaDataRecordListArray[n].getField(n9).equals(MetaDataSet.getField(string2))) {
                                                int n10 = 0;
                                                while (n10 < sRBMetaDataRecordListArray2[n3].getFieldCount()) {
                                                    if (sRBMetaDataRecordListArray[n].getValue(n9).equals(sRBMetaDataRecordListArray2[n3].getValue(n10))) {
                                                        n6 = n3;
                                                    }
                                                    ++n10;
                                                }
                                            }
                                            ++n9;
                                        }
                                    }
                                }
                                ++n8;
                            }
                            ++n3;
                        }
                    }
                    ++n2;
                }
                if (n5 >= 0 && (string2 == null || string2 != null && n5 == n6)) {
                    sRBMetaDataRecordListArray[n].combineRecordLists(sRBMetaDataRecordListArray2[n5]);
                    blArray[n5] = true;
                    ++n4;
                }
                ++n;
            }
            if (n4 > sRBMetaDataRecordListArray2.length) {
                sRBMetaDataRecordListArray3 = sRBMetaDataRecordListArray;
            } else {
                sRBMetaDataRecordListArray3 = new SRBMetaDataRecordList[sRBMetaDataRecordListArray.length + sRBMetaDataRecordListArray2.length - n4];
                System.arraycopy(sRBMetaDataRecordListArray, 0, sRBMetaDataRecordListArray3, 0, sRBMetaDataRecordListArray.length);
                System.arraycopy(sRBMetaDataRecordListArray2, 0, sRBMetaDataRecordListArray3, sRBMetaDataRecordListArray.length, sRBMetaDataRecordListArray2.length - n4);
                if (blArray != null) {
                    n = 0;
                    n3 = 0;
                    while (n < sRBMetaDataRecordListArray2.length) {
                        if (!blArray[n]) {
                            sRBMetaDataRecordListArray3[sRBMetaDataRecordListArray.length + n3] = sRBMetaDataRecordListArray2[n];
                            ++n3;
                        }
                        ++n;
                    }
                }
            }
            return sRBMetaDataRecordListArray3;
        }
        if (string == null && sRBMetaDataRecordListArray != null && sRBMetaDataRecordListArray2 != null) {
            sRBMetaDataRecordListArray3 = new SRBMetaDataRecordList[sRBMetaDataRecordListArray.length + sRBMetaDataRecordListArray2.length - n4];
            System.arraycopy(sRBMetaDataRecordListArray, 0, sRBMetaDataRecordListArray3, 0, sRBMetaDataRecordListArray.length);
            System.arraycopy(sRBMetaDataRecordListArray2, 0, sRBMetaDataRecordListArray3, sRBMetaDataRecordListArray.length, sRBMetaDataRecordListArray2.length - n4);
            return sRBMetaDataRecordListArray3;
        }
        if (sRBMetaDataRecordListArray == null) {
            return sRBMetaDataRecordListArray2;
        }
        if (sRBMetaDataRecordListArray2 == null) {
            return sRBMetaDataRecordListArray;
        }
        return null;
    }

    private SRBMetaDataRecordList[] getRecordsForDefinableQueries(int n, MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray, int n2, SRBMetaDataRecordList[] sRBMetaDataRecordListArray, boolean bl, boolean bl2) throws IOException {
        SRBMetaDataRecordList[] sRBMetaDataRecordListArray2 = null;
        sRBMetaDataRecordListArray2 = this.srbGetDataDirInfo(n, metaDataConditionArray, metaDataSelectArray, n2, bl, bl2);
        if (sRBMetaDataRecordListArray2 != null) {
            if (sRBMetaDataRecordListArray != null && sRBMetaDataRecordListArray2 != null) {
                sRBMetaDataRecordListArray2 = this.joinRecordLists(sRBMetaDataRecordListArray, sRBMetaDataRecordListArray2, null, null);
            }
            return sRBMetaDataRecordListArray2;
        }
        return null;
    }

    static final Object[] cleanNulls(Object[] objectArray) {
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        boolean bl = true;
        int n = 0;
        boolean bl2 = false;
        n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null) {
                vector.add(objectArray[n]);
            }
            ++n;
        }
        if (objectArray[n] == null && objectArray.length == 1) {
            return null;
        }
        return vector.toArray((Object[])Array.newInstance(objectArray[n].getClass(), 0));
    }

    static final Object[] cleanNullsAndDuplicates(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>(objectArray.length);
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null) {
                n2 = n + 1;
                while (n2 < objectArray.length) {
                    if (objectArray[n].equals(objectArray[n2])) {
                        bl = false;
                        n2 = objectArray.length;
                    }
                    ++n2;
                }
                if (bl) {
                    vector.add(objectArray[n]);
                }
                bl = true;
            }
            ++n;
        }
        if (objectArray.length == 1 && objectArray[0] == null) {
            return null;
        }
        return vector.toArray((Object[])Array.newInstance(objectArray[0].getClass(), 0));
    }

    private String addValueByStyle(int n, MetaDataCondition metaDataCondition, char[][] cArray) {
        String string = "";
        block0 : switch (n) {
            case 0: {
                switch (metaDataCondition.getFieldType()) {
                    case 3: 
                    case 4: {
                        string = string + "'" + metaDataCondition.getStringValue() + "'";
                        break block0;
                    }
                    case 0: {
                        string = string + metaDataCondition.getIntValue();
                        break block0;
                    }
                    case 2: {
                        string = string + metaDataCondition.getFloatValue();
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Invalid value type for the metadata attribute: " + metaDataCondition.getField());
            }
            case 1: {
                switch (metaDataCondition.getFieldType()) {
                    case 3: 
                    case 4: {
                        string = string + "'" + metaDataCondition.getStringValue(0) + "' and " + "'" + metaDataCondition.getStringValue(1) + "'";
                        break block0;
                    }
                    case 0: {
                        string = string + metaDataCondition.getIntValue(0) + " and " + metaDataCondition.getIntValue(1);
                        break block0;
                    }
                    case 2: {
                        string = string + metaDataCondition.getFloatValue(0) + " and " + metaDataCondition.getFloatValue(1);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Invalid value type for the metadata attribute: " + metaDataCondition.getField());
            }
            case 2: {
                switch (metaDataCondition.getFieldType()) {
                    case 3: 
                    case 4: {
                        string = string + "(";
                        int n2 = 0;
                        while (n2 < metaDataCondition.getCount()) {
                            string = string + "'" + metaDataCondition.getStringValue(n2) + "',";
                            ++n2;
                        }
                        break;
                    }
                    case 0: {
                        string = string + "(";
                        int n3 = 0;
                        while (n3 < metaDataCondition.getCount()) {
                            string = string + metaDataCondition.getIntValue(n3) + ",";
                            ++n3;
                        }
                        break;
                    }
                    case 2: {
                        string = string + "(";
                        int n4 = 0;
                        while (n4 < metaDataCondition.getCount()) {
                            string = string + metaDataCondition.getFloatValue(n4) + ",";
                            ++n4;
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid value type for the metadata attribute: " + metaDataCondition.getField());
                    }
                }
                string = string.substring(0, string.length() - 1) + ")";
                break;
            }
            case 14: {
                MetaDataTable metaDataTable = metaDataCondition.getTableValue();
                if (cArray == null) {
                    string = string + this.setTableGenQuery(metaDataTable, metaDataCondition);
                } else {
                    this.setTableQval(metaDataTable, cArray, metaDataCondition.getFieldName());
                }
                if (metaDataTable.getRowCount() <= 5) break;
                break;
            }
            default: {
                throw new RuntimeException("temp SRBMetaDataCommands.getdatadir,style");
            }
        }
        return string;
    }

    synchronized SRBMetaDataRecordList[] srbGetDataDirInfo(int n, MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray, int n2, boolean bl, boolean bl2) throws IOException {
        if (this.commands.versionNumber >= 3.0f) {
            return this.srbGenQuery(n, this.commands.getZone(), metaDataConditionArray, metaDataSelectArray, n2, bl, bl2);
        }
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = false;
        int n5 = metaDataConditionArray.length;
        int n6 = metaDataSelectArray.length;
        Object[] objectArray = new MetaDataCondition[n5];
        Object[] objectArray2 = new MetaDataSelect[n6];
        System.arraycopy(metaDataConditionArray, 0, objectArray, 0, n5);
        System.arraycopy(metaDataSelectArray, 0, objectArray2, 0, n6);
        objectArray = (MetaDataCondition[])SRBMetaDataCommands.cleanNullsAndDuplicates(objectArray);
        if (objectArray == null) {
            return null;
        }
        n5 = objectArray.length;
        if ((objectArray2 = (MetaDataSelect[])SRBMetaDataCommands.cleanNullsAndDuplicates(objectArray2)) == null) {
            return null;
        }
        n6 = objectArray2.length;
        try {
            int n7;
            int n8;
            char[][] cArray = new char[SRBFileSystem.TOTAL_METADATA_ATTRIBUTES][SRBFileSystem.MAX_TOKEN];
            int[] nArray = new int[SRBFileSystem.TOTAL_METADATA_ATTRIBUTES];
            SRBMetaDataRecordList[] sRBMetaDataRecordListArray = null;
            SRBMetaDataRecordList[] sRBMetaDataRecordListArray2 = null;
            SRBMetaDataRecordList[] sRBMetaDataRecordListArray3 = null;
            n3 = 0;
            while (n3 < n5) {
                if (objectArray[n3] != null) {
                    n8 = ((MetaDataCondition)objectArray[n3]).getStyle();
                    String string = "";
                    n7 = SRBMetaDataSet.getSRBID(((MetaDataCondition)objectArray[n3]).getFieldName());
                    if (n8 != 14) {
                        string = SRBMetaDataCommands.getOperator((MetaDataCondition)objectArray[n3]) + " " + string;
                    }
                    string = string + this.addValueByStyle(n8, (MetaDataCondition)objectArray[n3], cArray);
                    if (n8 != 14) {
                        System.arraycopy(string.toCharArray(), 0, cArray[n7], 0, string.length());
                    }
                }
                ++n3;
            }
            n8 = -1;
            String string = null;
            String string2 = null;
            n3 = 0;
            while (n3 < n6) {
                if (objectArray2[n3] != null) {
                    n7 = SRBMetaDataSet.getSRBID(((MetaDataSelect)objectArray2[n3]).getFieldName());
                    if (n7 == -1) {
                        objectArray2[n3] = MetaDataSet.newSelection("file name");
                        objectArray2 = MetaDataSet.mergeSelects(MetaDataSet.newSelection("directory name"), (MetaDataSelect[])objectArray2);
                        sRBMetaDataRecordListArray2 = this.getRecordsForDefinableQueries(n, (MetaDataCondition[])objectArray, (MetaDataSelect[])objectArray2, n2, sRBMetaDataRecordListArray, bl, bl2);
                        nArray = new int[SRBFileSystem.TOTAL_METADATA_ATTRIBUTES];
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata file0")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata file1")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata file2")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata file3")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata file4")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata file5")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata file6")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata file7")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata file8")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata file9")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"file name")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"directory name")] = 0x1000000;
                        string = "file name";
                        string2 = "directory name";
                        break;
                    }
                    if (n7 == -2) {
                        objectArray2[n3] = MetaDataSet.newSelection("directory name");
                        sRBMetaDataRecordListArray2 = this.getRecordsForDefinableQueries(n, (MetaDataCondition[])objectArray, (MetaDataSelect[])objectArray2, n2, sRBMetaDataRecordListArray, bl, bl2);
                        nArray = new int[SRBFileSystem.TOTAL_METADATA_ATTRIBUTES];
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata directory0")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata directory1")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata directory2")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata directory3")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata directory4")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata directory5")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata directory6")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata directory7")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata directory8")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata directory9")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"directory name")] = 0x1000000;
                        break;
                    }
                    if (n7 == -3) {
                        objectArray2[n3] = MetaDataSet.newSelection("user name");
                        objectArray2 = MetaDataSet.mergeSelects(MetaDataSet.newSelection("user domain"), (MetaDataSelect[])objectArray2);
                        sRBMetaDataRecordListArray2 = this.getRecordsForDefinableQueries(n, (MetaDataCondition[])objectArray, (MetaDataSelect[])objectArray2, n2, sRBMetaDataRecordListArray, bl, bl2);
                        nArray = new int[SRBFileSystem.TOTAL_METADATA_ATTRIBUTES];
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata user0")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata user1")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata user2")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata user3")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata user4")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata user5")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata user6")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata user7")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata user8")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata user9")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"user name")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"user domain")] = 0x1000000;
                        break;
                    }
                    if (n7 == -4) {
                        objectArray2[n3] = MetaDataSet.newSelection("resource name");
                        sRBMetaDataRecordListArray2 = this.getRecordsForDefinableQueries(n, (MetaDataCondition[])objectArray, (MetaDataSelect[])objectArray2, n2, sRBMetaDataRecordListArray, bl, bl2);
                        nArray = new int[SRBFileSystem.TOTAL_METADATA_ATTRIBUTES];
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata resource0")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata resource1")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata resource2")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata resource3")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata resource4")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata resource5")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata resource6")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata resource7")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata resource8")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"definable metadata resource9")] = 0x1000000;
                        nArray[SRBMetaDataSet.getSRBID((String)"resource name")] = 0x1000000;
                        break;
                    }
                    nArray[n7] = 0x1000000;
                }
                ++n3;
            }
            this.commands.startSRBCommand(2101, 4);
            this.commands.sendArg(n);
            this.commands.sendArg(cArray);
            this.commands.sendArg(nArray);
            this.commands.sendArg(n2);
            this.commands.flush();
            this.commands.commandStatus();
            sRBMetaDataRecordListArray = this.commands.returnSRBMetaDataRecordList();
            if (sRBMetaDataRecordListArray2 != null) {
                if (sRBMetaDataRecordListArray != null) {
                    n4 = 0;
                    while (n4 < sRBMetaDataRecordListArray.length) {
                        if (n8 < sRBMetaDataRecordListArray[n4].getContinuationIndex()) {
                            n8 = sRBMetaDataRecordListArray[n4].getContinuationIndex();
                            sRBMetaDataRecordListArray = this.joinRecordLists(sRBMetaDataRecordListArray, this.commands.srbGetMoreRows(n, n8, n2), string, string2);
                        }
                        ++n4;
                    }
                }
                sRBMetaDataRecordListArray3 = this.joinRecordLists(sRBMetaDataRecordListArray2, sRBMetaDataRecordListArray, string, string2);
            } else {
                sRBMetaDataRecordListArray3 = sRBMetaDataRecordListArray;
            }
            return sRBMetaDataRecordListArray3;
        }
        catch (SRBException sRBException) {
            if (sRBException.getType() == -3005) {
                return null;
            }
            throw sRBException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SRBMetaDataRecordList[] srbGenQuery(int n, String string, MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray, int n2, boolean bl, boolean bl2) throws IOException {
        String string2;
        MetaDataSelect[] metaDataSelectArray2;
        if (SRBCommands.DEBUG > 0) {
            System.err.println("\n srbGenQuery");
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = Integer.MIN_VALUE;
        boolean bl3 = false;
        SRBMetaDataRecordList[] sRBMetaDataRecordListArray = null;
        SRBMetaDataRecordList[] sRBMetaDataRecordListArray2 = null;
        SRBMetaDataRecordList[] sRBMetaDataRecordListArray3 = null;
        byte[] byArray = new byte[999];
        int n7 = 0;
        if (metaDataConditionArray != null) {
            metaDataConditionArray = (MetaDataCondition[])SRBMetaDataCommands.cleanNullsAndDuplicates(metaDataConditionArray);
            n7 = metaDataConditionArray.length;
            n3 = 0;
            while (n3 < n7) {
                if (metaDataConditionArray[n3].getStyle() == 14) {
                    metaDataConditionArray[n3] = metaDataConditionArray[n3].getOperator() == 10 ? MetaDataSet.newCondition(metaDataConditionArray[n3].getFieldName(), metaDataConditionArray[n3].getOperator(), this.fixLIKE(metaDataConditionArray[n3].getTableValue(), true)) : MetaDataSet.newCondition(metaDataConditionArray[n3].getFieldName(), metaDataConditionArray[n3].getOperator(), this.fixLIKE(metaDataConditionArray[n3].getTableValue(), false));
                } else if (metaDataConditionArray[n3].getOperator() == 10) {
                    metaDataConditionArray[n3] = MetaDataSet.newCondition(metaDataConditionArray[n3].getFieldName(), 10, this.fixLIKE(metaDataConditionArray[n3].getStringValue()));
                }
                ++n3;
            }
        }
        int n8 = metaDataSelectArray.length;
        MetaDataCondition[] metaDataConditionArray2 = null;
        Object[] objectArray = new MetaDataSelect[n8];
        int[] nArray = null;
        if (n7 > 0) {
            metaDataConditionArray2 = new MetaDataCondition[n7];
            System.arraycopy(metaDataConditionArray, 0, metaDataConditionArray2, 0, n7);
        }
        System.arraycopy(metaDataSelectArray, 0, objectArray, 0, n8);
        if (metaDataConditionArray2 != null) {
            n7 = metaDataConditionArray2.length;
            n3 = 0;
            while (n3 < metaDataConditionArray2.length) {
                if (SRBCommands.DEBUG > 3) {
                    System.err.println("conditions\t\t " + metaDataConditionArray2[n3].getFieldName() + " " + metaDataConditionArray2[n3].getStringValue());
                }
                if (metaDataConditionArray2[n3].getStyle() == 14) {
                    int n9 = metaDataConditionArray2[n3].getTableValue().getRowCount();
                    n7 = n9 >= 5 ? (metaDataConditionArray2[n3].getFieldName().equals("definable metadata for files") || metaDataConditionArray2[n3].getFieldName().equals("definable metadata for directories") ? (n7 += 5 * metaDataConditionArray2[n3].getTableValue().getColumnCount() - 1) : (n7 += 4 * metaDataConditionArray2[n3].getTableValue().getColumnCount() - 1)) : (n7 += n9 * metaDataConditionArray2[n3].getTableValue().getColumnCount() - 1);
                }
                ++n3;
            }
            if (n7 > 0) {
                n5 = 0;
                nArray = new int[n7];
                n3 = 0;
                while (n3 < metaDataConditionArray2.length) {
                    if (metaDataConditionArray2[n3] != null && nArray[n5] >= 0) {
                        n4 = n3 + 1;
                        while (n4 < metaDataConditionArray2.length) {
                            if (metaDataConditionArray2[n3].getField().equals(metaDataConditionArray2[n4].getField())) {
                                --n7;
                                nArray[n4 + 1] = -1;
                            }
                            ++n4;
                        }
                        if (metaDataConditionArray2[n3].getStyle() == 14) {
                            int[] nArray2 = this.setTableConditionIDs(metaDataConditionArray2[n3].getTableValue(), metaDataConditionArray2[n3].getFieldName());
                            System.arraycopy(nArray2, 0, nArray, n5, nArray2.length);
                            n5 += nArray2.length;
                        } else {
                            nArray[n5] = SRBMetaDataSet.getSRBID(metaDataConditionArray2[n3].getFieldName());
                            if (nArray[n3] == -5) {
                                bl3 = true;
                            }
                            ++n5;
                        }
                    } else {
                        ++n5;
                    }
                    ++n3;
                }
            }
        } else {
            n7 = 0;
        }
        if ((objectArray = (MetaDataSelect[])SRBMetaDataCommands.cleanNullsAndDuplicates(objectArray)) == null) {
            return null;
        }
        n8 = objectArray.length;
        int[] nArray3 = new int[n8];
        int[] nArray4 = new int[n8];
        int n10 = -1;
        String string3 = null;
        String string4 = null;
        n5 = n8;
        n3 = 0;
        while (n3 < n5) {
            n6 = SRBMetaDataSet.getSRBID(((MetaDataSelect)objectArray[n3]).getFieldName());
            if (n6 > 0) {
                nArray3[n3] = n6;
                nArray4[n3] = ((MetaDataSelect)objectArray[n3]).getOperation();
            } else if (n6 == -1) {
                if ((double)this.commands.versionNumber >= 3.31) {
                    objectArray[n3] = null;
                    metaDataSelectArray2 = new MetaDataSelect[]{MetaDataSet.newSelection("metadata number"), MetaDataSet.newSelection("file name"), MetaDataSet.newSelection("directory name"), MetaDataSet.newSelection("definable metadata file0"), MetaDataSet.newSelection("definable metadata file1"), MetaDataSet.newSelection("definable metadata file2"), MetaDataSet.newSelection("definable metadata file3"), MetaDataSet.newSelection("definable metadata file4"), MetaDataSet.newSelection("definable metadata file5"), MetaDataSet.newSelection("definable metadata file6"), MetaDataSet.newSelection("definable metadata file7"), MetaDataSet.newSelection("definable metadata file8"), MetaDataSet.newSelection("definable metadata file9")};
                    objectArray = MetaDataSet.mergeSelects((MetaDataSelect[])objectArray, metaDataSelectArray2);
                    if ((objectArray = (MetaDataSelect[])SRBMetaDataCommands.cleanNullsAndDuplicates(objectArray)) == null) {
                        return null;
                    }
                    n3 = -1;
                    n5 = n8 = objectArray.length;
                    nArray3 = new int[n8];
                    nArray4 = new int[n8];
                } else {
                    objectArray[n3] = MetaDataSet.newSelection("file name");
                    objectArray = MetaDataSet.mergeSelects(MetaDataSet.newSelection("directory name"), (MetaDataSelect[])objectArray);
                    sRBMetaDataRecordListArray2 = this.getRecordsForDefinableQueries(n, metaDataConditionArray2, (MetaDataSelect[])objectArray, n2, sRBMetaDataRecordListArray, bl, bl2);
                    n8 = 12;
                    nArray3 = new int[n8];
                    nArray4 = new int[n8];
                    nArray3[0] = SRBMetaDataSet.getSRBID("file name");
                    nArray3[1] = SRBMetaDataSet.getSRBID("directory name");
                    nArray3[2] = SRBMetaDataSet.getSRBID("definable metadata file0");
                    nArray3[3] = SRBMetaDataSet.getSRBID("definable metadata file1");
                    nArray3[4] = SRBMetaDataSet.getSRBID("definable metadata file2");
                    nArray3[5] = SRBMetaDataSet.getSRBID("definable metadata file3");
                    nArray3[6] = SRBMetaDataSet.getSRBID("definable metadata file4");
                    nArray3[7] = SRBMetaDataSet.getSRBID("definable metadata file5");
                    nArray3[8] = SRBMetaDataSet.getSRBID("definable metadata file6");
                    nArray3[9] = SRBMetaDataSet.getSRBID("definable metadata file7");
                    nArray3[10] = SRBMetaDataSet.getSRBID("definable metadata file8");
                    nArray3[11] = SRBMetaDataSet.getSRBID("definable metadata file9");
                    nArray4[0] = 1;
                    nArray4[1] = 1;
                    nArray4[2] = 1;
                    nArray4[3] = 1;
                    nArray4[4] = 1;
                    nArray4[5] = 1;
                    nArray4[6] = 1;
                    nArray4[7] = 1;
                    nArray4[8] = 1;
                    nArray4[9] = 1;
                    nArray4[10] = 1;
                    nArray4[11] = 1;
                    string3 = "file name";
                    string4 = "directory name";
                    n3 = n5;
                }
            } else if (n6 == -2) {
                if ((double)this.commands.versionNumber >= 3.31) {
                    objectArray[n3] = null;
                    metaDataSelectArray2 = new MetaDataSelect[]{MetaDataSet.newSelection("directory name"), MetaDataSet.newSelection("definable metadata directory0"), MetaDataSet.newSelection("definable metadata directory1"), MetaDataSet.newSelection("definable metadata directory2"), MetaDataSet.newSelection("definable metadata directory3"), MetaDataSet.newSelection("definable metadata directory4"), MetaDataSet.newSelection("definable metadata directory5"), MetaDataSet.newSelection("definable metadata directory6"), MetaDataSet.newSelection("definable metadata directory7"), MetaDataSet.newSelection("definable metadata directory8"), MetaDataSet.newSelection("definable metadata directory9"), MetaDataSet.newSelection("metadata number")};
                    objectArray = MetaDataSet.mergeSelects((MetaDataSelect[])objectArray, metaDataSelectArray2);
                    if ((objectArray = (MetaDataSelect[])SRBMetaDataCommands.cleanNullsAndDuplicates(objectArray)) == null) {
                        return null;
                    }
                    n3 = -1;
                    n5 = n8 = objectArray.length;
                    nArray3 = new int[n8];
                    nArray4 = new int[n8];
                } else {
                    objectArray[n3] = MetaDataSet.newSelection("directory name");
                    sRBMetaDataRecordListArray2 = this.getRecordsForDefinableQueries(n, metaDataConditionArray2, (MetaDataSelect[])objectArray, n2, sRBMetaDataRecordListArray, bl, bl2);
                    n8 = 11;
                    nArray3 = new int[n8];
                    nArray4 = new int[n8];
                    nArray3[0] = SRBMetaDataSet.getSRBID("directory name");
                    nArray3[1] = SRBMetaDataSet.getSRBID("definable metadata directory0");
                    nArray3[2] = SRBMetaDataSet.getSRBID("definable metadata directory1");
                    nArray3[3] = SRBMetaDataSet.getSRBID("definable metadata directory2");
                    nArray3[4] = SRBMetaDataSet.getSRBID("definable metadata directory3");
                    nArray3[5] = SRBMetaDataSet.getSRBID("definable metadata directory4");
                    nArray3[6] = SRBMetaDataSet.getSRBID("definable metadata directory5");
                    nArray3[7] = SRBMetaDataSet.getSRBID("definable metadata directory6");
                    nArray3[8] = SRBMetaDataSet.getSRBID("definable metadata directory7");
                    nArray3[9] = SRBMetaDataSet.getSRBID("definable metadata directory8");
                    nArray3[10] = SRBMetaDataSet.getSRBID("definable metadata directory9");
                    nArray4[0] = 1;
                    nArray4[1] = 1;
                    nArray4[2] = 1;
                    nArray4[3] = 1;
                    nArray4[4] = 1;
                    nArray4[5] = 1;
                    nArray4[6] = 1;
                    nArray4[7] = 1;
                    nArray4[8] = 1;
                    nArray4[9] = 1;
                    nArray4[10] = 1;
                    n3 = n5;
                }
            } else if (n6 == -3) {
                if ((double)this.commands.versionNumber >= 3.31) {
                    objectArray[n3] = null;
                    metaDataSelectArray2 = new MetaDataSelect[]{MetaDataSet.newSelection("user name"), MetaDataSet.newSelection("user domain"), MetaDataSet.newSelection("definable metadata user0"), MetaDataSet.newSelection("definable metadata user1"), MetaDataSet.newSelection("definable metadata user2"), MetaDataSet.newSelection("definable metadata user3"), MetaDataSet.newSelection("definable metadata user4"), MetaDataSet.newSelection("definable metadata user5"), MetaDataSet.newSelection("definable metadata user6"), MetaDataSet.newSelection("definable metadata user7"), MetaDataSet.newSelection("definable metadata user8"), MetaDataSet.newSelection("definable metadata user9")};
                    objectArray = MetaDataSet.mergeSelects((MetaDataSelect[])objectArray, metaDataSelectArray2);
                    if ((objectArray = (MetaDataSelect[])SRBMetaDataCommands.cleanNullsAndDuplicates(objectArray)) == null) {
                        return null;
                    }
                    n3 = -1;
                    n5 = n8 = objectArray.length;
                    nArray3 = new int[n8];
                    nArray4 = new int[n8];
                } else {
                    objectArray[n3] = MetaDataSet.newSelection("user name");
                    objectArray = MetaDataSet.mergeSelects(MetaDataSet.newSelection("user domain"), (MetaDataSelect[])objectArray);
                    sRBMetaDataRecordListArray2 = this.getRecordsForDefinableQueries(n, metaDataConditionArray2, (MetaDataSelect[])objectArray, n2, sRBMetaDataRecordListArray, bl, bl2);
                    n8 = 12;
                    nArray3 = new int[n8];
                    nArray4 = new int[n8];
                    nArray3[0] = SRBMetaDataSet.getSRBID("user name");
                    nArray3[1] = SRBMetaDataSet.getSRBID("user domain");
                    nArray3[2] = SRBMetaDataSet.getSRBID("definable metadata user0");
                    nArray3[3] = SRBMetaDataSet.getSRBID("definable metadata user1");
                    nArray3[4] = SRBMetaDataSet.getSRBID("definable metadata user2");
                    nArray3[5] = SRBMetaDataSet.getSRBID("definable metadata user3");
                    nArray3[6] = SRBMetaDataSet.getSRBID("definable metadata user4");
                    nArray3[7] = SRBMetaDataSet.getSRBID("definable metadata user5");
                    nArray3[8] = SRBMetaDataSet.getSRBID("definable metadata user6");
                    nArray3[9] = SRBMetaDataSet.getSRBID("definable metadata user7");
                    nArray3[10] = SRBMetaDataSet.getSRBID("definable metadata user8");
                    nArray3[11] = SRBMetaDataSet.getSRBID("definable metadata user9");
                    nArray4[0] = 1;
                    nArray4[1] = 1;
                    nArray4[2] = 1;
                    nArray4[3] = 1;
                    nArray4[4] = 1;
                    nArray4[5] = 1;
                    nArray4[6] = 1;
                    nArray4[7] = 1;
                    nArray4[8] = 1;
                    nArray4[9] = 1;
                    nArray4[10] = 1;
                    nArray4[11] = 1;
                    n3 = n5;
                }
            } else if (n6 == -4) {
                if ((double)this.commands.versionNumber >= 3.31) {
                    objectArray[n3] = null;
                    metaDataSelectArray2 = new MetaDataSelect[]{MetaDataSet.newSelection("resource name"), MetaDataSet.newSelection("definable metadata resource0"), MetaDataSet.newSelection("definable metadata resource1"), MetaDataSet.newSelection("definable metadata resource2"), MetaDataSet.newSelection("definable metadata resource3"), MetaDataSet.newSelection("definable metadata resource4"), MetaDataSet.newSelection("definable metadata resource5"), MetaDataSet.newSelection("definable metadata resource6"), MetaDataSet.newSelection("definable metadata resource7"), MetaDataSet.newSelection("definable metadata resource8"), MetaDataSet.newSelection("definable metadata resource9")};
                    objectArray = MetaDataSet.mergeSelects((MetaDataSelect[])objectArray, metaDataSelectArray2);
                    if ((objectArray = (MetaDataSelect[])SRBMetaDataCommands.cleanNullsAndDuplicates(objectArray)) == null) {
                        return null;
                    }
                    n3 = -1;
                    n5 = n8 = objectArray.length;
                    nArray3 = new int[n8];
                    nArray4 = new int[n8];
                } else {
                    objectArray[n3] = MetaDataSet.newSelection("resource name");
                    sRBMetaDataRecordListArray2 = this.getRecordsForDefinableQueries(n, metaDataConditionArray2, (MetaDataSelect[])objectArray, n2, sRBMetaDataRecordListArray, bl, bl2);
                    n8 = 11;
                    nArray3 = new int[n8];
                    nArray4 = new int[n8];
                    nArray3[0] = SRBMetaDataSet.getSRBID("resource name");
                    nArray3[1] = SRBMetaDataSet.getSRBID("definable metadata resource0");
                    nArray3[2] = SRBMetaDataSet.getSRBID("definable metadata resource1");
                    nArray3[3] = SRBMetaDataSet.getSRBID("definable metadata resource2");
                    nArray3[4] = SRBMetaDataSet.getSRBID("definable metadata resource3");
                    nArray3[5] = SRBMetaDataSet.getSRBID("definable metadata resource4");
                    nArray3[6] = SRBMetaDataSet.getSRBID("definable metadata resource5");
                    nArray3[7] = SRBMetaDataSet.getSRBID("definable metadata resource6");
                    nArray3[8] = SRBMetaDataSet.getSRBID("definable metadata resource7");
                    nArray3[9] = SRBMetaDataSet.getSRBID("definable metadata resource8");
                    nArray3[10] = SRBMetaDataSet.getSRBID("definable metadata resource9");
                    nArray4[0] = 1;
                    nArray4[1] = 1;
                    nArray4[2] = 1;
                    nArray4[3] = 1;
                    nArray4[4] = 1;
                    nArray4[5] = 1;
                    nArray4[6] = 1;
                    nArray4[7] = 1;
                    nArray4[8] = 1;
                    nArray4[9] = 1;
                    nArray4[10] = 1;
                    n3 = n5;
                }
            } else {
                if (n6 != -5) throw new NullPointerException("Extensible metadata or invalid metadata attribute: " + ((MetaDataSelect)objectArray[n3]).getFieldName() + " not support in this version");
                if (!((double)this.commands.versionNumber >= 3.3)) throw new NullPointerException("Extensible metadata or invalid metadata attribute: " + ((MetaDataSelect)objectArray[n3]).getFieldName() + " not support in this version");
                nArray3[n3] = n6;
                nArray4[n3] = ((MetaDataSelect)objectArray[n3]).getOperation();
                bl3 = true;
            }
            ++n3;
        }
        if (bl3) {
            metaDataSelectArray2 = "";
            string2 = "";
            SRBProtocol sRBProtocol = new SRBProtocol();
            n3 = 0;
            n4 = 0;
            while (n3 < n8) {
                if (nArray3[n3] == -5) {
                    string2 = string2 + ((MetaDataSelect)objectArray[n3]).getFieldName() + ",";
                    metaDataSelectArray2 = (String)metaDataSelectArray2 + ((MetaDataSelect)objectArray[n3]).getField().getExtensibleName(sRBProtocol) + ",";
                    nArray3[n3] = 420 + n4;
                    ++n4;
                }
                ++n3;
            }
            if (n4 > 0) {
                string2 = string2.substring(0, string2.length() - 1);
                metaDataSelectArray2 = metaDataSelectArray2.substring(0, metaDataSelectArray2.length() - 1);
            }
            MetaDataCondition[] metaDataConditionArray3 = new MetaDataCondition[]{MetaDataSet.newCondition("extensible table name", 6, (String)metaDataSelectArray2), MetaDataSet.newCondition("extensible attribute outside name", 6, string2)};
            String[] stringArray = new String[]{"extensible schema name", "extensible table name", "extensible attribute name", "extensible attribute outside name"};
            SRBMetaDataRecordList[] sRBMetaDataRecordListArray4 = this.srbGenQuery(0, string, metaDataConditionArray3, MetaDataSet.newSelection(stringArray), 80, false, false);
        }
        metaDataSelectArray2 = null;
        n5 = 0;
        if (bl2) {
            Host.copyInt(n8 + 1, byArray, n5);
            n5 += 4;
        } else {
            Host.copyInt(n8, byArray, n5);
            n5 += 4;
        }
        if (bl) {
            Host.copyInt(n7 + 1, byArray, n5);
            n5 += 4;
        } else {
            Host.copyInt(n7, byArray, n5);
            n5 += 4;
        }
        n3 = 0;
        while (n3 < n8) {
            Host.copyInt(nArray3[n3], byArray, n5);
            n5 += 4;
            ++n3;
        }
        if (bl2) {
            Host.copyInt(SRBMetaDataSet.getSRBID("nondistinct"), byArray, n5);
            n5 += 4;
        }
        n3 = 0;
        while (n3 < n8) {
            Host.copyInt(nArray4[n3], byArray, n5);
            n5 += 4;
            ++n3;
        }
        if (bl2) {
            Host.copyInt(1, byArray, n5);
            n5 += 4;
        }
        if (n7 > 0) {
            n3 = 0;
            while (n3 < nArray.length) {
                if (nArray[n3] >= 0) {
                    Host.copyInt(nArray[n3], byArray, n5);
                    n5 += 4;
                }
                ++n3;
            }
        }
        if (bl) {
            Host.copyInt(SRBMetaDataSet.getSRBID("order by"), byArray, n5);
            n5 += 4;
        }
        string2 = "";
        if (n7 > 0) {
            n3 = 0;
            while (n3 < metaDataConditionArray2.length) {
                if (metaDataConditionArray2[n3] != null) {
                    int n11 = metaDataConditionArray2[n3].getStyle();
                    string2 = string2 + " " + SRBMetaDataCommands.getOperator(metaDataConditionArray2[n3]) + " " + this.addValueByStyle(n11, metaDataConditionArray2[n3], null);
                    System.arraycopy(string2.getBytes(), 0, byArray, n5, string2.length());
                    n5 = n11 == 14 ? (n5 += string2.length()) : (n5 += string2.length() + 1);
                    string2 = "";
                    n4 = n3 + 1;
                    while (n4 < metaDataConditionArray2.length) {
                        if (metaDataConditionArray2[n4] != null && metaDataConditionArray2[n3].getField().equals(metaDataConditionArray2[n4].getField())) {
                            n11 = metaDataConditionArray2[n4].getStyle();
                            string2 = string2 + " && " + SRBMetaDataCommands.getOperator(metaDataConditionArray2[n4]) + " " + this.addValueByStyle(n11, metaDataConditionArray2[n4], null);
                            System.arraycopy(string2.getBytes(), 0, byArray, --n5, string2.length());
                            metaDataConditionArray2[n4] = null;
                            n5 = n11 == 14 ? (n5 += string2.length()) : (n5 += string2.length() + 1);
                            string2 = "";
                        }
                        ++n4;
                    }
                }
                ++n3;
            }
        }
        if (bl) {
            string2 = SRBMetaDataSet.getSRBName(((MetaDataSelect)objectArray[0]).getFieldName());
            n4 = 1;
            while (n4 < objectArray.length) {
                string2 = string2 + ", " + SRBMetaDataSet.getSRBName(((MetaDataSelect)objectArray[n4]).getFieldName());
                ++n4;
            }
            System.arraycopy(string2.getBytes(), 0, byArray, n5, string2.length());
            n5 += string2.length() + 1;
        }
        metaDataSelectArray2 = (MetaDataSelect[])new byte[n5 + 4];
        System.arraycopy(byArray, 0, metaDataSelectArray2, 4, n5);
        Host.copyInt(n5, (byte[])metaDataSelectArray2, 0);
        if (SRBCommands.DEBUG > 1) {
            System.err.print("\nselects[j].getFieldName() " + n8);
            n4 = 0;
            while (n4 < n8) {
                System.err.print("\n" + nArray3[n4]);
                System.err.print(" " + nArray4[n4]);
                ++n4;
            }
            if (SRBCommands.DEBUG > 4) {
                System.err.print("\ncorrectSizeQuery1.");
                n3 = 0;
                while (n3 < metaDataSelectArray2.length) {
                    if (metaDataSelectArray2[n3] > 32) {
                        System.err.print((char)metaDataSelectArray2[n3] + "_");
                    } else {
                        System.err.print((int)metaDataSelectArray2[n3] + ".");
                    }
                    ++n3;
                }
                System.err.print("\n\n");
            }
        }
        this.commands.startSRBCommand(2155, 4);
        this.commands.sendArg(n);
        this.commands.sendArg(string);
        this.commands.sendArg((byte[])metaDataSelectArray2);
        this.commands.sendArg(n2);
        this.commands.flush();
        try {
            this.commands.commandStatus();
        }
        catch (SRBException sRBException) {
            if (sRBException.getType() != -3005) throw sRBException;
            return null;
        }
        sRBMetaDataRecordListArray = this.commands.returnSRBMetaDataRecordList(true);
        if (sRBMetaDataRecordListArray2 == null) return sRBMetaDataRecordListArray;
        if (sRBMetaDataRecordListArray == null) return this.joinRecordLists(sRBMetaDataRecordListArray2, sRBMetaDataRecordListArray, string3, string4);
        n4 = 0;
        while (n4 < sRBMetaDataRecordListArray.length) {
            if (n10 < sRBMetaDataRecordListArray[n4].getContinuationIndex()) {
                n10 = sRBMetaDataRecordListArray[n4].getContinuationIndex();
                sRBMetaDataRecordListArray = this.joinRecordLists(sRBMetaDataRecordListArray, this.commands.srbGetMoreRows(n, n10, n2), string3, string4);
            }
            ++n4;
        }
        return this.joinRecordLists(sRBMetaDataRecordListArray2, sRBMetaDataRecordListArray, string3, string4);
    }
}

