/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.client;

import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import org.globus.ogsa.utils.AnyHelper;
import org.globus.ogsa.utils.GetOpts;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.utils.QNameUtils;
import org.globus.ogsa.utils.QueryHelper;
import org.gridforum.ogsi.ExtensibilityType;
import org.gridforum.ogsi.GridService;
import org.gridforum.ogsi.HandleType;
import org.gridforum.ogsi.OGSIServiceGridLocator;
import org.gridforum.ogsi.ServiceDataValuesType;

public class DeleteServiceDataByName {
    public static void main(String[] args) {
        block6: {
            GetOpts opts = new GetOpts("Usage: DeleteServiceDataByName [options] <service data name namespace>:<service data name>,... <handle>", 2);
            String error = opts.parse(args);
            if (error != null) {
                System.err.println(error);
                return;
            }
            String names = opts.getArg(0);
            String handle = opts.getArg(1);
            StringTokenizer tokenizer = new StringTokenizer(names, ",");
            QName[] qnames = new QName[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreElements()) {
                String qname = (String)tokenizer.nextElement();
                qnames[i] = QNameUtils.toQName(qname);
                System.out.println("Delete " + qnames[i]);
                ++i;
            }
            try {
                OGSIServiceGridLocator locator = new OGSIServiceGridLocator();
                GridService service = locator.getGridServicePort(new HandleType(handle));
                opts.setOptions((Stub)service);
                ExtensibilityType queryResult = service.setServiceData(QueryHelper.getDeleteNamesQuery(qnames));
                ServiceDataValuesType serviceDataValues = AnyHelper.getAsServiceDataValues(queryResult);
                if (serviceDataValues.get_any() == null) {
                    System.err.println("All service data elements were deleted successfully");
                    break block6;
                }
                System.out.println("Failed to delete ServiceDataValues: " + AnyHelper.getAsString(queryResult));
            }
            catch (Exception e) {
                if (opts.isDebug()) {
                    System.err.println(MessageUtils.toString(e));
                    break block6;
                }
                System.err.println("Error: " + opts.getErrorMessage(e));
            }
        }
    }
}

