/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.client;

import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import org.apache.axis.utils.XMLUtils;
import org.globus.ogsa.utils.AnyHelper;
import org.globus.ogsa.utils.GetOpts;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.utils.QueryHelper;
import org.gridforum.ogsi.ExtensibilityType;
import org.gridforum.ogsi.GridService;
import org.gridforum.ogsi.HandleType;
import org.gridforum.ogsi.OGSIServiceGridLocator;
import org.w3c.dom.Element;

public class FindServiceDataByXPath {
    public static void main(String[] args) {
        block5: {
            GetOpts opts = new GetOpts("Usage: FindServiceDataByXPath [options] <service data name namespace> <service data name> <handle> <XPath expression> <namespace-mapping-1; namespace-mapping-2; etc... >", 5);
            String error = opts.parse(args);
            if (error != null) {
                System.err.println(error);
                return;
            }
            String namespace = opts.getArg(0);
            String name = opts.getArg(1);
            String handle = opts.getArg(2);
            String xpath = opts.getArg(3);
            String namespaceMappings = opts.getArg(4);
            String[] namespaces = QueryHelper.tokenizeNamespaces(namespaceMappings);
            try {
                OGSIServiceGridLocator locator = new OGSIServiceGridLocator();
                GridService service = locator.getGridServicePort(new HandleType(handle));
                opts.setOptions((Stub)service);
                QName qname = new QName(namespace, name);
                ExtensibilityType queryResult = service.findServiceData(QueryHelper.getXPathQuery(qname, xpath, namespaces));
                if (queryResult.get_any() == null) {
                    System.err.println("No results found");
                    return;
                }
                Element result = AnyHelper.getAsSingleElement(queryResult);
                System.out.println(XMLUtils.ElementToString((Element)result));
            }
            catch (Exception e) {
                if (opts.isDebug()) {
                    System.err.println(MessageUtils.toString(e));
                    break block5;
                }
                System.err.println("Error: " + opts.getErrorMessage(e));
            }
        }
    }
}

