/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.client;

import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis.message.MessageElement;
import org.globus.ogsa.wsdl.GSR;
import org.globus.ogsa.wsdl.extensions.PortTypeExtensibilityElement;
import org.gridforum.ogsi.ServiceDataType;
import org.gridforum.ogsi.StaticServiceDataValues;

public class GetGWSDLPortTypes {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: GetGWSDLPortTypes <gsr url>");
            return;
        }
        try {
            GSR gsr = new GSR(args[0]);
            Collection portTypes = gsr.getGWSDLPortTypes();
            Iterator iterator = portTypes.iterator();
            while (iterator.hasNext()) {
                PortTypeExtensibilityElement element = (PortTypeExtensibilityElement)iterator.next();
                QName name = element.getName();
                QName[] extendsTypes = element.getExtendsTypes();
                ServiceDataType[] serviceData = element.getServiceData();
                StaticServiceDataValues serviceDataValues = element.getServiceDataValues();
                System.out.println("-----");
                System.out.println("Port Type Name = " + name);
                System.out.print("  extends = ");
                int i = 0;
                while (i < extendsTypes.length) {
                    System.out.print(extendsTypes[i].toString() + " ");
                    ++i;
                }
                System.out.println();
                int i2 = 0;
                while (serviceData != null && i2 < serviceData.length) {
                    System.out.println("  Service Data Name: " + name.getNamespaceURI() + " " + serviceData[i2].getName());
                    if (serviceData[i2].getType().getNamespaceURI().equals("")) {
                        serviceData[i2].setType(new QName(element.getDefaultNamespace(), serviceData[i2].getType().getLocalPart()));
                    }
                    System.out.println("    type: " + serviceData[i2].getType());
                    System.out.println("    minOccurs: " + serviceData[i2].getMinOccurs());
                    System.out.println("    maxOccurs: " + serviceData[i2].getMaxOccurs());
                    System.out.println("    modifiable: " + serviceData[i2].isModifiable());
                    System.out.println("    nillable: " + serviceData[i2].isNillable());
                    System.out.println();
                    ++i2;
                }
                if (serviceDataValues != null) {
                    System.out.println("  ServiceDataValues");
                    MessageElement[] staticServiceDataValues = serviceDataValues.get_any();
                    int i3 = 0;
                    while (staticServiceDataValues != null && i3 < staticServiceDataValues.length) {
                        System.out.println("    " + staticServiceDataValues[i3].toString());
                        System.out.println();
                        ++i3;
                    }
                }
                System.out.println("-----");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

