/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.client.reflection;

import com.ibm.wsdl.xml.WSDLWriterImpl;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import org.apache.axis.AxisEngine;
import org.apache.axis.Constants;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.client.reflection.ReflectionException;
import org.globus.ogsa.client.reflection.ReflectionSymbolTable;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.wsdl.GSR;
import org.globus.ogsa.wsdl.extensions.PortTypeExtensibilityElement;
import org.w3c.dom.Document;

public class ReflectionUtils {
    protected static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$client$reflection$ReflectionUtils == null ? (class$org$globus$ogsa$client$reflection$ReflectionUtils = ReflectionUtils.class$("org.globus.ogsa.client.reflection.ReflectionUtils")) : class$org$globus$ogsa$client$reflection$ReflectionUtils).getName());
    private static String[] encodingStyles = new String[]{"", Constants.URI_DEFAULT_SOAP_ENC};
    static /* synthetic */ Class class$org$globus$ogsa$client$reflection$ReflectionUtils;

    private static void getPortTypeImplementations(Definition wsdlDefinition, Hashtable portTypes) throws ReflectionException {
        if (wsdlDefinition == null) {
            throw new ReflectionException("null WSDL definition");
        }
        Iterator imports = wsdlDefinition.getImports().values().iterator();
        while (imports.hasNext()) {
            Vector importedObjects = (Vector)imports.next();
            Enumeration importedDefinitions = importedObjects.elements();
            while (importedDefinitions.hasMoreElements()) {
                Import importedDefinition = (Import)importedDefinitions.nextElement();
                ReflectionUtils.getPortTypeImplementations(importedDefinition.getDefinition(), portTypes);
            }
        }
        Map portTypesMap = wsdlDefinition.getPortTypes();
        Iterator iter = portTypesMap.keySet().iterator();
        while (iter.hasNext()) {
            QName name = (QName)iter.next();
            portTypes.put(name, portTypesMap.get(name));
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Adding Port Type Map: " + name + " <==> " + portTypesMap.get(name)));
        }
    }

    public static Document getWSDLDocumentForDefinition(Definition wsdlDefinition) throws ReflectionException {
        Document wsdlDocument = null;
        try {
            wsdlDocument = new WSDLWriterImpl().getDocument(wsdlDefinition);
        }
        catch (WSDLException wsdle) {
            throw new ReflectionException("problem creating org.w3c.dom.Document for javax.wsdl.Definition", wsdle);
        }
        return wsdlDocument;
    }

    public static boolean isGWSDLPortTypeImported(Document wsdlDocument, QName basePortTypeCandidateName) throws GridServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Candidate Name:\n" + basePortTypeCandidateName));
        }
        GSR gsr = new GSR(wsdlDocument);
        Iterator gwsdlPortTypes = gsr.getGWSDLPortTypes().iterator();
        while (gwsdlPortTypes.hasNext()) {
            PortTypeExtensibilityElement gwsdlPortType = (PortTypeExtensibilityElement)gwsdlPortTypes.next();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Port Type Name:\n" + gwsdlPortType.getName()));
            }
            if (!basePortTypeCandidateName.equals(gwsdlPortType.getName())) continue;
            return true;
        }
        return false;
    }

    public static Collection getOperationDescriptions(Definition wsdlDefinition, Document wsdlDocument, QName portTypeName) throws ReflectionException {
        Hashtable portTypesHashtable = new Hashtable();
        ReflectionUtils.getPortTypeImplementations(wsdlDefinition, portTypesHashtable);
        PortType portType = (PortType)portTypesHashtable.get(portTypeName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Requested Port Type:\n" + portTypeName));
            logger.debug((Object)("Port Types Found:\n" + portTypesHashtable));
        }
        List operations = null;
        if (portType == null) {
            boolean portTypeImported = false;
            try {
                portTypeImported = ReflectionUtils.isGWSDLPortTypeImported(wsdlDocument, portTypeName);
            }
            catch (GridServiceException gse) {
                // empty catch block
            }
            if (portTypesHashtable.size() == 1 && portTypeImported) {
                portType = (PortType)portTypesHashtable.elements().nextElement();
                logger.warn((Object)("Operation information unavailable for port type " + portTypeName + ". " + "Using operation information for derived port type " + portTypesHashtable.keys().nextElement() + "."));
            } else {
                throw new ReflectionException("Operation information unavailable because port type " + portTypeName + " " + "could not be found.");
            }
        }
        operations = portType.getOperations();
        Vector<OperationDesc> operationDescriptions = new Vector<OperationDesc>();
        ReflectionSymbolTable symbolTable = new ReflectionSymbolTable();
        try {
            symbolTable.add(wsdlDocument);
        }
        catch (Exception e) {
            throw new ReflectionException("Problem populating symbol table", (Throwable)e);
        }
        Iterator operationIterator = operations.iterator();
        while (operationIterator.hasNext()) {
            Operation operation = (Operation)operationIterator.next();
            OperationDesc operationDesc = new OperationDesc();
            operationDesc.setName(operation.getName());
            symbolTable.populateOperation(operationDesc, portTypeName.getNamespaceURI());
            int index = 0;
            QName operationReturnType = operationDesc.getReturnType();
            if (operationReturnType == null) {
                logger.debug((Object)("void " + operation.getName() + "("));
            } else {
                logger.debug((Object)(ReflectionUtils.getClassForQName(operationReturnType) + " " + operation.getName() + "("));
            }
            ParameterDesc parameterDesc = operationDesc.getParameter(index);
            while (parameterDesc != null) {
                QName parameterTypeQName = parameterDesc.getTypeQName();
                logger.debug((Object)("\t" + ReflectionUtils.getClassForQName(parameterTypeQName) + " " + parameterDesc.getName() + ","));
                parameterDesc = operationDesc.getParameter(++index);
            }
            logger.debug((Object)")");
            operationDescriptions.add(operationDesc);
        }
        return operationDescriptions;
    }

    public static Class getClassForQName(QName typeQName) throws ReflectionException {
        Class mappedClass = null;
        AxisEngine axisEngine = null;
        try {
            axisEngine = ContainerConfig.getConfig().getClientEngine();
        }
        catch (Exception e) {
            throw new ReflectionException("could not obtain Axis engine", (Throwable)e);
        }
        TypeMappingRegistry typeMappingRegistry = axisEngine.getTypeMappingRegistry();
        if (typeMappingRegistry == null) {
            throw new ReflectionException("could not obtain type mapping registry");
        }
        boolean determinedClassMap = false;
        int index = 0;
        while (!determinedClassMap && index < encodingStyles.length) {
            logger.debug((Object)("obtaining type mapping for \"" + encodingStyles[index] + "\" encoding style"));
            TypeMapping typeMapping = (TypeMapping)typeMappingRegistry.getTypeMapping(encodingStyles[index]);
            if (typeMapping == null) {
                throw new ReflectionException("could not obtain type mapping for \"" + encodingStyles[index] + "\" encoding style");
            }
            mappedClass = typeMapping.getClassForQName(typeQName);
            if (mappedClass == null) {
                if (typeQName != null) {
                    mappedClass = ReflectionUtils.getClassForQNameFromNamespace(typeQName);
                }
                if (mappedClass != null) {
                    ReflectionUtils.registerTypeMapping(typeQName, mappedClass, typeMapping);
                }
            }
            if (mappedClass != null) {
                determinedClassMap = true;
                continue;
            }
            ++index;
        }
        if (mappedClass == null) {
            logger.warn((Object)("could not find class that maps to " + typeQName + " in type mapping for \"" + encodingStyles[index - 1] + "\" encoding style"));
        }
        return mappedClass;
    }

    private static Class getClassForQNameFromNamespace(QName typeQName) throws ReflectionException {
        String typeURI = typeQName.getNamespaceURI();
        StringBuffer packageName = new StringBuffer();
        int beginIndex = typeURI.indexOf("//") + 2;
        int endIndex = typeURI.indexOf(47, beginIndex);
        String dotSeperatedPart = "";
        if (beginIndex >= 0 && endIndex >= 0) {
            dotSeperatedPart = typeURI.substring(beginIndex, endIndex);
        }
        beginIndex = endIndex + 1;
        endIndex = typeURI.length();
        String slashSeperatedPart = "";
        if (beginIndex < endIndex) {
            slashSeperatedPart = typeURI.substring(beginIndex);
        }
        beginIndex = 0;
        endIndex = dotSeperatedPart.indexOf(46, beginIndex);
        while (endIndex >= 0) {
            packageName.insert(0, dotSeperatedPart.substring(beginIndex, endIndex));
            packageName.insert(0, '.');
            beginIndex = endIndex + 1;
            endIndex = dotSeperatedPart.indexOf(46, beginIndex);
        }
        packageName.insert(0, dotSeperatedPart.substring(beginIndex));
        beginIndex = 0;
        endIndex = slashSeperatedPart.indexOf(47, beginIndex);
        while (endIndex >= 0) {
            packageName.append('.');
            packageName.append(slashSeperatedPart.substring(beginIndex, endIndex));
            beginIndex = endIndex + 1;
            endIndex = slashSeperatedPart.indexOf(47, beginIndex);
        }
        String lastPart = slashSeperatedPart.substring(beginIndex);
        if (lastPart.length() > 0) {
            packageName.append('.');
            packageName.append(slashSeperatedPart.substring(beginIndex));
        }
        Class<?> classInstance = null;
        String unqName = "." + typeQName.getLocalPart();
        boolean foundClass = false;
        boolean searchFailed = false;
        while (!foundClass && !searchFailed) {
            try {
                classInstance = Class.forName(packageName.toString() + unqName);
                foundClass = true;
            }
            catch (ClassNotFoundException cnfe) {
                int lastDot = packageName.toString().lastIndexOf(".");
                try {
                    packageName.delete(lastDot, packageName.length());
                }
                catch (StringIndexOutOfBoundsException sioobe) {
                    logger.warn((Object)("Couldn't Create Dynamic Type Mapping: " + typeQName));
                    searchFailed = true;
                }
            }
        }
        return classInstance;
    }

    public static ParameterMode getParameterMode(ParameterDesc parameterDesc) {
        byte parameterMode = parameterDesc.getMode();
        switch (parameterMode) {
            case 1: {
                return ParameterMode.IN;
            }
            case 2: {
                return ParameterMode.OUT;
            }
            case 3: {
                return ParameterMode.INOUT;
            }
        }
        return ParameterMode.INOUT;
    }

    public static void registerTypeMapping(QName typeQName, Class className, TypeMapping typeMapping) throws ReflectionException {
        try {
            typeMapping.register(className, typeQName, (SerializerFactory)new BeanSerializerFactory(className, typeQName), (DeserializerFactory)new BeanDeserializerFactory(className, typeQName));
        }
        catch (JAXRPCException jaxrpce) {
            throw new ReflectionException("unable to register type mapping between QName " + typeQName + " " + "and class " + className, jaxrpce);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Dynamically Created Type Mapping: " + typeQName + " <--> " + className));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

