/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.deployment;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.MessageContext;
import org.apache.axis.configuration.FileProvider;
import org.apache.axis.deployment.wsdd.GlobusDescriptorSetter;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.SerializationContextImpl;
import org.apache.axis.encoding.TypeMapping;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.enum.Style;
import org.apache.axis.enum.Use;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.GridServiceBase;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.deployment.DeploymentException;
import org.globus.ogsa.deployment.SaveTask;
import org.globus.ogsa.repository.ServiceNode;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.utils.PerformanceLog;
import org.globus.ogsa.utils.SweeperPool;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class ServiceDeployment {
    private static Hashtable cachedDescriptors = new Hashtable();
    private static WSDDDeployment deployment = null;
    private static ServiceNode root = null;
    private static AxisEngine engine;
    String encodingStyle = "";
    private static final long DELAY = 1000L;
    PerformanceLog performanceLogger = new PerformanceLog((class$org$globus$ogsa$deployment$ServiceDeployment == null ? (class$org$globus$ogsa$deployment$ServiceDeployment = ServiceDeployment.class$("org.globus.ogsa.deployment.ServiceDeployment")) : class$org$globus$ogsa$deployment$ServiceDeployment).getName() + ".performance");
    static Log logger;
    static /* synthetic */ Class class$org$globus$ogsa$deployment$ServiceDeployment;
    static /* synthetic */ Class class$org$globus$ogsa$handlers$RPCURIProvider;

    private static synchronized void init(AxisEngine newEngine) throws DeploymentException {
        if (engine == null) {
            engine = newEngine;
            EngineConfiguration config = engine.getConfig();
            if (!(config instanceof FileProvider)) {
                throw new DeploymentException(MessageUtils.getMessage("configProviderNotSupported"));
            }
            FileProvider wsddProvider = (FileProvider)config;
            deployment = wsddProvider.getDeployment();
            root = ServiceNode.getRootNode();
        }
    }

    public ServiceDeployment() throws DeploymentException {
        MessageContext context = MessageContext.getCurrentContext();
        if (context != null) {
            this.encodingStyle = MessageContext.getCurrentContext().getEncodingStyle();
            ServiceDeployment.init(context.getAxisEngine());
        }
    }

    public ServiceDeployment(AxisEngine engine) throws DeploymentException {
        ServiceDeployment.init(engine);
    }

    public void setEncodingStyle(String encodingStyle) {
        this.encodingStyle = encodingStyle;
    }

    public ServiceDesc deploy(String serviceName, Object obj) throws DeploymentException {
        try {
            ServiceProperties properties = (ServiceProperties)obj;
            properties.setProperty("serviceDeployment", this);
            WSDDService service = deployment.getWSDDService(new QName("", serviceName));
            if (service == null) {
                service = new WSDDService();
            }
            service.setParameter("className", obj.getClass().getName());
            String handlerClass = (String)((ServiceProperties)obj).getProperty("handlerClass");
            if (handlerClass == null) {
                handlerClass = (class$org$globus$ogsa$handlers$RPCURIProvider == null ? (class$org$globus$ogsa$handlers$RPCURIProvider = ServiceDeployment.class$("org.globus.ogsa.handlers.RPCURIProvider")) : class$org$globus$ogsa$handlers$RPCURIProvider).getName();
            }
            service.setParameter("handlerClass", handlerClass);
            service.setParameter("allowedMethods", "*");
            service.setProviderQName(WSDDConstants.QNAME_HANDLER_PROVIDER);
            TypeMappingRegistry registry = engine.getTypeMappingRegistry();
            TypeMapping mapping = (TypeMapping)registry.getTypeMapping(this.encodingStyle);
            MessageContext context = MessageContext.getCurrentContext();
            if (context != null) {
                registry = context.getTypeMappingRegistry();
                mapping = context.getTypeMapping();
            }
            Class serviceInterface = null;
            if (obj instanceof GridServiceBase) {
                GridServiceBase base = (GridServiceBase)obj;
                serviceInterface = base.getServiceInterface();
            } else {
                serviceInterface = obj.getClass();
            }
            ServiceDesc desc = (ServiceDesc)cachedDescriptors.get(serviceInterface);
            if (desc == null) {
                desc = service.getServiceDesc();
                desc.setTypeMappingRegistry(registry);
                this.performanceLogger.start();
                desc.loadServiceDescByIntrospection(serviceInterface, mapping);
                this.performanceLogger.stop("load desc by introspection");
                desc.setStyle(Style.WRAPPED);
                if (this.encodingStyle.equals("")) {
                    desc.setUse(Use.LITERAL);
                }
                cachedDescriptors.put(serviceInterface, desc);
                logger.debug((Object)("caching " + serviceInterface));
            }
            GlobusDescriptorSetter.setServiceDesc(service, desc);
            service.setName(serviceName);
            deployment.deployService(service);
            ((ServiceProperties)obj).setProperty("persistentProperties", service.getParametersTable());
            root.bind(serviceName, obj);
            return desc;
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
    }

    public void setPersistentProperties(ServiceProperties properties, String serviceName) {
        properties.setProperty("serviceDeployment", this);
        WSDDService service = deployment.getWSDDService(new QName("", serviceName));
        properties.setProperty("persistentProperties", service.getParametersTable());
    }

    public void deactivate(String serviceName) throws DeploymentException {
        try {
            deployment.undeployService(new QName("", serviceName));
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
    }

    public void undeploy(String serviceName) throws DeploymentException {
        try {
            deployment.undeployService(new QName("", serviceName));
            root.unbind(serviceName);
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
    }

    public void saveServiceAsync(String serviceName) {
        SweeperPool.getDefaultPool().addTask(new SaveTask(this, serviceName), 1000L);
    }

    public void saveService(String serviceName) {
        try {
            WSDDService service = deployment.getWSDDService(new QName("", serviceName));
            if (service == null) {
                throw new DeploymentException(MessageUtils.getMessage("servicePathNotFound", new String[]{"" + serviceName}));
            }
            StringWriter writer = new StringWriter();
            SerializationContextImpl context = new SerializationContextImpl((Writer)writer);
            service.writeToContext((SerializationContext)context);
            writer.flush();
            Document doc = XMLUtils.newDocument((InputSource)new InputSource(new StringReader(writer.toString())));
            if (doc == null) {
                throw new DeploymentException(MessageUtils.getMessage("deployDocumentCreationError"));
            }
            ContainerConfig.getConfig().saveService(doc.getDocumentElement());
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.toString(e));
        }
    }

    public void removeService(String serviceName) throws DeploymentException {
        try {
            ContainerConfig.getConfig().removeService(serviceName);
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger = LogFactory.getLog((String)(class$org$globus$ogsa$deployment$ServiceDeployment == null ? (class$org$globus$ogsa$deployment$ServiceDeployment = ServiceDeployment.class$("org.globus.ogsa.deployment.ServiceDeployment")) : class$org$globus$ogsa$deployment$ServiceDeployment).getName());
    }
}

