/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.core.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.FactoryCallback;
import org.globus.ogsa.GridServiceBase;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.utils.MessageUtils;
import org.gridforum.ogsi.ExtensibilityType;

public class EJBFactoryCallback
implements FactoryCallback {
    private GridServiceBase base;
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$core$factory$EJBFactoryCallback == null ? (class$org$globus$ogsa$impl$core$factory$EJBFactoryCallback = EJBFactoryCallback.class$("org.globus.ogsa.impl.core.factory.EJBFactoryCallback")) : class$org$globus$ogsa$impl$core$factory$EJBFactoryCallback).getName());
    protected HashMap createMethodMap = new HashMap();
    static /* synthetic */ Class class$org$globus$ogsa$impl$core$factory$EJBFactoryCallback;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$javax$ejb$EJBHome;
    static /* synthetic */ Class class$org$globus$ogsa$impl$core$factory$EJBHomeFactoryProvider;
    static /* synthetic */ Class class$javax$ejb$EJBObject;

    private CreateInfo getCreateInfo(EJBHome home) throws RemoteException, NoSuchMethodException {
        String jndiName = (String)this.base.getProperty("ejbLookupString");
        CreateInfo createInfo = (CreateInfo)this.createMethodMap.get(jndiName);
        if (createInfo == null) {
            createInfo = this.cacheCreateMethod(home, jndiName);
        }
        return createInfo;
    }

    protected EJBObject getRemote(EJBHome home, ExtensibilityType extensibility) {
        try {
            CreateInfo createInfo = this.getCreateInfo(home);
            EJBObject remoteObj = null;
            if (createInfo.beanType == 1) {
                remoteObj = (EJBObject)createInfo.createMethod.invoke((Object)home, null);
            } else if (createInfo.beanType == 2) {
                Hashtable persistentProperties = ContainerConfig.getConfig().getPersistentServicesOptions();
                String serviceID = (String)MessageContext.getCurrentContext().getProperty("org.globus.ogsa.InvocationID");
                if (serviceID == null) {
                    logger.error((Object)MessageUtils.getMessage("createEJBEntityServiceError"));
                    return null;
                }
                String factoryPath = (String)this.base.getProperty("servicePath");
                String servicePath = factoryPath + "/" + serviceID;
                logger.debug((Object)("Looking up Primary key for service: " + servicePath));
                Hashtable options = (Hashtable)persistentProperties.get(factoryPath + "/" + serviceID);
                String pkString = null;
                if (options != null) {
                    pkString = (String)options.get("primaryKey");
                }
                if (pkString == null) {
                    pkString = serviceID;
                }
                logger.debug((Object)("Got Primary Key: " + pkString));
                Class<?> pkClass = createInfo.findMethod.getParameterTypes()[0];
                Object pkObject = this.convertStringToPrimaryKey(pkString, pkClass);
                logger.debug((Object)("Converted to  PKObject: " + pkObject));
                Object[] pkObjectArray = new Object[]{pkObject};
                try {
                    remoteObj = (EJBObject)createInfo.findMethod.invoke((Object)home, pkObjectArray);
                }
                catch (InvocationTargetException objNotFound) {
                    // empty catch block
                }
                if (remoteObj == null && createInfo.createMethod != null) {
                    logger.debug((Object)"ejb with that PrimaryKey doesn't exsist, trying to create one");
                    remoteObj = (EJBObject)createInfo.createMethod.invoke((Object)home, pkObjectArray);
                }
                logger.debug((Object)("remote entity " + pkString + " = " + remoteObj));
            }
            return remoteObj;
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.getMessage("createEJBServiceError"));
            logger.error((Object)MessageUtils.toString(e));
            return null;
        }
    }

    protected CreateInfo cacheCreateMethod(EJBHome home, String jndiName) throws RemoteException, NoSuchMethodException {
        CreateInfo createInfo = new CreateInfo();
        EJBMetaData ejbMetaData = home.getEJBMetaData();
        if (ejbMetaData.isSession() || ejbMetaData.isStatelessSession()) {
            createInfo.beanType = 1;
            createInfo.createMethod = home.getClass().getMethod("create", null);
        } else {
            Class pkClass = null;
            try {
                pkClass = ejbMetaData.getPrimaryKeyClass();
            }
            catch (Exception e) {
                logger.error((Object)MessageUtils.getMessage("createEJBNoSessionServiceError"));
                logger.error((Object)MessageUtils.toString(e));
                return null;
            }
            if (pkClass != null) {
                createInfo.beanType = 2;
                Class[] pkSignature = new Class[]{pkClass};
                createInfo.findMethod = home.getClass().getMethod("findByPrimaryKey", pkSignature);
                try {
                    createInfo.createMethod = home.getClass().getMethod("create", pkSignature);
                }
                catch (NoSuchMethodException nme) {
                    logger.debug((Object)"entity bean doesn't have create(PrimaryKey) method");
                }
            } else {
                logger.error((Object)MessageUtils.getMessage("createEJBNoSessionServiceError"));
                return null;
            }
        }
        logger.debug((Object)("cached " + jndiName + " -> " + createInfo.createMethod));
        this.createMethodMap.put(jndiName, createInfo);
        return createInfo;
    }

    protected Object convertStringToPrimaryKey(String pkString, Class pkClass) {
        if (pkClass.equals(class$java$lang$String == null ? (class$java$lang$String = EJBFactoryCallback.class$("java.lang.String")) : class$java$lang$String)) {
            return pkString;
        }
        if (pkClass.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = EJBFactoryCallback.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new Integer(Integer.parseInt(pkString.trim()));
        }
        if (pkClass.equals(class$java$lang$Long == null ? (class$java$lang$Long = EJBFactoryCallback.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new Long(Long.parseLong(pkString.trim()));
        }
        logger.error((Object)MessageUtils.getMessage("createEJBPrimaryKeyServiceError", new String[]{pkString, pkClass.getName()}));
        return null;
    }

    public void initialize(GridServiceBase base) throws GridServiceException {
        this.base = base;
    }

    public synchronized GridServiceBase createServiceObject(ExtensibilityType extensibility) throws GridServiceException {
        try {
            Hashtable env = new Hashtable();
            this.checkJndiProperty("java.naming.factory.initial", env);
            this.checkJndiProperty("java.naming.provider.url", env);
            this.checkJndiProperty("java.naming.factory.url.pkgs", env);
            InitialContext initial = new InitialContext(env);
            String ejbLookupString = (String)this.base.getProperty("ejbLookupString");
            if (ejbLookupString == null) {
                logger.error((Object)MessageUtils.getMessage("EJBLookupError"));
                return null;
            }
            Object homeObj = initial.lookup(ejbLookupString);
            EJBHome home = (EJBHome)PortableRemoteObject.narrow((Object)homeObj, (Class)(class$javax$ejb$EJBHome == null ? (class$javax$ejb$EJBHome = EJBFactoryCallback.class$("javax.ejb.EJBHome")) : class$javax$ejb$EJBHome));
            logger.debug((Object)("found home interface " + ejbLookupString));
            String skelClassName = (String)this.base.getProperty("skeletonClassName");
            Class<?> skelClass = Class.forName(skelClassName);
            EJBObject remoteObj = null;
            if (!(class$org$globus$ogsa$impl$core$factory$EJBHomeFactoryProvider == null ? (class$org$globus$ogsa$impl$core$factory$EJBHomeFactoryProvider = EJBFactoryCallback.class$("org.globus.ogsa.impl.core.factory.EJBHomeFactoryProvider")) : class$org$globus$ogsa$impl$core$factory$EJBHomeFactoryProvider).isAssignableFrom(skelClass)) {
                remoteObj = this.getRemote(home, extensibility);
                logger.debug((Object)("got remote " + remoteObj));
            }
            Constructor<?> constr = skelClass.getConstructor(class$javax$ejb$EJBHome == null ? (class$javax$ejb$EJBHome = EJBFactoryCallback.class$("javax.ejb.EJBHome")) : class$javax$ejb$EJBHome, class$javax$ejb$EJBObject == null ? (class$javax$ejb$EJBObject = EJBFactoryCallback.class$("javax.ejb.EJBObject")) : class$javax$ejb$EJBObject);
            Object[] args = new Object[]{home, remoteObj};
            GridServiceBase ejbSkel = (GridServiceBase)constr.newInstance(args);
            if (remoteObj != null && this.getCreateInfo((EJBHome)home).beanType == 2) {
                Object returnedPK = remoteObj.getPrimaryKey();
                ejbSkel.setProperty("primaryKey", returnedPK.toString());
            }
            return ejbSkel;
        }
        catch (Exception e) {
            throw new GridServiceException(MessageUtils.getMessage("createEJBServiceError"), e);
        }
    }

    private void checkJndiProperty(String name, Hashtable env) {
        String val = (String)this.base.getProperty(name);
        if (val != null) {
            env.put(name, val);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class CreateInfo {
        int beanType;
        Method createMethod;
        Method findMethod;

        protected CreateInfo() {
        }
    }
}

