/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.core.factory;

import java.util.Calendar;
import java.util.Enumeration;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.impl.core.handle.HandleHelper;
import org.globus.ogsa.repository.ServiceNode;
import org.globus.ogsa.utils.MessageUtils;
import org.gridforum.ogsi.GridService;

public class ServiceSweeperTask
extends TimerTask {
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$core$factory$ServiceSweeperTask == null ? (class$org$globus$ogsa$impl$core$factory$ServiceSweeperTask = ServiceSweeperTask.class$("org.globus.ogsa.impl.core.factory.ServiceSweeperTask")) : class$org$globus$ogsa$impl$core$factory$ServiceSweeperTask).getName());
    static ServiceNode root = ServiceNode.getRootNode();
    private ServiceNode node;
    static /* synthetic */ Class class$org$globus$ogsa$impl$core$factory$ServiceSweeperTask;

    public ServiceSweeperTask(ServiceNode node) {
        this.node = node;
    }

    public void run() {
        Calendar now = Calendar.getInstance();
        Vector services = this.node.getAllServices();
        Enumeration enumeration = services.elements();
        while (enumeration.hasMoreElements()) {
            ServiceProperties properties = (ServiceProperties)enumeration.nextElement();
            Calendar timeout = (Calendar)properties.getProperty("timeout");
            try {
                if (timeout != null && timeout.before(now)) {
                    if (properties instanceof GridService) {
                        ((GridService)((Object)properties)).destroy();
                    } else {
                        GridService service = (GridService)root.activate((String)properties.getProperty("servicePath"));
                        service.destroy();
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)MessageUtils.getMessage("destroyServiceError", new String[]{(String)properties.getProperty("Handle")}));
                logger.error((Object)MessageUtils.toString(e));
            }
            Object deactivationProperty = properties.getProperty("deactivation");
            if (deactivationProperty == null) continue;
            Long deactivation = null;
            Long timestamp = (Long)properties.getProperty("timestamp");
            long currentTime = System.currentTimeMillis();
            try {
                if (deactivationProperty instanceof Long) {
                    deactivation = (Long)deactivationProperty;
                } else {
                    deactivation = Long.valueOf((String)deactivationProperty);
                    properties.setProperty("deactivation", deactivation);
                }
                if (timestamp == null || currentTime - timestamp <= deactivation) continue;
                String path = (String)properties.getProperty("servicePath");
                logger.debug((Object)("deactivating " + path));
                this.node.deactivate(HandleHelper.getInstanceID(path));
            }
            catch (Exception e) {
                logger.error((Object)MessageUtils.getMessage("deactivateServiceError", new String[]{(String)properties.getProperty("Handle")}));
                logger.error((Object)MessageUtils.toString(e));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

