/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.core.management;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceBase;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.ServiceData;
import org.globus.ogsa.ServiceGroupEntryGenerator;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.core.management.InvalidStateFaultType;
import org.globus.ogsa.core.management.NumberServicesElementType;
import org.globus.ogsa.core.management.UnknownHandleFaultType;
import org.globus.ogsa.impl.ogsi.PersistentGridServiceImpl;
import org.globus.ogsa.repository.ServiceListener;
import org.globus.ogsa.repository.ServiceNode;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.utils.QNameUtils;
import org.gridforum.ogsi.GridService;
import org.gridforum.ogsi.HandleType;
import org.gridforum.ogsi.InvalidHandleFaultType;
import org.gridforum.ogsi.ServiceNotDestroyedFaultType;

public class OgsiManagement
extends PersistentGridServiceImpl
implements ServiceListener {
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$core$management$OgsiManagement == null ? (class$org$globus$ogsa$impl$core$management$OgsiManagement = OgsiManagement.class$("org.globus.ogsa.impl.core.management.OgsiManagement")) : class$org$globus$ogsa$impl$core$management$OgsiManagement).getName());
    public static final String MANAGEMENT_SERVICE_PORT_TYPE_NS = "http://ogsa.globus.org/core/management";
    public static final QName NUMBER_SERVICES = new QName("http://ogsa.globus.org/core/management", "numberServices");
    private ServiceData numberServicesSD = null;
    private NumberServicesElementType numberServices = new NumberServicesElementType();
    private int numberOfDeployedServices = 0;
    private int numberOfAvailableServices = 0;
    private int numberOfActiveServices = 0;
    private int numberOfDeactiveServices = 0;
    private static ServiceNode rootServiceNode = ServiceNode.getRootNode();
    static /* synthetic */ Class class$org$globus$ogsa$impl$core$management$OgsiManagement;

    public OgsiManagement() {
        super("Management Service");
    }

    public void servicesChanged(Collection services) {
        try {
            this.updateServiceDataValues();
            ServiceGroupEntryGenerator.updateServiceData(services, (GridServiceBase)this);
            this.numberServicesSD.notifyChange();
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.toString(e));
        }
    }

    public void postCreate(GridContext context) throws GridServiceException {
        this.numberServicesSD = this.serviceData.create(NUMBER_SERVICES);
        this.updateServiceDataValues();
        this.numberServices.setNumberDeployedServices(this.numberOfAvailableServices);
        this.numberServicesSD.setValue(this.numberServices);
        this.serviceData.add(this.numberServicesSD);
        this.numberServicesSD.setCallback(this);
        super.postCreate(context);
    }

    public void postPersistentCreate(GridContext context) throws GridServiceException {
        this.servicesChanged(ServiceNode.getRootNode().getAllServices());
        ServiceNode.addListener(this);
    }

    public void activate(GridContext context) throws GridServiceException {
        super.activate(context);
    }

    public void deactivate(GridContext context) throws GridServiceException {
        super.deactivate(context);
    }

    public void preDestroy(GridContext context) throws GridServiceException {
        super.preDestroy(context);
    }

    public Collection getServiceDataValues(QName qname) {
        ArrayList<NumberServicesElementType> serviceDataList = null;
        logger.debug((Object)("Getting service data values for " + qname.toString()));
        try {
            if (QNameUtils.equalsLocally(qname, NUMBER_SERVICES)) {
                this.updateServiceDataValues();
                serviceDataList = new ArrayList<NumberServicesElementType>();
                serviceDataList.add(this.numberServices);
                return serviceDataList;
            }
        }
        catch (Exception e) {
            logger.error((Object)MessageUtils.toString(e));
        }
        return super.getServiceDataValues(qname);
    }

    private void updateServiceDataValues() {
        this.numberOfAvailableServices = 0;
        this.numberOfActiveServices = 0;
        this.numberOfDeactiveServices = 0;
        Vector services = rootServiceNode.getAllServices();
        if (services == null) {
            return;
        }
        Enumeration e = services.elements();
        while (e.hasMoreElements()) {
            ++this.numberOfAvailableServices;
            ServiceProperties properties = (ServiceProperties)e.nextElement();
            if (properties.getProperty("deactivatedPersistent") == null && properties.getProperty("deactivatedTransient") == null) {
                ++this.numberOfActiveServices;
                continue;
            }
            ++this.numberOfDeactiveServices;
        }
        this.numberServices.setNumberAvailableServices(this.numberOfAvailableServices);
        this.numberServices.setNumberActiveServices(this.numberOfActiveServices);
        this.numberServices.setNumberDeactiveServices(this.numberOfDeactiveServices);
        this.numberServicesSD.setValue(this.numberServices);
    }

    public void endService(HandleType aHandle) throws RemoteException, UnknownHandleFaultType, InvalidHandleFaultType, ServiceNotDestroyedFaultType {
        logger.debug((Object)("endService, handle: " + aHandle));
        Vector services = rootServiceNode.getAllServices();
        if (aHandle == null) {
            throw new InvalidHandleFaultType();
        }
        String handle = aHandle.toString();
        if (services == null) {
            return;
        }
        Enumeration e = services.elements();
        while (e.hasMoreElements()) {
            ServiceProperties properties = (ServiceProperties)e.nextElement();
            try {
                if (properties instanceof GridService) {
                    logger.debug((Object)("GridService SERVICE_PATH: " + (String)properties.getProperty("servicePath")));
                }
                logger.debug((Object)("handle: " + (String)properties.getProperty("Handle")));
                if (!handle.equals((String)properties.getProperty("Handle"))) continue;
                if (properties instanceof GridService) {
                    logger.debug((Object)("destroy(): " + (String)properties.getProperty("servicePath")));
                    ((GridService)((Object)properties)).destroy();
                    break;
                }
                logger.debug((Object)("activate, then destroy(): " + (String)properties.getProperty("servicePath")));
                GridService service = (GridService)rootServiceNode.activate((String)properties.getProperty("servicePath"));
                service.destroy();
                break;
            }
            catch (Exception ex) {
                logger.error((Object)MessageUtils.getMessage("destroyServiceError", new String[]{(String)properties.getProperty("Handle"), MessageUtils.toString(ex)}));
                if (ex instanceof ServiceNotDestroyedFaultType) {
                    logger.debug((Object)"Throw ServiceNotDestroyedFaultType: ");
                    throw (ServiceNotDestroyedFaultType)((Object)ex);
                }
                throw (RemoteException)ex;
            }
        }
    }

    public void endServiceForce(HandleType aHandle) throws RemoteException, UnknownHandleFaultType, InvalidHandleFaultType {
        logger.debug((Object)("endServiceForce, handle: " + aHandle));
        Vector services = rootServiceNode.getAllServices();
        if (aHandle == null) {
            throw new InvalidHandleFaultType();
        }
        String handle = aHandle.toString();
        if (services == null) {
            return;
        }
        Enumeration e = services.elements();
        while (e.hasMoreElements()) {
            ServiceProperties properties = (ServiceProperties)e.nextElement();
            try {
                if (properties instanceof GridService) {
                    logger.debug((Object)("GridService SERVICE_PATH: " + (String)properties.getProperty("servicePath")));
                }
                logger.debug((Object)("handle: " + (String)properties.getProperty("Handle")));
                if (!handle.equals((String)properties.getProperty("Handle"))) continue;
                logger.debug((Object)("unbind: " + (String)properties.getProperty("servicePath")));
                ServiceNode service = rootServiceNode.unbind((String)properties.getProperty("servicePath"));
                break;
            }
            catch (Exception ex) {
                logger.error((Object)MessageUtils.getMessage("destroyServiceError", new String[]{(String)properties.getProperty("Handle"), MessageUtils.toString(ex)}));
                if (ex instanceof ServiceNotDestroyedFaultType) {
                    logger.debug((Object)"Throw ServiceNotDestroyedFaultType: ");
                    throw (ServiceNotDestroyedFaultType)((Object)ex);
                }
                throw (RemoteException)ex;
            }
        }
    }

    public void activateService(HandleType aHandle) throws RemoteException, UnknownHandleFaultType, InvalidHandleFaultType, InvalidStateFaultType {
        logger.debug((Object)("activateService, handle: " + aHandle));
        Vector services = rootServiceNode.getAllServices();
        if (aHandle == null) {
            throw new InvalidHandleFaultType();
        }
        String handle = aHandle.toString();
        if (services != null) {
            Enumeration e = services.elements();
            while (e.hasMoreElements()) {
                ServiceProperties properties = (ServiceProperties)e.nextElement();
                try {
                    if (!handle.equals((String)properties.getProperty("Handle"))) continue;
                    logger.debug((Object)("activate: " + (String)properties.getProperty("servicePath")));
                    Object service = rootServiceNode.activate((String)properties.getProperty("servicePath"));
                    break;
                }
                catch (Exception ex) {
                    logger.error((Object)MessageUtils.getMessage("activateServiceError", new String[]{(String)properties.getProperty("Handle"), MessageUtils.toString(ex)}));
                    throw (RemoteException)ex;
                }
            }
        }
    }

    public void deactivateService(HandleType aHandle) throws RemoteException, UnknownHandleFaultType, InvalidHandleFaultType, InvalidStateFaultType {
        logger.debug((Object)("deactivateService, handle: " + aHandle));
        Vector services = rootServiceNode.getAllServices();
        if (aHandle == null) {
            throw new InvalidHandleFaultType();
        }
        String handle = aHandle.toString();
        if (services == null) {
            return;
        }
        Enumeration e = services.elements();
        while (e.hasMoreElements()) {
            ServiceProperties properties = (ServiceProperties)e.nextElement();
            try {
                if (properties instanceof GridService) {
                    logger.debug((Object)("GridService SERVICE_PATH: " + (String)properties.getProperty("servicePath")));
                }
                logger.debug((Object)("handle: " + (String)properties.getProperty("Handle")));
                if (!handle.equals((String)properties.getProperty("Handle"))) continue;
                if (properties instanceof GridService) {
                    logger.debug((Object)("deactivate: " + (String)properties.getProperty("servicePath")));
                    rootServiceNode.deactivate((String)properties.getProperty("servicePath"));
                    break;
                }
                logger.debug((Object)("already deactivated: " + (String)properties.getProperty("servicePath")));
                break;
            }
            catch (Exception ex) {
                logger.error((Object)MessageUtils.getMessage("destroyServiceError", new String[]{(String)properties.getProperty("Handle"), MessageUtils.toString(ex)}));
                if (ex instanceof ServiceNotDestroyedFaultType) {
                    logger.debug((Object)"Throw ServiceNotDestroyedFaultType: ");
                    throw (ServiceNotDestroyedFaultType)((Object)ex);
                }
                throw (RemoteException)ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

