/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.core.service;

import java.util.Hashtable;
import java.util.Set;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.ServicePropertiesException;
import org.globus.ogsa.deployment.ServiceDeployment;

public class ServicePropertiesImpl
implements ServiceProperties {
    private Hashtable properties = new Hashtable();

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, Object obj) {
        if (obj == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, obj);
        }
    }

    protected Set keySet() {
        return this.properties.keySet();
    }

    public synchronized Object getPersistentProperty(String name) {
        Hashtable persistentProperties = (Hashtable)this.properties.get("persistentProperties");
        if (persistentProperties == null) {
            return null;
        }
        return persistentProperties.get(name);
    }

    public synchronized void setPersistentProperty(String name, Object obj) {
        Hashtable persistentProperties = (Hashtable)this.properties.get("persistentProperties");
        if (persistentProperties == null) {
            return;
        }
        if (obj == null) {
            persistentProperties.remove(name);
        } else {
            persistentProperties.put(name, obj);
        }
    }

    public synchronized void flush() throws ServicePropertiesException {
        try {
            String lifecycle = (String)this.getProperty("lifecycle");
            if (lifecycle == null || !lifecycle.equalsIgnoreCase("persistent")) {
                return;
            }
            ServiceDeployment deployment = (ServiceDeployment)this.getProperty("serviceDeployment");
            if (deployment != null) {
                String serviceName = (String)this.getProperty("servicePath");
                deployment.saveServiceAsync(serviceName);
            }
        }
        catch (Exception e) {
            throw new ServicePropertiesException(e.toString());
        }
    }
}

