/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.ogsi;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.ServiceData;
import org.globus.ogsa.ServiceDataAttributes;
import org.globus.ogsa.impl.ogsi.GridServiceImpl;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.utils.QNameUtils;
import org.gridforum.ogsi.EntryContentType;
import org.gridforum.ogsi.EntryType;
import org.gridforum.ogsi.ExtendedDateTimeType;
import org.gridforum.ogsi.LocatorType;
import org.gridforum.ogsi.TerminationTimeType;

public class ServiceGroupEntryImpl
extends GridServiceImpl {
    ServiceDataAttributes entry;

    public ServiceGroupEntryImpl() {
        super("Service Group Entry Service");
    }

    public void postCreate(GridContext context) throws GridServiceException {
        super.postCreate(context);
        this.entry = (ServiceDataAttributes)context.getMessageContext().getProperty("serviceGroupEntry");
        if (this.entry == null) {
            throw new GridServiceException(MessageUtils.getMessage("serviceGroupEntryNotFound"));
        }
        this.addServiceData();
    }

    public void preDestroy(GridContext context) throws GridServiceException {
        super.preDestroy(context);
        try {
            ExtendedDateTimeType timeout = new ExtendedDateTimeType();
            timeout.setValue(Calendar.getInstance());
            this.entry.setAvailableUntil(timeout);
        }
        catch (Exception e) {
            throw new GridServiceException(e);
        }
    }

    protected TerminationTimeType setDefaultTermination(ExtendedDateTimeType dateTime) {
        if (this.entry != null) {
            this.entry.setAvailableUntil(dateTime);
        }
        return super.setDefaultTermination(dateTime);
    }

    private void addServiceData() throws GridServiceException {
        ServiceData memberLocator = this.serviceData.create(ServiceData.MEMBER_LOCATOR);
        memberLocator.setCallback(this);
        this.serviceData.add(memberLocator);
        ServiceData content = this.serviceData.create(ServiceData.CONTENT);
        content.setCallback(this);
        this.serviceData.add(content);
    }

    public Collection getServiceDataValues(QName qname) {
        if (QNameUtils.equalsLocally(qname, ServiceData.MEMBER_LOCATOR)) {
            ArrayList<LocatorType> list = new ArrayList<LocatorType>(1);
            list.add(((EntryType)this.entry.getValue()).getMemberServiceLocator());
            return list;
        }
        if (QNameUtils.equalsLocally(qname, ServiceData.CONTENT)) {
            ArrayList<EntryContentType> list = new ArrayList<EntryContentType>(1);
            list.add(((EntryType)this.entry.getValue()).getContent());
            return list;
        }
        return super.getServiceDataValues(qname);
    }
}

