/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authentication;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.impl.security.authentication.ExpiredContextSweeperTask;
import org.globus.ogsa.impl.security.authentication.SecContext;
import org.globus.ogsa.utils.SweeperPool;
import org.ietf.jgss.GSSException;

public class ContextManager {
    private static Log log = LogFactory.getLog((String)(class$org$globus$ogsa$impl$security$authentication$ContextManager == null ? (class$org$globus$ogsa$impl$security$authentication$ContextManager = ContextManager.class$("org.globus.ogsa.impl.security.authentication.ContextManager")) : class$org$globus$ogsa$impl$security$authentication$ContextManager).getName());
    private static ExpiredContextSweeperTask contextSweeperTask;
    protected Hashtable serviceContexts = new Hashtable();
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$authentication$ContextManager;

    public ContextManager() {
        ContextManager.initContextSweeper();
    }

    private static synchronized void initContextSweeper() {
        if (contextSweeperTask == null) {
            contextSweeperTask = new ExpiredContextSweeperTask();
            int interval = ExpiredContextSweeperTask.getInterval();
            SweeperPool.getDefaultPool().addTask(contextSweeperTask, interval, interval);
        }
    }

    public void put(SecContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("ctx is null");
        }
        this.serviceContexts.put(ctx.getContextId(), ctx);
    }

    public SecContext get(String contextId) {
        if (contextId == null) {
            throw new IllegalArgumentException("contextId is null");
        }
        return (SecContext)this.serviceContexts.get(contextId);
    }

    public synchronized void destroy() {
        log.debug((Object)("disposing of " + this.serviceContexts.size() + " contexts"));
        Enumeration enumeration = this.serviceContexts.elements();
        while (enumeration.hasMoreElements()) {
            SecContext context = (SecContext)enumeration.nextElement();
            try {
                context.getContext().dispose();
            }
            catch (GSSException e) {
                log.error((Object)"Error disposing of context", (Throwable)e);
            }
        }
        this.serviceContexts.clear();
    }

    public synchronized void removeExpiredContexts() {
        log.debug((Object)"scanning for expired contexts");
        Set entries = this.serviceContexts.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SecContext context = (SecContext)entry.getValue();
            if (!context.getContext().isEstablished() || context.getContext().getLifetime() > 0) continue;
            log.debug((Object)"removing expired context");
            iterator.remove();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

