/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authentication;

import java.util.Enumeration;
import java.util.TimerTask;
import java.util.Vector;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.impl.security.authentication.ContextManager;
import org.globus.ogsa.impl.security.authentication.SecureServicePropertiesHelper;
import org.globus.ogsa.repository.ServiceNode;

class ExpiredContextSweeperTask
extends TimerTask {
    private static final int DEFAULT_INTERVAL = 180000;

    ExpiredContextSweeperTask() {
    }

    static int getInterval() {
        try {
            String sweeperInterval = ContainerConfig.getConfig().getOption("contextSweeperInterval");
            if (sweeperInterval != null) {
                return Integer.parseInt(sweeperInterval);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return 180000;
    }

    public void run() {
        Vector services = ServiceNode.getRootNode().getAllServices();
        Enumeration enumeration = services.elements();
        while (enumeration.hasMoreElements()) {
            ServiceProperties properties = (ServiceProperties)enumeration.nextElement();
            ContextManager manager = SecureServicePropertiesHelper.getContextManager(properties);
            if (manager == null) continue;
            manager.removeExpiredContexts();
        }
    }
}

