/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authentication;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.encryption.EncryptionMethod;
import org.apache.xml.security.algorithms.encryption.params.EncryptionMethodParams;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.encryption.CipherData;
import org.apache.xml.security.encryption.CipherValue;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptionProperties;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.KeyName;
import org.apache.xml.security.utils.HelperNodeList;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class GSSEncryptedData
extends EncryptedData {
    private static Log log = LogFactory.getLog((String)(class$org$globus$ogsa$impl$security$authentication$GSSEncryptedData == null ? (class$org$globus$ogsa$impl$security$authentication$GSSEncryptedData = GSSEncryptedData.class$("org.globus.ogsa.impl.security.authentication.GSSEncryptedData")) : class$org$globus$ogsa$impl$security$authentication$GSSEncryptedData).getName());
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$authentication$GSSEncryptedData;
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$authentication$EncryptionGSS;

    public GSSEncryptedData(Document doc, EncryptionMethod encryptionMethod, KeyInfo keyInfo, CipherData cipherData, EncryptionProperties encryptionProperties, String Id, String Type2) throws XMLSecurityException {
        super(doc, encryptionMethod, keyInfo, cipherData, encryptionProperties, Id, Type2);
    }

    public GSSEncryptedData(Document doc, String encryptionMethod, EncryptionMethodParams encryptionMethodParams, KeyInfo keyInfo, EncryptionProperties encryptionProperties, String Id) throws XMLSecurityException {
        this(doc, new EncryptionMethod(doc, encryptionMethod, encryptionMethodParams), keyInfo, null, encryptionProperties, Id, null);
    }

    public GSSEncryptedData(Document doc, String encryptionMethod, EncryptionMethodParams encryptionMethodParams, KeyInfo keyInfo, CipherData cipherData, EncryptionProperties encryptionProperties, String Id, String Type2) throws XMLSecurityException {
        this(doc, new EncryptionMethod(doc, encryptionMethod, encryptionMethodParams), keyInfo, cipherData, encryptionProperties, Id, Type2);
    }

    public GSSEncryptedData(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
    }

    public void encryptElementAndReplace(Element plaintextElement, GSSContext context) throws XMLSecurityException {
        try {
            Canonicalizer c14n = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
            byte[] plaintext = c14n.canonicalizeSubtree((Node)plaintextElement);
            byte[] ciphertext = context.wrap(plaintext, 0, plaintext.length, null);
            this.getCipherData().setCipherValue(new CipherValue(this._doc, ciphertext));
            this.setType("http://www.w3.org/2001/04/xmlenc#Element");
            EncryptedData.replace((Element)plaintextElement, (Element)this._constructionElement);
        }
        catch (CanonicalizationException ex) {
            throw new XMLSecurityException("empty", (Exception)((Object)ex));
        }
        catch (InvalidCanonicalizerException ex) {
            throw new XMLSecurityException("empty", (Exception)((Object)ex));
        }
        catch (GSSException ex) {
            throw new XMLSecurityException("empty", (Exception)ex);
        }
        catch (XMLSecurityException ex) {
            throw ex;
        }
    }

    public void encryptContentAndReplace(Node firstPlaintextNode, int length, GSSContext context) throws XMLSecurityException {
        try {
            byte[] plaintext = null;
            Node parent = firstPlaintextNode.getParentNode();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Node currentNode = firstPlaintextNode;
            int i = 0;
            while (i < length) {
                if (currentNode == null) {
                    throw new IndexOutOfBoundsException("The index " + length + " is out of bounds: maximum is " + (i - 1));
                }
                if (currentNode.getNodeType() == 8) {
                    baos.write(("<!--" + ((Comment)currentNode).getData() + "-->").getBytes());
                } else if (currentNode.getNodeType() == 7) {
                    baos.write(("<?" + ((ProcessingInstruction)currentNode).getTarget() + " " + ((ProcessingInstruction)currentNode).getData() + "?>").getBytes());
                } else if (currentNode.getNodeType() == 3) {
                    baos.write(((Text)currentNode).getData().getBytes());
                } else {
                    Canonicalizer c14n = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
                    baos.write(c14n.canonicalizeSubtree(currentNode));
                }
                currentNode = currentNode.getNextSibling();
                ++i;
            }
            Node insertBeforeNode = currentNode;
            plaintext = baos.toByteArray();
            byte[] ciphertext = context.wrap(plaintext, 0, plaintext.length, null);
            this.getCipherData().setCipherValue(new CipherValue(this._doc, ciphertext));
            this.setType("http://www.w3.org/2001/04/xmlenc#Content");
            int start = 0;
            currentNode = parent.getFirstChild();
            while (currentNode != firstPlaintextNode) {
                ++start;
                currentNode = currentNode.getNextSibling();
            }
            i = 0;
            while (i < length) {
                parent.removeChild(parent.getChildNodes().item(start));
                ++i;
            }
            parent.insertBefore(this._constructionElement, insertBeforeNode);
        }
        catch (IOException ex) {
            throw new XMLSecurityException("empty", (Exception)ex);
        }
        catch (CanonicalizationException ex) {
            throw new XMLSecurityException("empty", (Exception)((Object)ex));
        }
        catch (InvalidCanonicalizerException ex) {
            throw new XMLSecurityException("empty", (Exception)((Object)ex));
        }
        catch (GSSException ex) {
            throw new XMLSecurityException("empty", (Exception)ex);
        }
        catch (XMLSecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }

    public void decryptAndReplace(GSSContext context) throws XMLSecurityException {
        try {
            byte[] ciphertext = this.getCipherData().getCipherValue().getCipherText();
            byte[] plaintext = context.unwrap(ciphertext, 0, ciphertext.length, null);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            String container = "container";
            baos.write(new String("<" + container + ">").getBytes());
            baos.write(plaintext);
            baos.write(new String("</" + container + ">").getBytes());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc2 = db.parse(new ByteArrayInputStream(baos.toByteArray()));
            Element doc2Elem = doc2.getDocumentElement();
            HelperNodeList newContent = new HelperNodeList();
            int i = 0;
            while (i < doc2Elem.getChildNodes().getLength()) {
                newContent.appendChild(doc2Elem.getChildNodes().item(i));
                ++i;
            }
            EncryptedData.replace((Element)this._constructionElement, (NodeList)newContent);
        }
        catch (ParserConfigurationException ex) {
            throw new XMLSecurityException("empty", (Exception)ex);
        }
        catch (IOException ex) {
            throw new XMLSecurityException("empty", (Exception)ex);
        }
        catch (SAXException ex) {
            throw new XMLSecurityException("empty", (Exception)ex);
        }
        catch (GSSException ex) {
            throw new XMLSecurityException("empty", (Exception)ex);
        }
    }

    public String getKeyInfoContextId() throws XMLSecurityException {
        KeyInfo info = this.getKeyInfo();
        if (info.lengthKeyName() > 0) {
            try {
                KeyName nm = info.itemKeyName(0);
                return nm.getKeyName();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            EncryptionMethod.register((String)"http://www.globus.org/2002/04/xmlenc#gssapi-enc", (String)(class$org$globus$ogsa$impl$security$authentication$EncryptionGSS == null ? (class$org$globus$ogsa$impl$security$authentication$EncryptionGSS = GSSEncryptedData.class$("org.globus.ogsa.impl.security.authentication.EncryptionGSS")) : class$org$globus$ogsa$impl$security$authentication$EncryptionGSS).getName());
        }
        catch (Throwable e) {
            log.error((Object)"Failed to register EncryptionMethod", e);
            throw new RuntimeException("Failed to register EncryptionMethod: " + e.getMessage());
        }
    }
}

