/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authentication;

import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.encryption.DataReference;
import org.apache.xml.security.encryption.ReferenceList;
import org.apache.xml.security.keys.KeyInfo;
import org.globus.ogsa.impl.security.authentication.GSSEncryptedData;
import org.globus.ogsa.impl.security.authentication.WSSecuritySOAPEnvelopeBuilder;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityUtil;
import org.ietf.jgss.GSSContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GssEncryptedSOAPEnvelopeBuilder
extends WSSecuritySOAPEnvelopeBuilder {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$security$authentication$GssEncryptedSOAPEnvelopeBuilder == null ? (class$org$globus$ogsa$impl$security$authentication$GssEncryptedSOAPEnvelopeBuilder = GssEncryptedSOAPEnvelopeBuilder.class$("org.globus.ogsa.impl.security.authentication.GssEncryptedSOAPEnvelopeBuilder")) : class$org$globus$ogsa$impl$security$authentication$GssEncryptedSOAPEnvelopeBuilder).getName());
    private static final String ID = "EncryptedBody";
    protected GSSContext context;
    protected String contextId;
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$authentication$GssEncryptedSOAPEnvelopeBuilder;

    public GssEncryptedSOAPEnvelopeBuilder(MessageContext msgContext, GSSContext context) {
        this(msgContext, context, null);
    }

    public GssEncryptedSOAPEnvelopeBuilder(MessageContext msgContext, GSSContext context, String contextId) {
        super(msgContext);
        this.context = context;
        this.contextId = contextId;
    }

    private String getContextId() {
        if (this.contextId == null) {
            return String.valueOf(this.context.hashCode());
        }
        return this.contextId;
    }

    public SOAPMessage buildMessage(SOAPEnvelope env) throws Exception {
        logger.debug((Object)"Beginning encryption...");
        this.addSecurityHeader(env);
        Document doc = this.getAsDocument(env);
        KeyInfo keyInfo = new KeyInfo(doc);
        keyInfo.addKeyName(this.getContextId());
        GSSEncryptedData encryptedData = new GSSEncryptedData(doc, "http://www.globus.org/2002/04/xmlenc#gssapi-enc", null, keyInfo, null, ID);
        Element body = WSSecurityUtil.findFirstBodyElement(doc);
        if (body == null) {
            throw new Exception("Element node not found");
        }
        encryptedData.encryptElementAndReplace(body, this.context);
        ReferenceList referenceList = new ReferenceList(doc);
        referenceList.add(new DataReference(doc, ID));
        this.insertIntoSecurityHeader(doc, referenceList.getElement());
        logger.debug((Object)"Encryption complete.");
        return this.toSOAPMessage(doc);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

