/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authentication;

import java.net.URL;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.gsi.jaas.JaasSubject;
import org.globus.gsi.proxy.ProxyPolicyHandler;
import org.globus.ogsa.impl.security.Constants;
import org.globus.ogsa.impl.security.authentication.Authenticator;
import org.globus.ogsa.impl.security.authentication.SecContext;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityFault;
import org.globus.ogsa.impl.security.authorization.Authorization;
import org.globus.ogsa.impl.security.authorization.HostAuthorization;
import org.globus.ogsa.impl.security.util.AuthUtil;
import org.globus.ogsa.security.authentication.SecureContextEstablishmentPortType;
import org.globus.ogsa.security.authentication.SecureContextEstablishmentServiceLocator;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;

public class SecContextHandler
extends GenericHandler {
    protected static Log log = LogFactory.getLog((String)(class$org$globus$ogsa$impl$security$authentication$SecContextHandler == null ? (class$org$globus$ogsa$impl$security$authentication$SecContextHandler = SecContextHandler.class$("org.globus.ogsa.impl.security.authentication.SecContextHandler")) : class$org$globus$ogsa$impl$security$authentication$SecContextHandler).getName());
    private Authenticator authInfo;
    private String lastMode;
    private boolean auto;
    private Thread lastThread;
    private static SecureContextEstablishmentServiceLocator authLocator = new SecureContextEstablishmentServiceLocator();
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$authentication$SecContextHandler;

    public SecContextHandler() {
        log.debug((Object)"Enter: constructor");
    }

    public boolean handleRequest(MessageContext msgContext) {
        String mode;
        log.debug((Object)"Enter: invoke");
        Object tmp = msgContext.getProperty("org.globus.security.msg.type");
        if (tmp == null || tmp.equals(Constants.NONE)) {
            this.authInfo = null;
            log.debug((Object)"Exit: invoke");
            return true;
        }
        if (log.isDebugEnabled()) {
            if (this.lastThread == null) {
                this.lastThread = Thread.currentThread();
            } else if (this.lastThread != Thread.currentThread()) {
                throw WSSecurityFault.makeFault(new Exception("Multiple threads accessing the same handler!"));
            }
        }
        if ((mode = (String)msgContext.getProperty("org.globus.gsi.mode")) == null) {
            mode = "gsi";
        }
        if (this.authInfo == null || this.lastMode != mode) {
            log.debug((Object)"Establishing new context");
            try {
                String endpointAddress = AuthUtil.getEndpointAddress(msgContext);
                if (this.auto) {
                    endpointAddress = endpointAddress + "/authService";
                }
                URL endPoint = new URL(endpointAddress);
                SecureContextEstablishmentPortType auth = authLocator.getSecureContextEstablishmentPort(endPoint);
                GSSCredential gssCred = null;
                Subject subject = JaasSubject.getCurrentSubject();
                if (subject != null) {
                    log.debug((Object)"Getting credentials from subject");
                    gssCred = JaasGssUtil.getCredential((Subject)subject);
                }
                if (gssCred == null) {
                    log.debug((Object)"Getting credentials from property");
                    gssCred = (GSSCredential)msgContext.getProperty("org.globus.gsi.credentials");
                }
                GSSManager manager = ExtendedGSSManager.getInstance();
                ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext(null, GSSConstants.MECH_OID, gssCred, 0);
                context.requestConf(true);
                log.debug((Object)("Delegation mode: " + mode));
                if (mode.equalsIgnoreCase("gsilimited")) {
                    context.setOption(GSSConstants.DELEGATION_TYPE, (Object)GSIConstants.DELEGATION_TYPE_LIMITED);
                    context.requestCredDeleg(true);
                } else if (mode.equalsIgnoreCase("gsifull")) {
                    context.setOption(GSSConstants.DELEGATION_TYPE, (Object)GSIConstants.DELEGATION_TYPE_FULL);
                    context.requestCredDeleg(true);
                } else if (mode.equalsIgnoreCase("gsi")) {
                    context.requestCredDeleg(false);
                } else {
                    throw new Exception("Invalid GSI MODE: " + mode);
                }
                this.lastMode = mode;
                ProxyPolicyHandler grimPolicyHandler = (ProxyPolicyHandler)msgContext.getProperty("org.globus.ogsa.security.grim.policy.handler");
                if (grimPolicyHandler != null) {
                    log.debug((Object)"Grim policy handler set");
                    context.setOption(GSSConstants.GRIM_POLICY_HANDLER, (Object)grimPolicyHandler);
                }
                this.authInfo = new Authenticator((GSSContext)context);
                this.authInfo.authenticate(auth);
                Subject peer = JaasGssUtil.createSubject((GSSName)this.authInfo.getContext().getTargName(), null);
                Authorization author = (Authorization)msgContext.getProperty("org.globus.ogsa.security.authorization");
                if (author == null) {
                    author = HostAuthorization.getInstance();
                }
                author.authorize(peer, msgContext);
                log.debug((Object)"Context established");
            }
            catch (Exception e) {
                this.authInfo = null;
                log.error((Object)"Failed to establish security context", (Throwable)e);
                throw WSSecurityFault.makeFault(e);
            }
        } else {
            log.debug((Object)"Reusing existing context");
        }
        SecContext secContext = new SecContext(this.authInfo.getContext(), this.authInfo.getContextId());
        msgContext.setProperty("org.globus.security.context", (Object)secContext);
        log.debug((Object)"Exit: invoke");
        return true;
    }

    public void init(HandlerInfo config) {
        if (config == null) {
            return;
        }
        Map options = config.getHandlerConfig();
        if (options == null) {
            return;
        }
        String type = (String)options.get("authService");
        this.auto = type != null && type.equals("auto");
    }

    public QName[] getHeaders() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

