/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authentication;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.impl.security.authentication.GssSignedSOAPEnvelopeBuilder;
import org.globus.ogsa.impl.security.authentication.SecContext;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityFault;

public class SignHandler
extends GenericHandler {
    protected static Log log = LogFactory.getLog((String)(class$org$globus$ogsa$impl$security$authentication$SignHandler == null ? (class$org$globus$ogsa$impl$security$authentication$SignHandler = SignHandler.class$("org.globus.ogsa.impl.security.authentication.SignHandler")) : class$org$globus$ogsa$impl$security$authentication$SignHandler).getName());
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$authentication$SignHandler;

    public boolean handleRequest(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context);
    }

    public boolean handleResponse(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context);
    }

    public boolean handleMessage(SOAPMessageContext ctx) {
        SecContext secContext = (SecContext)ctx.getProperty("org.globus.security.context");
        if (secContext == null) {
            log.debug((Object)"No context - not signing.");
            return true;
        }
        log.debug((Object)"Enter: sign");
        SOAPMessage msg = ctx.getMessage();
        SOAPMessage signedMsg = null;
        try {
            SOAPEnvelope unsignedEnvelope = msg.getSOAPPart().getEnvelope();
            GssSignedSOAPEnvelopeBuilder builder = new GssSignedSOAPEnvelopeBuilder((MessageContext)ctx, secContext.getContext(), secContext.getContextId());
            builder.setActor((String)ctx.getProperty("gssActor"));
            signedMsg = builder.buildMessage(unsignedEnvelope);
        }
        catch (Exception e) {
            log.error((Object)"Failed to sign messsage", (Throwable)e);
            throw WSSecurityFault.makeFault(e);
        }
        ctx.setMessage(signedMsg);
        log.debug((Object)"Exit: sign");
        return true;
    }

    public QName[] getHeaders() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

