/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authentication;

import java.util.Iterator;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityUtil;
import org.globus.ogsa.impl.security.util.EnvelopeConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class WSSecuritySOAPEnvelopeBuilder {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$security$authentication$WSSecuritySOAPEnvelopeBuilder == null ? (class$org$globus$ogsa$impl$security$authentication$WSSecuritySOAPEnvelopeBuilder = WSSecuritySOAPEnvelopeBuilder.class$("org.globus.ogsa.impl.security.authentication.WSSecuritySOAPEnvelopeBuilder")) : class$org$globus$ogsa$impl$security$authentication$WSSecuritySOAPEnvelopeBuilder).getName());
    protected MessageContext msgContext;
    protected String actor;
    protected String baseURI;
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$authentication$WSSecuritySOAPEnvelopeBuilder;

    public WSSecuritySOAPEnvelopeBuilder() {
    }

    public WSSecuritySOAPEnvelopeBuilder(MessageContext msgContext) {
        this.msgContext = msgContext;
    }

    public SOAPEnvelope build(SOAPEnvelope envelope) throws Exception {
        return this.buildMessage(envelope).getSOAPPart().getEnvelope();
    }

    public abstract SOAPMessage buildMessage(SOAPEnvelope var1) throws Exception;

    public String getActor() {
        return this.actor == null ? "" : this.actor;
    }

    public String getBaseURI() {
        return this.baseURI == null ? "" : this.baseURI;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    protected SOAPHeaderElement addSecurityHeader(SOAPEnvelope env) throws SOAPException {
        SOAPHeaderElement he;
        SOAPHeader header = env.getHeader();
        if (header == null) {
            header = env.addHeader();
        }
        Iterator headerElements = header.examineHeaderElements(this.getActor());
        while (headerElements.hasNext()) {
            he = (SOAPHeaderElement)headerElements.next();
            Name nm = he.getElementName();
            if (!nm.getLocalName().equalsIgnoreCase("Security") || !nm.getURI().equalsIgnoreCase("http://schemas.xmlsoap.org/ws/2002/04/secext")) continue;
            return he;
        }
        Name headerName = env.createName("Security", "wsse", "http://schemas.xmlsoap.org/ws/2002/04/secext");
        he = header.addHeaderElement(headerName);
        he.setActor(this.getActor());
        return he;
    }

    protected String addBodyID(Document doc) throws Exception {
        Element bodyElement = WSSecurityUtil.findFirstBodyElement(doc);
        if (bodyElement == null) {
            throw new Exception("Element node not found");
        }
        String id = bodyElement.getAttributeNS("http://schemas.xmlsoap.org/ws/2002/04/utility", "Id");
        if (id == null || id.length() == 0) {
            id = "digestSource";
            String prefix = WSSecurityUtil.setNamespace(bodyElement, "http://schemas.xmlsoap.org/ws/2002/04/utility", "wsu");
            bodyElement.setAttributeNS("http://schemas.xmlsoap.org/ws/2002/04/utility", prefix + ":Id", id);
        }
        return id;
    }

    protected void insertIntoSecurityHeader(Document doc, Element elem) throws Exception {
        Element wsSecHeaderElement = WSSecurityUtil.getSecurityHeader(doc, this.getActor());
        if (wsSecHeaderElement == null) {
            throw new Exception("No header found");
        }
        Node firstChild = wsSecHeaderElement.getFirstChild();
        if (firstChild == null) {
            wsSecHeaderElement.appendChild(elem);
        } else {
            wsSecHeaderElement.insertBefore(elem, firstChild);
        }
    }

    protected Document getAsDocument(SOAPEnvelope env) throws Exception {
        return EnvelopeConverter.getInstance().toDocument(env);
    }

    protected SOAPMessage toSOAPMessage(Document doc) throws Exception {
        return EnvelopeConverter.getInstance().toSOAPMessage(doc);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Init.init();
    }
}

