/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authentication;

import java.security.cert.X509Certificate;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.ogsa.impl.security.authentication.SOAPBodyIdResolver;
import org.globus.ogsa.impl.security.authentication.WSSecuritySOAPEnvelopeBuilder;
import org.globus.ogsa.impl.security.authentication.wssec.PKIPathSecurityToken;
import org.globus.ogsa.impl.security.authentication.wssec.Reference;
import org.globus.ogsa.impl.security.authentication.wssec.SecurityTokenReference;
import org.ietf.jgss.GSSCredential;
import org.w3c.dom.Document;

public class X509WSSignedSOAPEnvelopeBuilder
extends WSSecuritySOAPEnvelopeBuilder {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$security$authentication$X509WSSignedSOAPEnvelopeBuilder == null ? (class$org$globus$ogsa$impl$security$authentication$X509WSSignedSOAPEnvelopeBuilder = X509WSSignedSOAPEnvelopeBuilder.class$("org.globus.ogsa.impl.security.authentication.X509WSSignedSOAPEnvelopeBuilder")) : class$org$globus$ogsa$impl$security$authentication$X509WSSignedSOAPEnvelopeBuilder).getName());
    protected GSSCredential credential;
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$authentication$X509WSSignedSOAPEnvelopeBuilder;

    public X509WSSignedSOAPEnvelopeBuilder(MessageContext msgContext, GSSCredential credential) {
        super(msgContext);
        this.credential = credential;
    }

    private GlobusCredential getCredential() throws Exception {
        if (this.credential == null) {
            return GlobusCredential.getDefaultCredential();
        }
        if (this.credential instanceof GlobusGSSCredentialImpl) {
            return ((GlobusGSSCredentialImpl)this.credential).getGlobusCredential();
        }
        return null;
    }

    public SOAPMessage buildMessage(SOAPEnvelope env) throws Exception {
        logger.debug((Object)"Beginning signing...");
        GlobusCredential credential = this.getCredential();
        if (credential == null) {
            throw new Exception("no credentials");
        }
        this.addSecurityHeader(env);
        Document doc = this.getAsDocument(env);
        String id = this.addBodyID(doc);
        XMLSignature sig = new XMLSignature(doc, this.baseURI, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2001/10/xml-exc-c14n#");
        sig.addResourceResolver(SOAPBodyIdResolver.getInstance());
        sig.addDocument("#" + id);
        String uri = "token" + System.currentTimeMillis();
        Reference ref = new Reference(doc);
        ref.setURI("#" + uri);
        SecurityTokenReference secRef = new SecurityTokenReference(doc);
        secRef.setReference(ref);
        KeyInfo info = sig.getKeyInfo();
        info.addUnknownElement(secRef.getElement());
        PKIPathSecurityToken token = new PKIPathSecurityToken(doc);
        X509Certificate[] certs = credential.getCertificateChain();
        token.setX509Certificates(certs, true);
        token.setID(uri);
        this.insertIntoSecurityHeader(doc, sig.getElement());
        sig.sign(credential.getPrivateKey());
        this.insertIntoSecurityHeader(doc, token.getElement());
        logger.debug((Object)"Signing complete.");
        return this.toSOAPMessage(doc);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

