/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authentication.wssec;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.xml.namespace.QName;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.globus.gsi.CertUtil;
import org.globus.gsi.bc.BouncyCastleUtil;
import org.globus.ogsa.impl.security.authentication.wssec.BinarySecurityToken;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PKIPathSecurityToken
extends BinarySecurityToken {
    public static final QName TYPE = new QName("http://schemas.xmlsoap.org/ws/2002/04/secext", "PKIPath");

    public PKIPathSecurityToken(Element elem) throws WSSecurityException {
        super(elem);
        if (!this.getValueType().equals(TYPE)) {
            throw new WSSecurityException(4, "invalidValueType", new Object[]{TYPE, this.getValueType()});
        }
    }

    public PKIPathSecurityToken(Document doc) {
        super(doc);
        this.setValueType(TYPE);
    }

    public X509Certificate[] getX509Certificates(boolean reverse) throws GeneralSecurityException, IOException {
        byte[] data = this.getToken();
        if (data == null) {
            return null;
        }
        DERObject obj = BouncyCastleUtil.toDERObject((byte[])data);
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)obj);
        int size = seq.size();
        X509Certificate[] certs = new X509Certificate[size];
        int i = 0;
        while (i < size) {
            obj = seq.getObjectAt(i).getDERObject();
            data = BouncyCastleUtil.toByteArray((DERObject)obj);
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            certs[reverse ? size - 1 - i : i] = CertUtil.loadCertificate((InputStream)in);
            ++i;
        }
        return certs;
    }

    public void setX509Certificates(X509Certificate[] certs, boolean reverse) throws CertificateEncodingException, IOException {
        int i;
        if (certs == null) {
            throw new IllegalArgumentException("data == null");
        }
        DEREncodableVector vec = new DEREncodableVector();
        if (reverse) {
            i = certs.length - 1;
            while (i >= 0) {
                vec.add((DEREncodable)BouncyCastleUtil.toDERObject((byte[])certs[i].getEncoded()));
                --i;
            }
        } else {
            i = 0;
            while (i < certs.length) {
                vec.add((DEREncodable)BouncyCastleUtil.toDERObject((byte[])certs[i].getEncoded()));
                ++i;
            }
        }
        DERSequence seq = new DERSequence(vec);
        this.setToken(BouncyCastleUtil.toByteArray((DERObject)seq));
    }
}

