/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authentication.wssec;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.xml.rpc.handler.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignature;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.globus.gsi.proxy.ProxyPolicyHandler;
import org.globus.ogsa.ServiceProperties;
import org.globus.ogsa.impl.security.Constants;
import org.globus.ogsa.impl.security.authentication.ContextManager;
import org.globus.ogsa.impl.security.authentication.GSSEncryptedData;
import org.globus.ogsa.impl.security.authentication.GssXMLSignature;
import org.globus.ogsa.impl.security.authentication.SecContext;
import org.globus.ogsa.impl.security.authentication.SecureServicePropertiesHelper;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityEngine;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityException;
import org.globus.ogsa.repository.ServiceActivationException;
import org.globus.ogsa.repository.ServiceNode;
import org.gridforum.ogsi.NoSuchServiceFaultType;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSName;

public class WSSecurityRequestEngine
extends WSSecurityEngine {
    private static Log log = LogFactory.getLog((String)(class$org$globus$ogsa$impl$security$authentication$wssec$WSSecurityRequestEngine == null ? (class$org$globus$ogsa$impl$security$authentication$wssec$WSSecurityRequestEngine = WSSecurityRequestEngine.class$("org.globus.ogsa.impl.security.authentication.wssec.WSSecurityRequestEngine")) : class$org$globus$ogsa$impl$security$authentication$wssec$WSSecurityRequestEngine).getName());
    private static WSSecurityEngine engine;
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$authentication$wssec$WSSecurityRequestEngine;

    public static synchronized WSSecurityEngine getEngine() {
        if (engine == null) {
            engine = new WSSecurityRequestEngine();
        }
        return engine;
    }

    public boolean verifyGssXMLSignature(GssXMLSignature sig, MessageContext msgContext) throws Exception {
        log.debug((Object)"Enter: verifyGssXMLSignature");
        String contextId = sig.getKeyInfoContextId();
        log.debug((Object)("context id: " + contextId));
        String servicePath = ((org.apache.axis.MessageContext)msgContext).getTargetService();
        SecContext context = this.getContext(servicePath, contextId);
        if (context == null) {
            throw new WSSecurityException(0, "noContext", new Object[]{contextId});
        }
        sig.verify(context.getContext());
        this.setContextProperties(msgContext, context, Constants.SIGNATURE);
        log.debug((Object)"Exit: verifyGssXMLSignature");
        return false;
    }

    public boolean decryptGssXMLEncryption(GSSEncryptedData encryptedData, MessageContext msgContext) throws Exception {
        log.debug((Object)"Enter: decryptGssXMLEncryption");
        String contextId = encryptedData.getKeyInfoContextId();
        log.debug((Object)("context id: " + contextId));
        String servicePath = ((org.apache.axis.MessageContext)msgContext).getTargetService();
        SecContext context = this.getContext(servicePath, contextId);
        if (context == null) {
            throw new WSSecurityException(0, "noContext", new Object[]{contextId});
        }
        encryptedData.decryptAndReplace(context.getContext());
        this.setContextProperties(msgContext, context, Constants.ENCRYPTION);
        log.debug((Object)"Exit: decryptGssXMLEncryption");
        return true;
    }

    protected ProxyPolicyHandler getGrimProxyHandler(XMLSignature sig, MessageContext msgCtx) throws Exception {
        String servicePath = ((org.apache.axis.MessageContext)msgCtx).getTargetService();
        ServiceNode root = ServiceNode.getRootNode();
        ServiceProperties props = (ServiceProperties)root.resolve(servicePath);
        if (props == null) {
            return null;
        }
        try {
            props = (ServiceProperties)root.activate(servicePath);
        }
        catch (ServiceActivationException e) {
            log.debug((Object)"Service activation failed", (Throwable)e);
            return null;
        }
        return SecureServicePropertiesHelper.getGrimProxyPolicyHandler(props);
    }

    private SecContext getContext(String servicePath, String contextId) throws NoSuchServiceFaultType {
        ServiceProperties props = (ServiceProperties)ServiceNode.getRootNode().resolve(servicePath);
        if (props == null) {
            throw new NoSuchServiceFaultType();
        }
        ContextManager manager = SecureServicePropertiesHelper.getContextManager(props);
        return manager == null ? null : manager.get(contextId);
    }

    private void setContextProperties(MessageContext msgContext, SecContext secContext, Integer msgType) throws Exception {
        msgContext.setProperty("org.globus.security.context", (Object)secContext);
        msgContext.setProperty("org.globus.security.msg.type", (Object)msgType);
        Subject subject = this.getSubject(msgContext);
        GSSContext ctx = secContext.getContext();
        GSSName caller = ctx.getSrcName();
        if (!caller.isAnonymous()) {
            String callerIdentity = caller.toString();
            GSSCredential cred = ctx.getDelegCred();
            subject.getPrincipals().add((Principal)new GlobusPrincipal(callerIdentity));
            if (cred != null) {
                subject.getPrivateCredentials().add(cred);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

