/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.authorization;

import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.globus.ogsa.impl.security.authorization.HostAuthorization;
import org.globus.ogsa.impl.security.authorization.IdentityAuthorization;
import org.globus.ogsa.impl.security.authorization.NoAuthorization;
import org.globus.ogsa.impl.security.authorization.SelfAuthorization;

public class AuthPropertyTranslator
extends BasicHandler {
    public void invoke(MessageContext context) throws AxisFault {
        Object newAuth = context.getProperty("org.globus.ogsa.security.authorization");
        Object oldAuth = context.getProperty("org.globus.gsi.authorization");
        if (newAuth != null && oldAuth == null) {
            String url = (String)context.getProperty("transport.url");
            if (url != null && url.startsWith("httpg")) {
                context.setProperty("org.globus.gsi.authorization", this.convertToOld(newAuth));
            }
        } else if (oldAuth != null && newAuth == null) {
            context.setProperty("org.globus.ogsa.security.authorization", this.convertToNew(oldAuth));
        }
    }

    public Object convertToOld(Object newAuth) {
        if (newAuth instanceof NoAuthorization) {
            return org.globus.gsi.gssapi.auth.NoAuthorization.getInstance();
        }
        if (newAuth instanceof HostAuthorization) {
            return org.globus.gsi.gssapi.auth.HostAuthorization.getInstance();
        }
        if (newAuth instanceof SelfAuthorization) {
            return org.globus.gsi.gssapi.auth.SelfAuthorization.getInstance();
        }
        if (newAuth instanceof IdentityAuthorization) {
            String identity = ((IdentityAuthorization)newAuth).getIdentity();
            return new org.globus.gsi.gssapi.auth.IdentityAuthorization(identity);
        }
        throw new IllegalArgumentException("unsupported auth" + newAuth);
    }

    public Object convertToNew(Object oldAuth) {
        if (oldAuth instanceof org.globus.gsi.gssapi.auth.NoAuthorization) {
            return NoAuthorization.getInstance();
        }
        if (oldAuth instanceof org.globus.gsi.gssapi.auth.HostAuthorization) {
            return HostAuthorization.getInstance();
        }
        if (oldAuth instanceof org.globus.gsi.gssapi.auth.SelfAuthorization) {
            return SelfAuthorization.getInstance();
        }
        if (oldAuth instanceof org.globus.gsi.gssapi.auth.IdentityAuthorization) {
            String identity = ((org.globus.gsi.gssapi.auth.IdentityAuthorization)oldAuth).getIdentity();
            return new IdentityAuthorization(identity);
        }
        throw new IllegalArgumentException("unsupported auth" + oldAuth);
    }
}

