/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.impl.security.descriptor;

import java.io.File;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.GlobusCredentialException;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.ogsa.config.ConfigException;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.util.I18n;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class ContainerSecurityConfig {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$impl$security$descriptor$ContainerSecurityConfig == null ? (class$org$globus$ogsa$impl$security$descriptor$ContainerSecurityConfig = ContainerSecurityConfig.class$("org.globus.ogsa.impl.security.descriptor.ContainerSecurityConfig")) : class$org$globus$ogsa$impl$security$descriptor$ContainerSecurityConfig).getName());
    private static I18n i18n = I18n.getI18n((String)"org.globus.ogsa.impl.security.descriptor.errors", (ClassLoader)(class$org$globus$ogsa$impl$security$descriptor$ContainerSecurityConfig == null ? (class$org$globus$ogsa$impl$security$descriptor$ContainerSecurityConfig = ContainerSecurityConfig.class$("org.globus.ogsa.impl.security.descriptor.ContainerSecurityConfig")) : class$org$globus$ogsa$impl$security$descriptor$ContainerSecurityConfig).getClassLoader());
    public static final String GRIDMAP = "gridmap";
    public static final String CONTAINER_KEY = "containerKey";
    public static final String CONTAINER_CERT = "containerCert";
    public static final String CONTAINER_PROXY = "containerProxy";
    private Subject subject;
    private GSSCredential credential;
    private long lastModified;
    private static ContainerSecurityConfig securityConfig;
    static /* synthetic */ Class class$org$globus$ogsa$impl$security$descriptor$ContainerSecurityConfig;

    protected ContainerSecurityConfig() {
    }

    public static synchronized ContainerSecurityConfig getConfig() {
        if (securityConfig == null) {
            securityConfig = new ContainerSecurityConfig();
        }
        return securityConfig;
    }

    public synchronized Subject getSubject() throws ConfigException {
        try {
            if (!this.isUpToDate()) {
                this.initCredentials();
            }
        }
        catch (GSSException e) {
            throw new ConfigException(e);
        }
        catch (GlobusCredentialException e) {
            throw new ConfigException((Exception)((Object)e));
        }
        return this.subject;
    }

    public String getGridMapFile() throws ConfigException {
        return ContainerConfig.getConfig().getOption(GRIDMAP);
    }

    protected boolean isUpToDate() throws ConfigException, GSSException {
        File file;
        if (this.credential == null || this.credential.getRemainingLifetime() < 60) {
            return false;
        }
        ContainerConfig config = ContainerConfig.getConfig();
        String credFile = config.getOption(CONTAINER_CERT);
        if (credFile == null) {
            credFile = config.getOption(CONTAINER_PROXY);
        }
        if (credFile != null && (file = new File(credFile)).lastModified() != this.lastModified) {
            this.lastModified = file.lastModified();
            return false;
        }
        return true;
    }

    protected void initCredentials() throws ConfigException, GlobusCredentialException, GSSException {
        GlobusCredential cred = null;
        ContainerConfig config = ContainerConfig.getConfig();
        String certFile = config.getOption(CONTAINER_CERT);
        if (certFile == null) {
            String proxyFile = config.getOption(CONTAINER_PROXY);
            if (proxyFile == null) {
                logger.debug((Object)"No credential specified, using defaults.");
            } else {
                logger.debug((Object)("Loading credential (c), proxy = '" + proxyFile + "'"));
                cred = new GlobusCredential(proxyFile);
                this.lastModified = new File(proxyFile).lastModified();
            }
        } else {
            String keyFile = config.getOption(CONTAINER_KEY);
            if (keyFile == null) {
                throw new ConfigException(i18n.getMessage("containerKeyMissing"));
            }
            logger.debug((Object)("Loading credential (c), cert = '" + certFile + "' key = '" + keyFile + "'"));
            cred = new GlobusCredential(certFile, keyFile);
            this.lastModified = new File(certFile).lastModified();
        }
        if (cred != null) {
            this.credential = ContainerSecurityConfig.toGSSCredential(cred);
        } else {
            GSSManager manager = ExtendedGSSManager.getInstance();
            this.credential = manager.createCredential(0);
        }
        this.subject = JaasGssUtil.createSubject((GSSCredential)this.credential);
        this.subject.setReadOnly();
    }

    static GSSCredential toGSSCredential(GlobusCredential cred) throws GSSException {
        return new GlobusGSSCredentialImpl(cred, 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

