/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.router;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.proxy.IgnoreProxyPolicyHandler;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.handlers.RPCURIProvider;
import org.globus.ogsa.impl.security.authentication.wssec.WSSecurityUtil;
import org.globus.ogsa.router.HostStarter;
import org.globus.ogsa.router.ProxyTargetStarter;
import org.globus.ogsa.router.RedirectException;
import org.globus.ogsa.router.RedirectInfo;
import org.globus.ogsa.server.ServiceHost;
import org.globus.ogsa.utils.MessageUtils;
import org.globus.ogsa.utils.PerformanceLog;
import org.gridforum.ogsi.ServiceAlreadyExistsFaultType;

public class RedirectProvider
extends RPCURIProvider {
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$router$RedirectProvider == null ? (class$org$globus$ogsa$router$RedirectProvider = RedirectProvider.class$("org.globus.ogsa.router.RedirectProvider")) : class$org$globus$ogsa$router$RedirectProvider).getName());
    static PerformanceLog performanceLogger = new PerformanceLog((class$org$globus$ogsa$router$RedirectProvider == null ? (class$org$globus$ogsa$router$RedirectProvider = RedirectProvider.class$("org.globus.ogsa.router.RedirectProvider")) : class$org$globus$ogsa$router$RedirectProvider).getName() + ".performance");
    private static HashMap redirMap = new HashMap();
    private static Hashtable branchMap = new Hashtable();
    private static Service routerService = new Service();
    static /* synthetic */ Class class$org$globus$ogsa$router$RedirectProvider;
    static /* synthetic */ Class class$java$lang$Object;

    public RedirectProvider() {
        logger.debug((Object)"Creating RedirectProvider instance");
    }

    public static synchronized void addTarget(String localServicePath, String targetEndpoint, ProxyTargetStarter starter, boolean tryLocal, String createdInstanceSchemaPath) throws ServiceAlreadyExistsFaultType {
        if (redirMap.containsKey(localServicePath = localServicePath.trim().toLowerCase())) {
            throw new ServiceAlreadyExistsFaultType();
        }
        redirMap.put(localServicePath, new RedirectInfo(targetEndpoint, starter, tryLocal, createdInstanceSchemaPath));
    }

    public static synchronized void removeTarget(String localServicePath) {
        redirMap.remove(localServicePath);
    }

    private static synchronized RedirectInfo getTargetInfo(String localServicePath) {
        if (localServicePath == null) {
            return null;
        }
        localServicePath = localServicePath.trim().toLowerCase();
        return (RedirectInfo)redirMap.get(localServicePath);
    }

    private static synchronized RedirectInfo getTargetInfo(org.apache.axis.MessageContext context) {
        String url = (String)context.getProperty("transport.url");
        String path = RedirectProvider.getPath(url);
        String branch = RedirectProvider.getBranch(path);
        if (branch == null) {
            return null;
        }
        String endpointPath = RedirectProvider.getEndpointPath(path);
        RedirectInfo templateInfo = (RedirectInfo)branchMap.get(branch);
        if (templateInfo == null) {
            return null;
        }
        RedirectInfo endpointInfo = new RedirectInfo(templateInfo.targetEndpoint + endpointPath, templateInfo.starter, false, null);
        return endpointInfo;
    }

    static synchronized String getPath(String url) {
        int pos = url.indexOf(ContainerConfig.getOgsiLocation());
        int pathPos = pos + ContainerConfig.getOgsiLocation().length();
        String path = url.substring(pathPos, url.length());
        logger.debug((Object)("Getting url path: " + path));
        return path;
    }

    static synchronized String getBranch(String url) {
        int pos = url.indexOf("/");
        if (pos == -1) {
            return null;
        }
        String branch = url.substring(0, pos);
        logger.debug((Object)("Getting url branch: " + branch));
        return branch;
    }

    public static boolean branchExists(String path) {
        if (path == null) {
            return false;
        }
        String branch = RedirectProvider.getBranch(path);
        if (branch == null) {
            return false;
        }
        return branchMap.containsKey(branch);
    }

    static synchronized String getEndpointPath(String url) {
        int pos = url.indexOf("/");
        String endpoint = url.substring(pos + 1, url.length());
        logger.debug((Object)("Getting url endpoint: " + endpoint));
        return endpoint;
    }

    public static synchronized String getTarget(String localServicePath) {
        RedirectInfo info = RedirectProvider.getTargetInfo(localServicePath);
        return info != null ? info.targetEndpoint : null;
    }

    public static synchronized ProxyTargetStarter getTargetStarter(String localServicePath) {
        RedirectInfo info = RedirectProvider.getTargetInfo(localServicePath);
        return info != null ? info.starter : null;
    }

    public static synchronized boolean isRedirected(org.apache.axis.MessageContext msgContext) {
        String localServicePath = msgContext.getTargetService();
        RedirectInfo info = RedirectProvider.getTargetInfo(localServicePath);
        if (info != null) {
            return true;
        }
        String url = (String)msgContext.getProperty("transport.url");
        String path = RedirectProvider.getPath(url);
        String branch = RedirectProvider.getBranch(path);
        if (branch == null) {
            return false;
        }
        RedirectInfo templateInfo = (RedirectInfo)branchMap.get(branch);
        return templateInfo != null;
    }

    public void processMessage(org.apache.axis.MessageContext msgContext, org.apache.axis.message.SOAPEnvelope reqEnv, org.apache.axis.message.SOAPEnvelope resEnv, Object obj) throws Exception {
        String localServicePath = msgContext.getTargetService();
        boolean tryLocal = false;
        RedirectInfo redirInfo = RedirectProvider.getTargetInfo(localServicePath);
        if (redirInfo == null && (redirInfo = RedirectProvider.getTargetInfo(msgContext)) != null) {
            logger.debug((Object)"Got branch mapping redirect info");
        }
        if (redirInfo == null) {
            tryLocal = true;
            logger.debug((Object)("RedirectProvider can't find remote target for localServicePath =" + localServicePath));
        }
        if (tryLocal || redirInfo.tryLocal) {
            try {
                super.processMessage(msgContext, reqEnv, resEnv, obj);
                logger.debug((Object)(localServicePath + " handled locally, not redirecting"));
            }
            catch (Exception exc) {
                RedirectException redirExc = this.getRedirectException(exc);
                if (this.isNoSuchMethodException(exc)) {
                    logger.debug((Object)"RedirectProvider can't find that method on the local service, redirecting it");
                    this.redirectMessage(localServicePath, exc, redirInfo, msgContext, reqEnv, resEnv);
                }
                if (redirExc != null) {
                    if (redirExc.getTargetEndpoint() != null) {
                        redirInfo = new RedirectInfo(redirExc.getTargetEndpoint(), redirInfo.starter, false, redirInfo.createdInstanceSchemaPath);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Got a RedirectException from the local service, redirecting to " + redirInfo.targetEndpoint));
                    }
                    this.redirectMessage(localServicePath, redirExc, redirInfo, msgContext, reqEnv, resEnv);
                }
                logger.error((Object)MessageUtils.getMessage("redirectUnknownException"));
                throw exc;
            }
        } else {
            this.redirectMessage(localServicePath, null, redirInfo, msgContext, reqEnv, resEnv);
        }
    }

    private RedirectException getRedirectException(Throwable exc) {
        if (exc == null) {
            return null;
        }
        if (exc instanceof RedirectException) {
            return (RedirectException)exc;
        }
        return this.getRedirectException(RedirectException.getNextChainedException(exc));
    }

    private boolean isNoSuchMethodException(Throwable exc) {
        if (exc == null) {
            return false;
        }
        if (exc instanceof NoSuchMethodException) {
            return true;
        }
        if (exc instanceof AxisFault && ((AxisFault)exc).getFaultString().startsWith("No such operation")) {
            return true;
        }
        return this.isNoSuchMethodException(RedirectException.getNextChainedException(exc));
    }

    public void redirectMessage(String localServicePath, Exception initialException, RedirectInfo redirInfo, org.apache.axis.MessageContext msgContext, org.apache.axis.message.SOAPEnvelope reqEnv, org.apache.axis.message.SOAPEnvelope resEnv) throws Exception {
        if (redirInfo.targetEndpoint == null || initialException != null && redirInfo.starter != null) {
            String newTarget = redirInfo.starter.startProxyTarget(localServicePath, redirInfo.targetEndpoint, initialException);
            if (redirInfo.targetEndpoint == null && newTarget == null) {
                throw new Exception(MessageUtils.getMessage("startProxyTargetEndpointError"));
            }
            if (newTarget != null) {
                redirInfo.targetEndpoint = newTarget;
            }
        }
        Call call = this.setupCall(redirInfo.targetEndpoint, msgContext.getRequestMessage());
        String viaURL = this.getBaseUrl(msgContext, redirInfo.starter, initialException);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("redirecting " + localServicePath + " to " + redirInfo.targetEndpoint));
                logger.debug((Object)("Routing " + msgContext.getRequestMessage().getSOAPEnvelope().toString()));
            }
            performanceLogger.start();
            call.setProperty("org.globus.ogsa.RouterVia", (Object)viaURL);
            call.invoke();
            performanceLogger.stop("invoke");
        }
        catch (Exception e) {
            logger.debug((Object)("Remote call failed. Now trying to start remote target. Remote Exception:" + e.getMessage()));
            if (redirInfo.starter == null) {
                logger.debug((Object)"there is no ProxyTargetStarter, rethrowing exception");
                throw e;
            }
            String newTarget = redirInfo.starter.startProxyTarget(localServicePath, redirInfo.targetEndpoint, e);
            if (newTarget != null) {
                redirInfo.targetEndpoint = newTarget;
            }
            call = this.setupCall(redirInfo.targetEndpoint, msgContext.getRequestMessage());
            call.setProperty("org.globus.ogsa.RouterVia", (Object)viaURL);
            performanceLogger.start();
            call.invoke();
            performanceLogger.stop("invoke");
        }
        Message remoteResponseMessage = call.getResponseMessage();
        org.apache.axis.message.SOAPEnvelope remoteResponseEnvelope = remoteResponseMessage.getSOAPEnvelope();
        SOAPBody remoteResponseBody = (SOAPBody)remoteResponseEnvelope.getBody();
        remoteResponseBody.disableFormatting();
        SOAPHeader remoteResponseHeader = (SOAPHeader)remoteResponseEnvelope.getHeader();
        resEnv.setHeader(remoteResponseHeader);
        resEnv.setBody(remoteResponseBody);
        ((SOAPBody)resEnv.getBody()).disableFormatting();
        this.checkForCreateService(redirInfo, msgContext, remoteResponseEnvelope, redirInfo.starter, initialException);
        this.checkSignature(remoteResponseEnvelope, msgContext);
    }

    private void checkSignature(org.apache.axis.message.SOAPEnvelope reply, org.apache.axis.MessageContext ctx) throws Exception {
        if (Boolean.TRUE.equals(ctx.getProperty("org.globus.ogsa.security.sign.msg")) && WSSecurityUtil.getSecurityHeader((SOAPEnvelope)reply, "") != null) {
            ctx.setProperty("org.globus.ogsa.security.sign.msg", (Object)Boolean.FALSE);
        }
    }

    private Call setupCall(String target, Message requestMessage) throws ServiceException, MalformedURLException, AxisFault, SOAPException {
        Call call = (Call)routerService.createCall();
        call.setTargetEndpointAddress(new URL(target));
        org.apache.axis.message.SOAPEnvelope env = requestMessage.getSOAPEnvelope();
        ((SOAPBody)env.getBody()).disableFormatting();
        call.setProperty("org.globus.ogsa.router", (Object)Boolean.TRUE);
        String actor = (String)requestMessage.getMessageContext().getProperty("actor");
        if (actor != null) {
            call.setProperty("actor", (Object)actor);
        }
        call.setProperty("org.globus.ogsa.security.grim.policy.handler", (Object)new IgnoreProxyPolicyHandler());
        call.setRequestMessage(requestMessage);
        return call;
    }

    private String getBaseUrl(org.apache.axis.MessageContext msgContext, ProxyTargetStarter starter, Exception exception) throws GridServiceException {
        String url;
        String path;
        String tmpBranch;
        String branch = null;
        if (starter != null && starter instanceof HostStarter) {
            branch = ((HostStarter)starter).getUserName(exception);
        }
        if (branch == null && branchMap.containsKey(tmpBranch = RedirectProvider.getBranch(path = RedirectProvider.getPath(url = (String)msgContext.getProperty("transport.url"))))) {
            branch = tmpBranch;
        }
        GridContext context = new GridContext((MessageContext)msgContext);
        String newBaseUrl = ServiceHost.getDefaultProtocol(context) + "://" + ServiceHost.getHost() + ":" + ServiceHost.getDefaultPort(context) + "/" + ContainerConfig.getOgsiLocation();
        if (branch != null) {
            newBaseUrl = newBaseUrl + branch + "/";
        }
        return newBaseUrl;
    }

    private void checkForCreateService(RedirectInfo redirInfo, org.apache.axis.MessageContext msgContext, org.apache.axis.message.SOAPEnvelope remoteResponseEnvelope, ProxyTargetStarter starter, Exception initialException) {
        block8: {
            logger.debug((Object)"check for create createService call");
            if (redirInfo.createdInstanceSchemaPath == null) break block8;
            OperationDesc operation = msgContext.getOperation();
            logger.debug((Object)("checking for URL rewrite of " + operation.getName()));
            if (operation != null && operation.getName().equals("createService")) {
                logger.debug((Object)"found createService call");
                try {
                    SOAPHeaderElement routerHeader = remoteResponseEnvelope.getHeaderByName("http://ogsa.globus.org/", "router");
                    if (routerHeader == null) {
                        return;
                    }
                    String newTargetEndpoint = routerHeader.getAttributeValue("to");
                    remoteResponseEnvelope.removeHeader(routerHeader);
                    if (newTargetEndpoint == null) {
                        return;
                    }
                    String ogsiLocation = ContainerConfig.getOgsiLocation();
                    int serviceNameStart = newTargetEndpoint.indexOf(ogsiLocation) + ogsiLocation.length();
                    String newLocalInstance = newTargetEndpoint.substring(serviceNameStart);
                    if (starter != null && starter instanceof HostStarter) {
                        newLocalInstance = ((HostStarter)starter).getUserName(initialException) + "/" + newLocalInstance;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("RedirectProvider adding a new mapping in the routing table " + newLocalInstance + "->" + newTargetEndpoint));
                        logger.debug((Object)("Response message to redirect: " + remoteResponseEnvelope.toString()));
                    }
                    if (starter == null || !(starter instanceof HostStarter)) {
                        throw new GridServiceException(MessageUtils.getMessage("targetStarterNotSupported"));
                    }
                    String username = ((HostStarter)starter).getUserName(initialException);
                    logger.debug((Object)("Adding branch mapping for: " + username));
                    branchMap.put(username, new RedirectInfo(RedirectProvider.getTemplateBase(newTargetEndpoint), starter, false, null));
                    ((HostStarter)starter).targetCreated(newLocalInstance, newTargetEndpoint, initialException);
                }
                catch (Exception e) {
                    logger.error((Object)MessageUtils.getMessage("branchAddError"), (Throwable)e);
                }
            }
        }
    }

    private static String getTemplateBase(String url) {
        String ogsiLocation = ContainerConfig.getOgsiLocation();
        int pos = url.indexOf(ogsiLocation);
        String templateBase = url.substring(0, pos + ogsiLocation.length());
        logger.debug((Object)("Setting template base to: " + templateBase));
        return templateBase;
    }

    protected Class getServiceClass(String clsName, SOAPService service, org.apache.axis.MessageContext msgContext) throws AxisFault {
        if ("org.globus.ogsa.NotAssignedYet".equals(clsName)) {
            return class$java$lang$Object == null ? (class$java$lang$Object = RedirectProvider.class$("java.lang.Object")) : class$java$lang$Object;
        }
        return super.getServiceClass(clsName, service, msgContext);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

