/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.server;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.GridContext;
import org.globus.ogsa.GridServiceException;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.utils.MessageUtils;

public class ServiceHost {
    private static String hostCache = "";
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$server$ServiceHost == null ? (class$org$globus$ogsa$server$ServiceHost = ServiceHost.class$("org.globus.ogsa.server.ServiceHost")) : class$org$globus$ogsa$server$ServiceHost).getName());
    static /* synthetic */ Class class$org$globus$ogsa$server$ServiceHost;

    private static URL getEndpoint(GridContext context) throws MalformedURLException {
        MessageContext messageContext = (MessageContext)context.getMessageContext();
        String address = (String)messageContext.getProperty("transport.url");
        return new URL(address);
    }

    public static String getDefaultPort(GridContext context) {
        URL url = null;
        try {
            url = ServiceHost.getEndpoint(context);
        }
        catch (Exception e) {
            logger.debug((Object)MessageUtils.toString(e));
            return "8080";
        }
        int port = url.getPort();
        if (port == -1) {
            String protocol = url.getProtocol();
            if (protocol.equalsIgnoreCase("http")) {
                return "80";
            }
            if (protocol.equalsIgnoreCase("https")) {
                return "443";
            }
            return "8080";
        }
        return String.valueOf(port);
    }

    public static String getDefaultProtocol(GridContext context) {
        URL url = null;
        try {
            url = ServiceHost.getEndpoint(context);
        }
        catch (Exception e) {
            logger.debug((Object)MessageUtils.toString(e));
            return "http";
        }
        return url.getProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHost() throws GridServiceException {
        String string = hostCache;
        synchronized (string) {
            if (hostCache.equals("")) {
                hostCache = ServiceHost.updateHost();
            }
            return hostCache;
        }
    }

    private static String updateHost() throws GridServiceException {
        String domainName;
        ContainerConfig config = ContainerConfig.getConfig();
        InetAddress localHost = null;
        String logicalHostName = config.getOption("logicalHost");
        String disableDNSConfig = config.getOption("disableDNS");
        boolean disableDNS = disableDNSConfig == null ? false : disableDNSConfig.toUpperCase().equals("TRUE");
        String host = null;
        if (!disableDNS) {
            try {
                String ogsaHostIP;
                String ogsaHostName = config.getOption("ogsaHost");
                InetAddress ogsaHost = null;
                if (ogsaHostName != null) {
                    ogsaHost = InetAddress.getByName(ogsaHostName);
                }
                if (ogsaHost != null && (ogsaHostIP = ogsaHost.getHostAddress()) != null) {
                    return ogsaHostIP;
                }
            }
            catch (Exception e) {
                logger.debug((Object)MessageUtils.toString(e));
            }
            try {
                localHost = logicalHostName != null ? InetAddress.getByName(logicalHostName) : InetAddress.getLocalHost();
            }
            catch (Exception e) {
                throw new GridServiceException(e);
            }
            boolean publishHostName = false;
            String publishHost = config.getOption("publishHostName");
            if (publishHost != null && publishHost.toUpperCase().equals("TRUE")) {
                publishHostName = true;
            }
            host = publishHostName ? localHost.getHostName() : localHost.getHostAddress();
        } else if (logicalHostName != null) {
            host = logicalHostName;
        }
        if (host == null) {
            host = "localhost";
        } else if (host.indexOf(".") == -1 && (domainName = config.getOption("domainName")) != null) {
            host = host + "." + domainName;
        }
        return host;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

