/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.server;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.server.Semaphore;
import org.globus.ogsa.server.ServiceRequest;

public class ServiceRequestQueue {
    LinkedList requests = new LinkedList();
    int waitingThreads = 0;
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$server$ServiceRequestQueue == null ? (class$org$globus$ogsa$server$ServiceRequestQueue = ServiceRequestQueue.class$("org.globus.ogsa.server.ServiceRequestQueue")) : class$org$globus$ogsa$server$ServiceRequestQueue).getName());
    private Semaphore semaphore = new Semaphore();
    static /* synthetic */ Class class$org$globus$ogsa$server$ServiceRequestQueue;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRequest dequeue() throws NoSuchElementException, InterruptedException {
        this.addWaitingThread();
        this.semaphore.waitForSignal();
        this.removeWaitingThread();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Getting request from queue");
        }
        Object request = null;
        ServiceRequestQueue serviceRequestQueue = this;
        synchronized (serviceRequestQueue) {
            request = this.requests.removeFirst();
            if (!(request instanceof ServiceRequest)) {
                throw new NoSuchElementException();
            }
        }
        return request;
    }

    private synchronized void addWaitingThread() {
        ++this.waitingThreads;
    }

    private synchronized void removeWaitingThread() {
        --this.waitingThreads;
    }

    public synchronized int enqueue(ServiceRequest request) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Putting request in queue");
        }
        this.requests.addLast(request);
        this.semaphore.sendSignal();
        return this.waitingThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThreads(int threads) {
        int i = 0;
        while (i < threads) {
            LinkedList linkedList = this.requests;
            synchronized (linkedList) {
                this.requests.addFirst(new Object());
            }
            this.semaphore.sendSignal();
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

