/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.server;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.axis.AxisEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ogsa.config.ContainerConfig;
import org.globus.ogsa.server.ServiceRequestQueue;
import org.globus.ogsa.server.ServiceThread;
import org.globus.ogsa.utils.MessageUtils;

public class ServiceThreadPool {
    private Vector serviceThreads = new Vector();
    protected ServiceRequestQueue queue;
    protected AxisEngine engine;
    private int reapInterval = 60000;
    static Log logger = LogFactory.getLog((String)(class$org$globus$ogsa$server$ServiceThreadPool == null ? (class$org$globus$ogsa$server$ServiceThreadPool = ServiceThreadPool.class$("org.globus.ogsa.server.ServiceThreadPool")) : class$org$globus$ogsa$server$ServiceThreadPool).getName());
    static /* synthetic */ Class class$org$globus$ogsa$server$ServiceThreadPool;

    public ServiceThreadPool(ServiceRequestQueue queue, AxisEngine engine) {
        this.queue = queue;
        this.engine = engine;
        try {
            String threadReapInterval = ContainerConfig.getConfig().getOption("containerThreadsReapInterval");
            if (threadReapInterval != null) {
                this.reapInterval = Integer.parseInt(threadReapInterval);
            }
        }
        catch (Exception e) {
            logger.warn((Object)MessageUtils.toString(e));
        }
    }

    public void startThreads(int threads) {
        int i = 0;
        while (i < threads) {
            ServiceThread serviceThread = this.createThread();
            this.serviceThreads.addElement(serviceThread);
            serviceThread.start();
            ++i;
        }
    }

    public int getThreads() {
        return this.serviceThreads.size();
    }

    protected ServiceThread createThread() {
        return new ServiceThread(this.queue, this, this.engine);
    }

    public void stopThreads(int numThreads) {
        this.queue.stopThreads(numThreads);
        logger.debug((Object)("Stopping " + numThreads + " threads"));
    }

    public void stopThreads() {
        logger.debug((Object)"waitingForThreads");
        this.queue.stopThreads(this.serviceThreads.size());
    }

    public void removeThread(ServiceThread thread) {
        this.serviceThreads.removeElement(thread);
    }

    public synchronized void waitForThreads() throws InterruptedException {
        logger.debug((Object)"waitingForThreads");
        while (this.serviceThreads.size() != 0) {
            logger.debug((Object)"sweeping threads");
            Vector<ServiceThread> threadsToRemove = new Vector<ServiceThread>();
            Enumeration enumeration = this.serviceThreads.elements();
            while (enumeration.hasMoreElements()) {
                ServiceThread serviceThread = (ServiceThread)enumeration.nextElement();
                serviceThread.join(this.reapInterval / this.serviceThreads.size());
                if (serviceThread.isAlive()) continue;
                logger.debug((Object)"removing thread");
                threadsToRemove.addElement(serviceThread);
            }
            Enumeration removeEnum = threadsToRemove.elements();
            while (removeEnum.hasMoreElements()) {
                Object thread = removeEnum.nextElement();
                this.serviceThreads.remove(thread);
                logger.debug((Object)("removing thread. New size:" + this.serviceThreads.size()));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

