/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.tools.gar;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GenerateUndeploy {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            throw new Exception("Usage: GenerateUndeploy <gar file>");
        }
        JarFile jar = new JarFile(args[0]);
        String garName = new File(args[0]).getName();
        int extensionPos = garName.indexOf(".");
        if (extensionPos != -1) {
            garName = garName.substring(0, extensionPos);
        }
        FileWriter file = new FileWriter("undeploy" + File.separator + garName + "-undeploy.xml");
        PrintWriter out = new PrintWriter(file);
        out.println("<project default=\"undeploy\" basedir=\".\">");
        out.println("<path id=\"classpath\">");
        out.println("  <pathelement location=\"${java.home}/../lib/tools.jar\"/>");
        out.println("  <fileset dir=\"../lib\">");
        out.println("    <include name=\"*.jar\"/>");
        out.println("  </fileset>");
        out.println("  <pathelement path=\"${java.class.path}\"/>");
        out.println("</path>");
        out.println("<target name=\"undeploy\">");
        out.println("  <available file=\"" + garName + "-undeploy.wsdd\" " + "property=\"undeploy.available\"/>");
        out.println("  <antcall target=\"undeployDescriptor\"/>");
        Enumeration<JarEntry> enumeration = jar.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry entry = enumeration.nextElement();
            if (entry.isDirectory()) continue;
            if (entry.getName().endsWith(".jar") || entry.getName().endsWith(".LICENSE")) {
                out.println("  <delete verbose=\"true\" file=\"../lib/" + entry.getName() + "\"/>");
                continue;
            }
            if (entry.getName().startsWith("schema/")) {
                out.println("  <delete verbose=\"true\" file=\"../" + entry.getName() + "\"/>");
                continue;
            }
            if (entry.getName().startsWith("etc/")) {
                out.println("  <delete verbose=\"true\" file=\"../" + entry.getName() + "\"/>");
                continue;
            }
            if (entry.getName().startsWith("bin/")) {
                out.println("  <delete verbose=\"true\" file=\"../" + entry.getName() + "\"/>");
                continue;
            }
            if (!entry.getName().equals("server-deploy.wsdd")) continue;
            GenerateUndeploy.writeUndeployment(jar, garName, entry);
        }
        out.println("</target>");
        out.println("<target name=\"undeployDescriptor\" if=\"undeploy.available\">");
        out.println("  <echo message=\"undeploying " + garName + " from server config\"/>");
        out.println("  <java classname=\"org.apache.axis.utils.Admin\"");
        out.println("        classpathref=\"classpath\"");
        out.println("        fork=\"true\"");
        out.println("        dir=\"../\"");
        out.println("        failonerror=\"true\">");
        out.println("    <arg value=\"server\"/>");
        out.println("    <arg value=\"undeploy/" + garName + "-undeploy.wsdd\"/>");
        out.println("  </java>");
        out.println("</target>");
        out.println("</project>");
        out.flush();
        out.close();
    }

    private static void writeUndeployment(JarFile jar, String garName, ZipEntry entry) throws Exception {
        FileWriter file = new FileWriter("undeploy" + File.separator + garName + "-undeploy.wsdd");
        PrintWriter out = new PrintWriter(file);
        InputStream input = jar.getInputStream(entry);
        Document doc = XMLUtils.newDocument((InputStream)input);
        NodeList nodes = doc.getElementsByTagNameNS("http://xml.apache.org/axis/wsdd/", "service");
        out.println("<undeployment xmlns=\"http://xml.apache.org/axis/wsdd/\">");
        int i = 0;
        while (i < nodes.getLength()) {
            Element element = (Element)nodes.item(i);
            out.println("<service name=\"" + element.getAttribute("name") + "\"/>");
            ++i;
        }
        out.println("</undeployment>");
        out.flush();
        out.close();
    }
}

