/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.tools.utils.wsdl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.xml.namespace.QName;
import org.apache.axis.wsdl.toJava.Utils;
import org.globus.ogsa.tools.utils.wsdl.GWSDLExtensionRegistry;
import org.globus.ogsa.tools.utils.wsdl.GWSDLPortType;
import org.w3c.dom.Element;

public class FlattenedWSDLDefinition
implements Definition {
    private Definition copy = null;

    public FlattenedWSDLDefinition(Definition def) {
        this.copy = def;
        this.copy.setExtensionRegistry((ExtensionRegistry)new GWSDLExtensionRegistry());
    }

    private boolean hasOgsiPortType(String portTypeName) {
        boolean hasPortType = false;
        List extElts = this.copy.getExtensibilityElements();
        Iterator it = extElts.iterator();
        while (it.hasNext() && !hasPortType) {
            ExtensibilityElement elt = (ExtensibilityElement)it.next();
            if (!(elt instanceof GWSDLPortType)) continue;
            String extendsClause = ((GWSDLPortType)elt).getExtendsClause();
            StringTokenizer st = new StringTokenizer(extendsClause, " ");
            while (st.hasMoreTokens() && !hasPortType) {
                String token = st.nextToken();
                hasPortType = token.endsWith(portTypeName);
            }
        }
        return hasPortType;
    }

    public boolean hasGridService() {
        return this.hasOgsiPortType("GridService");
    }

    public boolean hasHandleResolver() {
        return this.hasOgsiPortType("HandleResolver");
    }

    public boolean hasFactory() {
        return this.hasOgsiPortType("Factory");
    }

    public boolean hasNotificationSource() {
        return this.hasOgsiPortType("NotificationSource");
    }

    public boolean hasNotificationSink() {
        return this.hasOgsiPortType("NotificationSink");
    }

    public boolean hasNotificationSubscription() {
        return this.hasOgsiPortType("NotificationSubscription");
    }

    public boolean hasServiceGroupEntry() {
        return this.hasOgsiPortType("ServiceGroupEntry");
    }

    public boolean hasServiceGroup() {
        return this.hasOgsiPortType("ServiceGroup");
    }

    public boolean hasServiceGroupRegistration() {
        return this.hasOgsiPortType("ServiceGroupRegistration");
    }

    public PortType getCustomerPortType() {
        PortType custPortType = null;
        if (this.copy.getPortTypes().isEmpty()) {
            Map services = this.copy.getServices();
            if (!services.isEmpty()) {
                Service service = (Service)services.values().iterator().next();
                custPortType = FlattenedWSDLDefinition.getCustomerPortType(service);
            }
        } else {
            custPortType = (PortType)this.copy.getPortTypes().values().iterator().next();
        }
        return custPortType;
    }

    public static PortType getCustomerPortType(Service service) {
        PortType custPortType = null;
        Map ports = service.getPorts();
        if (!ports.isEmpty()) {
            Port port = (Port)ports.values().iterator().next();
            Binding binding = port.getBinding();
            custPortType = binding.getPortType();
        }
        return custPortType;
    }

    public String getGridServiceName() {
        return FlattenedWSDLDefinition.getGridServiceName(this.getCustomerPortType());
    }

    public static String getGridServiceName(PortType portType) {
        String name = portType.getQName().getLocalPart();
        String NAME = (name = Utils.xmlNameToJavaClass((String)name)).toUpperCase();
        if (NAME.endsWith("PORTTYPE")) {
            name = name.substring(0, NAME.lastIndexOf("PORTTYPE"));
        }
        return name;
    }

    public String getPortTypeClassName() throws Exception {
        QName ptQName = this.getCustomerPortType().getQName();
        return Utils.makePackageName((String)ptQName.getNamespaceURI()) + "." + ptQName.getLocalPart();
    }

    public String getRawPortTypeClassName() throws Exception {
        QName ptQName = this.getCustomerPortType().getQName();
        return ptQName.getNamespaceURI() + "." + ptQName.getLocalPart();
    }

    public String getRawDelegatorClassName() throws Exception {
        return this.getCustomerPortType().getQName().getNamespaceURI() + "." + this.getGridServiceName();
    }

    public String getServiceClassName() throws Exception {
        return Utils.makePackageName((String)this.getCustomerPortType().getQName().getNamespaceURI()) + "." + this.getGridServiceName();
    }

    public String getDelegatorClassName() throws Exception {
        return Utils.makePackageName((String)this.getCustomerPortType().getQName().getNamespaceURI()) + "." + this.getGridServiceName() + "Provider";
    }

    public void addBinding(Binding arg0) {
        this.copy.addBinding(arg0);
    }

    public void addExtensibilityElement(ExtensibilityElement arg0) {
        this.copy.addExtensibilityElement(arg0);
    }

    public void addImport(Import arg0) {
        this.copy.addImport(arg0);
    }

    public void addMessage(Message arg0) {
        this.copy.addMessage(arg0);
    }

    public void addNamespace(String arg0, String arg1) {
        this.copy.addNamespace(arg0, arg1);
    }

    public void addPortType(PortType arg0) {
        this.copy.addPortType(arg0);
    }

    public void addService(Service arg0) {
        this.copy.addService(arg0);
    }

    public Binding createBinding() {
        return this.copy.createBinding();
    }

    public BindingFault createBindingFault() {
        return this.copy.createBindingFault();
    }

    public BindingInput createBindingInput() {
        return this.copy.createBindingInput();
    }

    public BindingOperation createBindingOperation() {
        return this.copy.createBindingOperation();
    }

    public BindingOutput createBindingOutput() {
        return this.copy.createBindingOutput();
    }

    public Fault createFault() {
        return this.copy.createFault();
    }

    public Import createImport() {
        return this.copy.createImport();
    }

    public Input createInput() {
        return this.copy.createInput();
    }

    public Message createMessage() {
        return this.copy.createMessage();
    }

    public Operation createOperation() {
        return this.copy.createOperation();
    }

    public Output createOutput() {
        return this.copy.createOutput();
    }

    public Part createPart() {
        return this.copy.createPart();
    }

    public Port createPort() {
        return this.copy.createPort();
    }

    public PortType createPortType() {
        return this.copy.createPortType();
    }

    public Service createService() {
        return this.copy.createService();
    }

    public Types createTypes() {
        return this.copy.createTypes();
    }

    public Binding getBinding(QName arg0) {
        return this.copy.getBinding(arg0);
    }

    public Map getBindings() {
        return this.copy.getBindings();
    }

    public String getDocumentBaseURI() {
        return this.copy.getDocumentBaseURI();
    }

    public Element getDocumentationElement() {
        return this.copy.getDocumentationElement();
    }

    public List getExtensibilityElements() {
        return this.copy.getExtensibilityElements();
    }

    public ExtensionRegistry getExtensionRegistry() {
        return this.copy.getExtensionRegistry();
    }

    public Map getImports() {
        return this.copy.getImports();
    }

    public List getImports(String arg0) {
        return this.copy.getImports(arg0);
    }

    public Message getMessage(QName arg0) {
        return this.copy.getMessage(arg0);
    }

    public Map getMessages() {
        return this.copy.getMessages();
    }

    public String getNamespace(String arg0) {
        return this.copy.getNamespace(arg0);
    }

    public Map getNamespaces() {
        return this.copy.getNamespaces();
    }

    public PortType getPortType(QName arg0) {
        return this.copy.getPortType(arg0);
    }

    public Map getPortTypes() {
        return this.copy.getPortTypes();
    }

    public String getPrefix(String arg0) {
        return this.copy.getPrefix(arg0);
    }

    public QName getQName() {
        return this.copy.getQName();
    }

    public Service getService(QName arg0) {
        return this.copy.getService(arg0);
    }

    public Map getServices() {
        return this.copy.getServices();
    }

    public String getTargetNamespace() {
        return this.copy.getTargetNamespace();
    }

    public Types getTypes() {
        return this.copy.getTypes();
    }

    public Binding removeBinding(QName arg0) {
        return this.copy.removeBinding(arg0);
    }

    public Message removeMessage(QName arg0) {
        return this.copy.removeMessage(arg0);
    }

    public PortType removePortType(QName arg0) {
        return this.copy.removePortType(arg0);
    }

    public Service removeService(QName arg0) {
        return this.copy.removeService(arg0);
    }

    public void setDocumentBaseURI(String arg0) {
        this.copy.setDocumentBaseURI(arg0);
    }

    public void setDocumentationElement(Element arg0) {
        this.copy.setDocumentationElement(arg0);
    }

    public void setExtensionRegistry(ExtensionRegistry arg0) {
        this.copy.setExtensionRegistry(arg0);
    }

    public void setQName(QName arg0) {
        this.copy.setQName(arg0);
    }

    public void setTargetNamespace(String arg0) {
        this.copy.setTargetNamespace(arg0);
    }

    public void setTypes(Types arg0) {
        this.copy.setTypes(arg0);
    }
}

