/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.tools.wsdl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.utils.XMLUtils;
import org.globus.ogsa.tools.CommandLineTool;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GWSDL2WSDL
extends CommandLineTool {
    public static final String WSDL_NS = "http://schemas.xmlsoap.org/wsdl/";
    public static final String XSD_NS = "http://www.w3.org/2001/XMLSchema";
    public static final String GWSDL_NS = "http://www.gridforum.org/namespaces/2003/03/gridWSDLExtensions";
    public static final String SD_NS = "http://www.gridforum.org/namespaces/2003/03/serviceData";
    private static String gwsdlFileRelative = null;
    private Hashtable operationCache = new Hashtable();
    private Hashtable portTypeCache = new Hashtable();
    private Hashtable locations = new Hashtable();
    private int nsCount = 0;
    private Element rootPortType;
    static /* synthetic */ Class class$org$globus$ogsa$tools$wsdl$GWSDL2WSDL;

    public GWSDL2WSDL(Element portType) {
        this.rootPortType = portType;
    }

    public void transform() throws FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        this.getOperations(this.rootPortType);
        this.createPortType();
    }

    private void createPortType() {
        Document doc = this.rootPortType.getOwnerDocument();
        Element element = doc.createElementNS(WSDL_NS, "portType");
        element.setAttribute("name", this.rootPortType.getAttribute("name"));
        Enumeration enumeration = this.operationCache.elements();
        while (enumeration.hasMoreElements()) {
            Element operationElement = (Element)enumeration.nextElement();
            Node node = doc.importNode(operationElement, true);
            element.appendChild(node);
        }
        doc.getDocumentElement().insertBefore(element, this.rootPortType);
    }

    public void destroy() {
        NodeList localOperations = this.rootPortType.getElementsByTagNameNS(WSDL_NS, "operation");
        while (localOperations.getLength() != 0) {
            this.rootPortType.removeChild(localOperations.item(0));
        }
    }

    private void getOperations(Element portType) throws FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        NodeList localOperations = portType.getElementsByTagNameNS(WSDL_NS, "operation");
        int op = 0;
        while (op < localOperations.getLength()) {
            Element originalOperation = (Element)localOperations.item(op);
            Element localOperation = (Element)originalOperation.cloneNode(true);
            NodeList parts = localOperation.getChildNodes();
            int i = 0;
            while (i < parts.getLength()) {
                Element localElement;
                String message;
                if (parts.item(i) instanceof Element && (message = (localElement = (Element)parts.item(i)).getAttribute("message")) != null && !message.equals("")) {
                    QName messageQName = XMLUtils.getQNameFromString((String)message, (Node)originalOperation);
                    String newNS = "ns" + this.nsCount++;
                    localElement.setAttribute("xmlns:" + newNS, messageQName.getNamespaceURI());
                    localElement.setAttribute("message", newNS + ":" + messageQName.getLocalPart());
                }
                ++i;
            }
            this.operationCache.put(localOperation.getAttribute("name"), localOperation);
            ++op;
        }
        String extendedPortTypes = portType.getAttribute("extends");
        if (extendedPortTypes != null) {
            StringTokenizer tokenizer = new StringTokenizer(extendedPortTypes, " ");
            while (tokenizer.hasMoreTokens()) {
                String extendedPortTypeString = tokenizer.nextToken();
                QName extendedPortType = XMLUtils.getQNameFromString((String)extendedPortTypeString, (Node)portType);
                this.loadNamespace(extendedPortType.getNamespaceURI(), portType);
                Element portTypeElement = (Element)this.portTypeCache.get(extendedPortType);
                if (portTypeElement != null) {
                    this.getOperations(portTypeElement);
                    continue;
                }
                throw new IOException("Port type not defined: " + extendedPortType);
            }
        }
    }

    private void loadNamespace(String namespace, Element localPortType) throws FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        Element definitionsElement = (Element)localPortType.getParentNode();
        String tns = definitionsElement.getAttribute("targetNamespace");
        if (tns.equals(namespace)) {
            this.loadLocalNamespace(namespace, definitionsElement);
        }
        this.loadRemoteNamespace(namespace, definitionsElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRemoteNamespace(String namespace, Element definitionsElement) throws FileNotFoundException, ParserConfigurationException, SAXException, IOException {
        NodeList nodes = definitionsElement.getElementsByTagNameNS(WSDL_NS, "import");
        int i = 0;
        while (i < nodes.getLength()) {
            Element importElement = (Element)nodes.item(i);
            String importNamespace = importElement.getAttribute("namespace");
            if (namespace.equals(importNamespace)) {
                Object var15_16;
                QName docName = new QName(definitionsElement.getAttribute("targetNamespace"), definitionsElement.getAttribute("name"));
                String rootFile = (String)this.locations.get(docName);
                if (rootFile == null) {
                    rootFile = gwsdlFileRelative;
                }
                String location = importElement.getAttribute("location");
                File gwsdl = new File(rootFile);
                File actualLocation = new File(gwsdl.getParentFile(), location);
                FileInputStream input = new FileInputStream(actualLocation);
                Document doc = null;
                try {
                    doc = XMLUtils.newDocument((InputStream)input);
                    var15_16 = null;
                }
                catch (Throwable throwable) {
                    var15_16 = null;
                    input.close();
                    throw throwable;
                }
                input.close();
                this.loadLocalNamespace(namespace, doc.getDocumentElement());
                Element rootElement = doc.getDocumentElement();
                String importedNamespace = rootElement.getAttribute("targetNamespace");
                QName importedDoc = new QName(importedNamespace, rootElement.getAttribute("name"));
                this.locations.put(importedDoc, actualLocation.getPath());
            }
            ++i;
        }
    }

    private void loadLocalNamespace(String targetNamespace, Element definitionsElement) {
        NodeList portTypes = definitionsElement.getElementsByTagNameNS(GWSDL_NS, "portType");
        int i = 0;
        while (i < portTypes.getLength()) {
            Element portType = (Element)portTypes.item(i);
            this.portTypeCache.put(new QName(targetNamespace, portType.getAttribute("name")), portType);
            ++i;
        }
    }

    private static void mergeNamespaces(Element srcElement, Element dstElement) {
        NamedNodeMap srcAttributes = srcElement.getAttributes();
        NamedNodeMap dstAttributes = dstElement.getAttributes();
        int len = srcAttributes.getLength();
        int i = 0;
        while (i < len) {
            String attrName;
            Node attr = srcAttributes.item(i);
            String ns = attr.getNamespaceURI();
            String prefix = attr.getPrefix();
            if (ns != null && ns.equals("http://www.w3.org/2000/xmlns/") && prefix != null && prefix.equals("xmlns") && dstAttributes.getNamedItem(attrName = "xmlns:" + attr.getLocalName()) == null) {
                dstElement.setAttribute(attrName, attr.getNodeValue());
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: " + (class$org$globus$ogsa$tools$wsdl$GWSDL2WSDL == null ? (class$org$globus$ogsa$tools$wsdl$GWSDL2WSDL = GWSDL2WSDL.class$("org.globus.ogsa.tools.wsdl.GWSDL2WSDL")) : class$org$globus$ogsa$tools$wsdl$GWSDL2WSDL).getName() + " <gwsdl file> <wsdl file>");
            CommandLineTool.sysExit(1);
        }
        FileOutputStream wsdlOutput = null;
        FileOutputStream schemaOutput = null;
        FileInputStream gwsdlInput = null;
        try {
            NodeList gwsdlDefinitions;
            String gwsdlFile = gwsdlFileRelative = args[0];
            String wsdlFile = args[1];
            gwsdlInput = new FileInputStream(gwsdlFile);
            Document gwsdlDoc = XMLUtils.newDocument((InputStream)gwsdlInput);
            if (gwsdlDoc == null) {
                System.err.println("Error: gwsdl file not found: " + gwsdlFile);
                CommandLineTool.sysExit(1);
            }
            if ((gwsdlDefinitions = gwsdlDoc.getElementsByTagNameNS(WSDL_NS, "definitions")).getLength() < 1) {
                System.err.println("Error: no definition found in " + gwsdlFile);
                CommandLineTool.sysExit(1);
            }
            NodeList schemas = gwsdlDoc.getElementsByTagNameNS(XSD_NS, "schema");
            Element schemaElement = null;
            if (schemas.getLength() > 0) {
                schemaElement = (Element)schemas.item(0);
                Node currentParent = schemaElement.getParentNode();
                while (currentParent != null) {
                    if (currentParent instanceof Element) {
                        GWSDL2WSDL.mergeNamespaces((Element)currentParent, schemaElement);
                    }
                    currentParent = currentParent.getParentNode();
                }
            }
            NodeList gwsdlPortTypes = gwsdlDoc.getElementsByTagNameNS(GWSDL_NS, "portType");
            GWSDL2WSDL[] transformers = new GWSDL2WSDL[gwsdlPortTypes.getLength()];
            int i = 0;
            while (i < gwsdlPortTypes.getLength()) {
                transformers[i] = new GWSDL2WSDL((Element)gwsdlPortTypes.item(i));
                transformers[i].transform();
                ++i;
            }
            int i2 = 0;
            while (i2 < gwsdlPortTypes.getLength()) {
                transformers[i2].destroy();
                ++i2;
            }
            wsdlOutput = new FileOutputStream(wsdlFile);
            XMLUtils.DocumentToStream((Document)gwsdlDoc, (OutputStream)wsdlOutput);
            wsdlOutput.flush();
            if (schemaElement != null) {
                Document schemaDoc = XMLUtils.newDocument();
                Node schemaNode = schemaDoc.importNode(schemaElement, true);
                schemaDoc.appendChild(schemaNode);
                NodeList serviceData = gwsdlDoc.getElementsByTagNameNS(SD_NS, "serviceData");
                int len = serviceData.getLength();
                if (len > 0) {
                    String ns = schemaElement.getAttribute("xmlns");
                    if (ns == null || ns.length() == 0) {
                        ((Element)schemaNode).setAttribute("xmlns", XSD_NS);
                    } else if (!ns.equals(XSD_NS)) {
                        throw new Exception("Default namespace should be 'http://www.w3.org/2001/XMLSchema'");
                    }
                }
                int i3 = 0;
                while (i3 < len) {
                    Element serviceDataElement = (Element)serviceData.item(i3);
                    Element element = schemaDoc.createElementNS(XSD_NS, "element");
                    element.setAttribute("name", serviceDataElement.getAttribute("name"));
                    element.setAttribute("type", serviceDataElement.getAttribute("type"));
                    String nillable = serviceDataElement.getAttribute("nillable");
                    if (nillable != null) {
                        element.setAttribute("nillable", nillable);
                    }
                    schemaNode.appendChild(element);
                    ++i3;
                }
                int extensionIndex = wsdlFile.indexOf(".");
                if (extensionIndex == -1) {
                    extensionIndex = wsdlFile.length();
                }
                String schemaFile = wsdlFile.substring(0, extensionIndex) + ".xsd";
                schemaOutput = new FileOutputStream(schemaFile);
                XMLUtils.DocumentToStream((Document)schemaDoc, (OutputStream)schemaOutput);
                schemaOutput.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            CommandLineTool.sysExit(1);
        }
        finally {
            if (gwsdlInput != null) {
                try {
                    gwsdlInput.close();
                }
                catch (Exception io) {}
            }
            if (wsdlOutput != null) {
                try {
                    wsdlOutput.close();
                }
                catch (Exception io) {}
            }
            if (schemaOutput != null) {
                try {
                    schemaOutput.close();
                }
                catch (Exception io) {}
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

