/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.tools.wsdl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.axis.utils.XMLUtils;
import org.globus.ogsa.tools.CommandLineTool;
import org.globus.ogsa.tools.wsdl.RelativePathUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GenerateBinding
extends CommandLineTool {
    public static final String WSDL_NS = "http://schemas.xmlsoap.org/wsdl/";
    public static final String SOAP_NS = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String HTTP_NS = "http://schemas.xmlsoap.org/soap/http";
    public static final String GSDL_NS = "http://www.gridforum.org/namespaces/2002/10/gridServices";
    private static String ADDRESS = "localhost:8080/ogsa/services/";
    private static String PROTOCOL = "http";
    private static boolean generateServicePortType = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: GenerateBinding <port type file> <service file> |protocol(default http)|");
            return;
        }
        if (args.length > 2) {
            PROTOCOL = args[2];
        }
        FileOutputStream bindingOutput = null;
        FileOutputStream serviceOutput = null;
        FileInputStream input = null;
        String generatePortTypeString = System.getProperty("org.globus.ogsa.wsdl.generateServicePortType");
        generateServicePortType = generatePortTypeString != null && generatePortTypeString.equalsIgnoreCase("true");
        try {
            NodeList portTypeDefinitions;
            String portTypeFile = args[0];
            String fileRoot = args[1];
            portTypeFile = new File(portTypeFile).getCanonicalPath();
            input = new FileInputStream(portTypeFile);
            Document portTypeDoc = XMLUtils.newDocument((InputStream)input);
            if (portTypeDoc == null) {
                System.err.println("Error: portType file not found: " + portTypeFile);
                CommandLineTool.sysExit(1);
            }
            if ((portTypeDefinitions = portTypeDoc.getElementsByTagNameNS(WSDL_NS, "definitions")).getLength() < 1) {
                System.err.println("Error: no definition found in " + portTypeFile);
                CommandLineTool.sysExit(1);
            }
            String portTypeNS = ((Element)portTypeDefinitions.item(0)).getAttribute("targetNamespace");
            String definitionName = ((Element)portTypeDefinitions.item(0)).getAttribute("name");
            NodeList portTypeNodes = portTypeDoc.getElementsByTagNameNS(WSDL_NS, "portType");
            if (portTypeNodes.getLength() < 1) {
                System.err.println("Error: no portType found in " + portTypeFile);
                CommandLineTool.sysExit(1);
            }
            String bindingNS = portTypeNS + "/bindings";
            String bindingFile = fileRoot + "_bindings.wsdl";
            String relativePortTypeFile = RelativePathUtil.getRelativeFileName(new File(portTypeFile), new File(bindingFile));
            String serviceFile = fileRoot.endsWith("service") ? fileRoot + ".wsdl" : fileRoot + "_service.wsdl";
            String relativeBindingFile = RelativePathUtil.getRelativeFileName(new File(bindingFile), new File(serviceFile));
            String portTypePrefix = definitionName.toLowerCase();
            String bindingPrefix = portTypePrefix + "binding";
            Element bindingDefinition = GenerateBinding.getSOAPBindingDefinition(definitionName, relativePortTypeFile, portTypePrefix, portTypeNS, bindingNS);
            Element serviceElement = GenerateBinding.getSOAPServiceElement(definitionName, relativeBindingFile, bindingPrefix, bindingNS, portTypePrefix, portTypeNS);
            String bindingName = definitionName + "SOAPBinding";
            boolean singlePortType = false;
            if (portTypeNodes.getLength() == 1) {
                singlePortType = true;
            }
            int i = 0;
            while (i < portTypeNodes.getLength()) {
                String portTypeName = ((Element)portTypeNodes.item(i)).getAttribute("name");
                Hashtable operations = GenerateBinding.getOperations((Element)portTypeNodes.item(i));
                if (!singlePortType) {
                    bindingName = portTypeName + "SOAPBinding";
                }
                GenerateBinding.setSOAPBinding(bindingDefinition, definitionName.toLowerCase(), portTypeName, portTypeNS, bindingName, operations);
                GenerateBinding.setSOAPService(singlePortType, serviceElement, definitionName, bindingPrefix, bindingName, portTypePrefix, portTypeName);
                ++i;
            }
            Document bindingDoc = bindingDefinition.getOwnerDocument();
            Document serviceDoc = serviceElement.getOwnerDocument();
            bindingOutput = new FileOutputStream(bindingFile);
            XMLUtils.DocumentToStream((Document)bindingDoc, (OutputStream)bindingOutput);
            bindingOutput.flush();
            serviceOutput = new FileOutputStream(serviceFile);
            XMLUtils.DocumentToStream((Document)serviceDoc, (OutputStream)serviceOutput);
            serviceOutput.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            CommandLineTool.sysExit(1);
        }
        finally {
            if (bindingOutput != null) {
                try {
                    bindingOutput.close();
                }
                catch (Exception io) {}
            }
            if (serviceOutput != null) {
                try {
                    serviceOutput.close();
                }
                catch (Exception io) {}
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception io) {}
            }
        }
    }

    private static Hashtable getOperations(Element element) {
        NodeList operationNodes = element.getElementsByTagNameNS(WSDL_NS, "operation");
        Hashtable<String, Object> operations = new Hashtable<String, Object>();
        int i = 0;
        while (i < operationNodes.getLength()) {
            ArrayList faults = GenerateBinding.getFaults((Element)operationNodes.item(i));
            NodeList output = ((Element)operationNodes.item(i)).getElementsByTagNameNS(WSDL_NS, "output");
            if (output.getLength() > 0) {
                operations.put(((Element)operationNodes.item(i)).getAttribute("name"), faults);
            } else {
                operations.put(((Element)operationNodes.item(i)).getAttribute("name"), new Object());
            }
            ++i;
        }
        return operations;
    }

    private static ArrayList getFaults(Element element) {
        ArrayList<String> result = new ArrayList<String>();
        NodeList faultNodes = element.getElementsByTagNameNS(WSDL_NS, "fault");
        int i = 0;
        while (i < faultNodes.getLength()) {
            result.add(((Element)faultNodes.item(i)).getAttribute("name"));
            ++i;
        }
        return result;
    }

    private static Element getSOAPBindingDefinition(String definitionName, String portTypeFile, String portTypePrefix, String portTypeNS, String bindingNS) throws Exception {
        Document doc = XMLUtils.newDocument();
        Element definition = doc.createElement("definitions");
        doc.appendChild(definition);
        definition.setAttribute("name", definitionName);
        definition.setAttribute("targetNamespace", bindingNS);
        definition.setAttribute("xmlns:" + portTypePrefix, portTypeNS);
        definition.setAttribute("xmlns", WSDL_NS);
        definition.setAttribute("xmlns:soap", SOAP_NS);
        Element importElement = doc.createElement("import");
        importElement.setAttribute("location", portTypeFile);
        importElement.setAttribute("namespace", portTypeNS);
        definition.appendChild(importElement);
        return definition;
    }

    private static void setSOAPBinding(Element definition, String portTypePrefix, String portTypeName, String portTypeNS, String bindingName, Hashtable operations) throws Exception {
        Document doc = definition.getOwnerDocument();
        Element binding = doc.createElement("binding");
        binding.setAttribute("name", bindingName);
        binding.setAttribute("type", portTypePrefix + ":" + portTypeName);
        Element soapBinding = doc.createElement("soap:binding");
        soapBinding.setAttribute("style", "document");
        soapBinding.setAttribute("transport", HTTP_NS);
        binding.appendChild(soapBinding);
        Enumeration enumeration = operations.keys();
        while (enumeration.hasMoreElements()) {
            Element operation = doc.createElement("operation");
            Element soapOperation = doc.createElement("soap:operation");
            String operationName = (String)enumeration.nextElement();
            operation.setAttribute("name", operationName);
            soapOperation.setAttribute("soapAction", portTypeNS + "#" + operationName);
            Element input = doc.createElement("input");
            Element soapBody = doc.createElement("soap:body");
            soapBody.setAttribute("use", "literal");
            soapBody.setAttribute("namespace", portTypeNS);
            operation.appendChild(soapOperation);
            operation.appendChild(input);
            input.appendChild(soapBody);
            binding.appendChild(operation);
            Object obj = operations.get(operationName);
            if (!(obj instanceof ArrayList)) continue;
            Element output = doc.createElement("output");
            operation.appendChild(output);
            output.appendChild(soapBody.cloneNode(true));
            ArrayList faults = (ArrayList)obj;
            Iterator iterator = faults.iterator();
            while (iterator.hasNext()) {
                String faultName = (String)iterator.next();
                Element fault = doc.createElement("fault");
                fault.setAttribute("name", faultName);
                Element soapFault = doc.createElement("soap:fault");
                soapFault.setAttribute("name", faultName);
                soapFault.setAttribute("use", "literal");
                fault.appendChild(soapFault);
                operation.appendChild(fault);
            }
        }
        definition.appendChild(binding);
    }

    private static Element getSOAPServiceElement(String definitionName, String bindingFile, String bindingPrefix, String bindingNS, String portTypePrefix, String portTypeNS) throws Exception {
        Document doc = XMLUtils.newDocument();
        Element definition = doc.createElement("definitions");
        doc.appendChild(definition);
        definition.setAttribute("name", definitionName);
        definition.setAttribute("targetNamespace", portTypeNS + "/service");
        definition.setAttribute("xmlns:" + bindingPrefix, bindingNS);
        definition.setAttribute("xmlns", WSDL_NS);
        definition.setAttribute("xmlns:soap", SOAP_NS);
        Element importElement = doc.createElement("import");
        importElement.setAttribute("location", bindingFile);
        importElement.setAttribute("namespace", bindingNS);
        Element service = doc.createElement("service");
        definition.appendChild(importElement);
        definition.appendChild(service);
        if (generateServicePortType) {
            definition.setAttribute("xmlns:gsdl", GSDL_NS);
            definition.setAttribute("xmlns:" + portTypePrefix, portTypeNS);
        }
        return service;
    }

    private static void setSOAPService(boolean singlePortType, Element service, String definitionName, String bindingPrefix, String bindingName, String portTypePrefix, String portTypeName) throws Exception {
        Document doc = service.getOwnerDocument();
        if (generateServicePortType) {
            Element instanceOfElement = doc.createElement("gsdl:instanceOf");
            instanceOfElement.setAttribute("type", portTypePrefix + ":" + portTypeName);
            service.appendChild(instanceOfElement);
        }
        if (definitionName.endsWith("Service")) {
            service.setAttribute("name", definitionName);
        } else {
            service.setAttribute("name", definitionName + "Service");
        }
        Element port = doc.createElement("port");
        port.setAttribute("binding", bindingPrefix + ":" + bindingName);
        if (singlePortType) {
            port.setAttribute("name", definitionName + "Port");
        } else {
            port.setAttribute("name", portTypeName + "Port");
        }
        Element address = doc.createElement("soap:address");
        address.setAttribute("location", PROTOCOL + "://" + ADDRESS);
        port.appendChild(address);
        service.appendChild(port);
    }
}

