/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ogsa.tools.wsdl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.Service;
import org.apache.axis.utils.JavaUtils;
import org.apache.axis.utils.Messages;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.PortTypeEntry;
import org.apache.axis.wsdl.symbolTable.ServiceEntry;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.toJava.Emitter;
import org.apache.axis.wsdl.toJava.JavaBindingWriter;
import org.apache.axis.wsdl.toJava.JavaClassWriter;
import org.apache.axis.wsdl.toJava.Utils;

public class JavaGridServiceImplWriter
extends JavaClassWriter {
    private ServiceEntry sEntry;
    private SymbolTable symbolTable;

    protected JavaGridServiceImplWriter(Emitter emitter, ServiceEntry sEntry, SymbolTable symbolTable) {
        super(emitter, sEntry.getName() + "GridLocator", "service");
        this.sEntry = sEntry;
        this.symbolTable = symbolTable;
    }

    protected String getExtendsText() {
        return "extends org.globus.ogsa.impl.core.service.ServiceLocator ";
    }

    protected String getImplementsText() {
        return "implements org.globus.ogsa.GridLocator ";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        Service service = this.sEntry.getService();
        Map portMap = service.getPorts();
        Iterator portIterator = portMap.values().iterator();
        while (portIterator.hasNext()) {
            Port p = (Port)portIterator.next();
            Binding binding = p.getBinding();
            if (binding == null) {
                throw new IOException(Messages.getMessage((String)"emitFailNoBinding01", (String[])new String[]{p.getName()}));
            }
            BindingEntry bEntry = this.symbolTable.getBindingEntry(binding.getQName());
            if (bEntry == null) {
                throw new IOException(Messages.getMessage((String)"emitFailNoBindingEntry01", (String[])new String[]{binding.getQName().toString()}));
            }
            PortTypeEntry ptEntry = this.symbolTable.getPortTypeEntry(binding.getPortType().getQName());
            if (ptEntry == null) {
                throw new IOException(Messages.getMessage((String)"emitFailNoPortType01", (String[])new String[]{binding.getPortType().getQName().toString()}));
            }
            if (bEntry.getBindingType() != 0) continue;
            String portName = p.getName();
            if (!JavaUtils.isJavaId((String)portName)) {
                portName = Utils.xmlNameToJavaClass((String)portName);
            }
            String stubClass = bEntry.getName() + "Stub";
            String bindingType = (String)bEntry.getDynamicVar((Object)JavaBindingWriter.INTERFACE_NAME);
            pw.println("    public " + bindingType + " get" + portName + "(org.gridforum.ogsi.HandleType handle) " + "throws org.gridforum.ogsi.FaultType, org.globus.ogsa.GridServiceException {");
            pw.println("        setStubClass(" + stubClass + ".class);");
            pw.println("        return (" + bindingType + ") getServicePort(handle);");
            pw.println("    }");
            pw.println("    public " + bindingType + " get" + portName + "(org.gridforum.ogsi.LocatorType locator) " + "throws org.gridforum.ogsi.FaultType, org.globus.ogsa.GridServiceException {");
            pw.println("        setStubClass(" + stubClass + ".class);");
            pw.println("        return (" + bindingType + ") getServicePort(locator);");
            pw.println("    }");
            pw.println("    public " + bindingType + " get" + portName + "(java.net.URL url) " + "throws org.globus.ogsa.GridServiceException {");
            pw.println("        setStubClass(" + stubClass + ".class);");
            pw.println("        return (" + bindingType + ") getServicePort(url);");
            pw.println("    }");
        }
        pw.println();
    }
}

